/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.RowFactory;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.tools.CompressTool;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;

public class Set
extends Prepared {
    private final int type;
    private Expression expression;
    private String stringValue;
    private String[] stringValueList;

    public Set(Session session, int n2) {
        super(session);
        this.type = n2;
    }

    public void setString(String string) {
        this.stringValue = string;
    }

    @Override
    public boolean isTransactional() {
        switch (this.type) {
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 20: 
            case 26: 
            case 28: 
            case 35: 
            case 36: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Database database = this.session.getDatabase();
        String string = SetTypes.getTypeName(this.type);
        block5 : switch (this.type) {
            case 24: {
                this.session.getUser().checkAdmin();
                int n2 = this.getIntValue();
                if (n2 < 0 || n2 > 2) {
                    throw DbException.getInvalidValueException("ALLOW_LITERALS", this.getIntValue());
                }
                database.setAllowLiterals(n2);
                this.addOrUpdateSetting(string, null, n2);
                break;
            }
            case 8: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("CACHE_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setCacheSize(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 13: {
                Session session;
                String string2;
                if ("TRUE".equals(this.stringValue) || (string2 = StringUtils.quoteStringSQL(this.stringValue)).equals(database.getCluster())) break;
                if (!string2.equals("''")) {
                    this.session.getUser().checkAdmin();
                }
                database.setCluster(string2);
                Session session2 = session = database.getSystemSession();
                synchronized (session2) {
                    Database database2 = database;
                    synchronized (database2) {
                        this.addOrUpdateSetting(session, string, string2, 0);
                        session.commit(true);
                    }
                }
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                boolean bl2 = database.getCompareMode().isBinaryUnsigned();
                StringBuilder stringBuilder = new StringBuilder(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = CompareMode.getInstance(null, 0, bl2);
                } else {
                    int n3 = this.getIntValue();
                    stringBuilder.append(" STRENGTH ");
                    if (n3 == 3) {
                        stringBuilder.append("IDENTICAL");
                    } else if (n3 == 0) {
                        stringBuilder.append("PRIMARY");
                    } else if (n3 == 1) {
                        stringBuilder.append("SECONDARY");
                    } else if (n3 == 2) {
                        stringBuilder.append("TERTIARY");
                    }
                    compareMode = CompareMode.getInstance(this.stringValue, n3, bl2);
                }
                CompareMode compareMode2 = database.getCompareMode();
                if (compareMode2.equals(compareMode)) break;
                Table table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90089, table.getSQL());
                }
                this.addOrUpdateSetting(string, stringBuilder.toString(), 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 38: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                Table table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90089, table.getSQL());
                }
                CompareMode compareMode3 = database.getCompareMode();
                if (this.stringValue.equals("SIGNED")) {
                    compareMode = CompareMode.getInstance(compareMode3.getName(), compareMode3.getStrength(), false);
                } else if (this.stringValue.equals("UNSIGNED")) {
                    compareMode = CompareMode.getInstance(compareMode3.getName(), compareMode3.getStrength(), true);
                } else {
                    throw DbException.getInvalidValueException("BINARY_COLLATION", this.stringValue);
                }
                this.addOrUpdateSetting(string, this.stringValue, 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 23: {
                this.session.getUser().checkAdmin();
                int n4 = CompressTool.getCompressAlgorithm(this.stringValue);
                database.setLobCompressionAlgorithm(n4 == 0 ? null : this.stringValue);
                this.addOrUpdateSetting(string, this.stringValue, 0);
                break;
            }
            case 34: {
                this.session.getUser().checkAdmin();
                if (!database.isStarting()) break;
                int n5 = this.getIntValue();
                this.addOrUpdateSetting(string, null, n5);
                break;
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListenerClass(this.stringValue);
                break;
            }
            case 18: {
                int n6 = this.getIntValue();
                if (n6 != -1 && n6 < 0) {
                    throw DbException.getInvalidValueException("DB_CLOSE_DELAY", n6);
                }
                this.session.getUser().checkAdmin();
                database.setCloseDelay(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 6: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("DEFAULT_LOCK_TIMEOUT", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                database.setDefaultTableType(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 33: {
                this.session.getUser().checkAdmin();
                int n7 = this.getIntValue();
                switch (n7) {
                    case 0: {
                        database.setExclusiveSession(null, false);
                        break block5;
                    }
                    case 1: {
                        database.setExclusiveSession(this.session, false);
                        break block5;
                    }
                    case 2: {
                        database.setExclusiveSession(this.session, true);
                        break block5;
                    }
                }
                throw DbException.getInvalidValueException("EXCLUSIVE", n7);
            }
            case 39: {
                this.session.getUser().checkAdmin();
                Table table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90141, table.getSQL());
                }
                database.setJavaObjectSerializerName(this.stringValue);
                this.addOrUpdateSetting(string, this.stringValue, 0);
                break;
            }
            case 1: {
                this.session.getUser().checkAdmin();
                database.setIgnoreCase(this.getIntValue() == 1);
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                database.setLockMode(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 5: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("LOCK_TIMEOUT", this.getIntValue());
                }
                this.session.setLockTimeout(this.getIntValue());
                break;
            }
            case 19: {
                int n8 = this.getIntValue();
                if (!database.isPersistent() || n8 == database.getLogMode()) break;
                this.session.getUser().checkAdmin();
                database.setLogMode(n8);
                break;
            }
            case 22: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_LENGTH_INPLACE_LOB", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxLengthInplaceLob(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 2: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_LOG_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxLogSize((long)this.getIntValue() * 1024L * 1024L);
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 16: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_ROWS", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryRows(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 21: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_UNDO", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryUndo(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 32: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_OPERATION_MEMORY", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                int n9 = this.getIntValue();
                database.setMaxOperationMemory(n9);
                break;
            }
            case 3: {
                Mode mode = Mode.getInstance(this.stringValue);
                if (mode == null) {
                    throw DbException.get(90088, this.stringValue);
                }
                if (database.getMode() == mode) break;
                this.session.getUser().checkAdmin();
                database.setMode(mode);
                break;
            }
            case 25: {
                this.session.getUser().checkAdmin();
                database.setMultiThreaded(this.getIntValue() == 1);
                break;
            }
            case 31: {
                if (database.isMultiVersion() == (this.getIntValue() == 1)) break;
                throw DbException.get(90133, "MVCC");
            }
            case 27: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.getIntValue() != 0);
                break;
            }
            case 36: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("QUERY_TIMEOUT", this.getIntValue());
                }
                int n10 = this.getIntValue();
                this.session.setQueryTimeout(n10);
                break;
            }
            case 37: {
                int n11 = this.getIntValue();
                this.session.setRedoLogBinary(n11 == 1);
                break;
            }
            case 30: {
                this.session.getUser().checkAdmin();
                int n12 = this.getIntValue();
                if (n12 < 0 || n12 > 1) {
                    throw DbException.getInvalidValueException("REFERENTIAL_INTEGRITY", this.getIntValue());
                }
                database.setReferentialIntegrity(n12 == 1);
                break;
            }
            case 41: {
                this.session.getUser().checkAdmin();
                int n13 = this.getIntValue();
                if (n13 < 0 || n13 > 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS", this.getIntValue());
                }
                database.setQueryStatistics(n13 == 1);
                break;
            }
            case 42: {
                this.session.getUser().checkAdmin();
                int n14 = this.getIntValue();
                if (n14 < 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS_MAX_ENTRIES", this.getIntValue());
                }
                database.setQueryStatisticsMaxEntries(n14);
                break;
            }
            case 26: {
                Schema schema = database.getSchema(this.stringValue);
                this.session.setCurrentSchema(schema);
                break;
            }
            case 28: {
                this.session.setSchemaSearchPath(this.stringValueList);
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                if (this.getCurrentObjectId() != 0) break;
                database.getTraceSystem().setLevelFile(this.getIntValue());
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                if (this.getCurrentObjectId() != 0) break;
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                break;
            }
            case 11: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("TRACE_MAX_FILE_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                int n15 = this.getIntValue() * 1024 * 1024;
                database.getTraceSystem().setMaxFileSize(n15);
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 20: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("THROTTLE", this.getIntValue());
                }
                this.session.setThrottle(this.getIntValue());
                break;
            }
            case 29: {
                int n16 = this.getIntValue();
                if (n16 < 0 || n16 > 1) {
                    throw DbException.getInvalidValueException("UNDO_LOG", this.getIntValue());
                }
                this.session.setUndoLogEnabled(n16 == 1);
                break;
            }
            case 35: {
                Expression expression = this.expression.optimize(this.session);
                this.session.setVariable(this.stringValue, expression.getValue(this.session));
                break;
            }
            case 14: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("WRITE_DELAY", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setWriteDelay(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 40: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("RETENTION_TIME", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setRetentionTime(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 43: {
                RowFactory rowFactory;
                this.session.getUser().checkAdmin();
                String string3 = this.expression.getColumnName();
                Class clazz = JdbcUtils.loadUserClass(string3);
                try {
                    rowFactory = (RowFactory)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
                database.setRowFactory(rowFactory);
                break;
            }
            case 44: {
                int n17 = this.getIntValue();
                if (n17 != 0 && n17 != 1) {
                    throw DbException.getInvalidValueException("BATCH_JOINS", this.getIntValue());
                }
                this.session.setJoinBatchEnabled(n17 == 1);
                break;
            }
            case 45: {
                int n18 = this.getIntValue();
                if (n18 != 0 && n18 != 1) {
                    throw DbException.getInvalidValueException("FORCE_JOIN_ORDER", this.getIntValue());
                }
                this.session.setForceJoinOrder(n18 == 1);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        database.getNextModificationDataId();
        database.getNextModificationMetaId();
        return 0;
    }

    private int getIntValue() {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int n2) {
        this.expression = ValueExpression.get(ValueInt.get(n2));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String string, String string2, int n2) {
        this.addOrUpdateSetting(this.session, string, string2, n2);
    }

    private void addOrUpdateSetting(Session session, String string, String string2, int n2) {
        Database database = session.getDatabase();
        if (database.isReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(string);
        boolean bl2 = false;
        if (setting == null) {
            bl2 = true;
            int n3 = this.getObjectId();
            setting = new Setting(database, n3, string);
        }
        if (string2 != null) {
            if (!bl2 && setting.getStringValue().equals(string2)) {
                return;
            }
            setting.setStringValue(string2);
        } else {
            if (!bl2 && setting.getIntValue() == n2) {
                return;
            }
            setting.setIntValue(n2);
        }
        if (bl2) {
            database.addDatabaseObject(session, setting);
        } else {
            database.updateMeta(session, setting);
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setStringArray(String[] stringArray) {
        this.stringValueList = stringArray;
    }

    @Override
    public int getType() {
        return 67;
    }
}

