/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public class SelectUnion
extends Query {
    public static final int UNION = 0;
    public static final int UNION_ALL = 1;
    public static final int EXCEPT = 2;
    public static final int INTERSECT = 3;
    private int unionType;
    private final Query left;
    private Query right;
    private ArrayList<Expression> expressions;
    private Expression[] expressionArray;
    private ArrayList<SelectOrderBy> orderList;
    private SortOrder sort;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean isForUpdate;

    public SelectUnion(Session session, Query query) {
        super(session);
        this.left = query;
    }

    @Override
    public boolean isUnion() {
        return true;
    }

    @Override
    public void prepareJoinBatch() {
        this.left.prepareJoinBatch();
        this.right.prepareJoinBatch();
    }

    public void setUnionType(int n2) {
        this.unionType = n2;
    }

    public int getUnionType() {
        return this.unionType;
    }

    public void setRight(Query query) {
        this.right = query;
    }

    public Query getLeft() {
        return this.left;
    }

    public Query getRight() {
        return this.right;
    }

    @Override
    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    @Override
    public void setOrder(ArrayList<SelectOrderBy> arrayList) {
        this.orderList = arrayList;
    }

    @Override
    public boolean hasOrder() {
        return this.orderList != null || this.sort != null;
    }

    private Value[] convert(Value[] valueArray, int n2) {
        Value[] valueArray2 = n2 == valueArray.length ? valueArray : new Value[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = this.expressions.get(i2);
            valueArray2[i2] = valueArray[i2].convertTo(expression.getType());
        }
        return valueArray2;
    }

    @Override
    public ResultInterface queryMeta() {
        int n2 = this.left.getColumnCount();
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, n2);
        localResult.done();
        return localResult;
    }

    public LocalResult getEmptyResult() {
        int n2 = this.left.getColumnCount();
        return new LocalResult(this.session, this.expressionArray, n2);
    }

    @Override
    protected LocalResult queryWithoutCache(int n2, ResultTarget resultTarget) {
        Object object;
        int n3;
        Object object2;
        if (n2 != 0) {
            n3 = this.limitExpr == null ? -1 : ((object2 = this.limitExpr.getValue(this.session)) == ValueNull.INSTANCE ? -1 : ((Value)object2).getInt());
            n3 = n3 < 0 ? n2 : Math.min(n3, n2);
            this.limitExpr = ValueExpression.get(ValueInt.get(n3));
        }
        if (this.session.getDatabase().getSettings().optimizeInsertFromSelect && this.unionType == 1 && resultTarget != null && this.sort == null && !this.distinct && n2 == 0 && this.offsetExpr == null && this.limitExpr == null) {
            this.left.query(0, resultTarget);
            this.right.query(0, resultTarget);
            return null;
        }
        n3 = this.left.getColumnCount();
        object2 = new LocalResult(this.session, this.expressionArray, n3);
        if (this.sort != null) {
            ((LocalResult)object2).setSortOrder(this.sort);
        }
        if (this.distinct) {
            this.left.setDistinct(true);
            this.right.setDistinct(true);
            ((LocalResult)object2).setDistinct();
        }
        if (this.randomAccessResult) {
            ((LocalResult)object2).setRandomAccess();
        }
        switch (this.unionType) {
            case 0: 
            case 2: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                ((LocalResult)object2).setDistinct();
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
        LocalResult localResult = this.left.query(0);
        LocalResult localResult2 = this.right.query(0);
        localResult.reset();
        localResult2.reset();
        switch (this.unionType) {
            case 0: 
            case 1: {
                while (localResult.next()) {
                    ((LocalResult)object2).addRow(this.convert(localResult.currentRow(), n3));
                }
                while (localResult2.next()) {
                    ((LocalResult)object2).addRow(this.convert(localResult2.currentRow(), n3));
                }
                break;
            }
            case 2: {
                while (localResult.next()) {
                    ((LocalResult)object2).addRow(this.convert(localResult.currentRow(), n3));
                }
                while (localResult2.next()) {
                    ((LocalResult)object2).removeDistinct(this.convert(localResult2.currentRow(), n3));
                }
                break;
            }
            case 3: {
                object = new LocalResult(this.session, this.expressionArray, n3);
                ((LocalResult)object).setDistinct();
                ((LocalResult)object).setRandomAccess();
                while (localResult.next()) {
                    ((LocalResult)object).addRow(this.convert(localResult.currentRow(), n3));
                }
                while (localResult2.next()) {
                    Value[] valueArray = this.convert(localResult2.currentRow(), n3);
                    if (!((LocalResult)object).containsDistinct(valueArray)) continue;
                    ((LocalResult)object2).addRow(valueArray);
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
        if (this.offsetExpr != null) {
            ((LocalResult)object2).setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (this.limitExpr != null && (object = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            ((LocalResult)object2).setLimit(((Value)object).getInt());
        }
        localResult.close();
        localResult2.close();
        ((LocalResult)object2).done();
        if (resultTarget != null) {
            while (((LocalResult)object2).next()) {
                resultTarget.addRow(((LocalResult)object2).currentRow());
            }
            ((LocalResult)object2).close();
            return null;
        }
        return object2;
    }

    @Override
    public void init() {
        if (SysProperties.CHECK && this.checkInit) {
            DbException.throwInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int n2 = this.left.getColumnCount();
        if (n2 != this.right.getColumnCount()) {
            throw DbException.get(21002);
        }
        ArrayList<Expression> arrayList = this.left.getExpressions();
        this.expressions = New.arrayList();
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = arrayList.get(i2);
            this.expressions.add(expression);
        }
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        this.isPrepared = true;
        this.left.prepare();
        this.right.prepare();
        int n2 = this.left.getColumnCount();
        this.expressions = New.arrayList();
        ArrayList<Expression> arrayList = this.left.getExpressions();
        ArrayList<Expression> arrayList2 = this.right.getExpressions();
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = arrayList.get(i2);
            Expression expression2 = arrayList2.get(i2);
            int n3 = Value.getHigherOrder(expression.getType(), expression2.getType());
            long l2 = Math.max(expression.getPrecision(), expression2.getPrecision());
            int n4 = Math.max(expression.getScale(), expression2.getScale());
            int n5 = Math.max(expression.getDisplaySize(), expression2.getDisplaySize());
            Column column = new Column(expression.getAlias(), n3, l2, n4, n5);
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
            this.expressions.add(expressionColumn);
        }
        if (this.orderList != null) {
            SelectUnion.initOrder(this.session, this.expressions, null, this.orderList, this.getColumnCount(), true, null);
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        this.expressionArray = new Expression[this.expressions.size()];
        this.expressions.toArray(this.expressionArray);
    }

    @Override
    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = this.left.getTables();
        hashSet.addAll(this.right.getTables());
        return hashSet;
    }

    @Override
    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void setForUpdate(boolean bl2) {
        this.left.setForUpdate(bl2);
        this.right.setForUpdate(bl2);
        this.isForUpdate = bl2;
    }

    @Override
    public int getColumnCount() {
        return this.left.getColumnCount();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.left.mapColumns(columnResolver, n2);
        this.right.mapColumns(columnResolver, n2);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl2) {
        this.left.setEvaluatable(tableFilter, bl2);
        this.right.setEvaluatable(tableFilter, bl2);
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n2, int n3) {
        this.addParameter(parameter);
        switch (this.unionType) {
            case 0: 
            case 1: 
            case 3: {
                this.left.addGlobalCondition(parameter, n2, n3);
                this.right.addGlobalCondition(parameter, n2, n3);
                break;
            }
            case 2: {
                this.left.addGlobalCondition(parameter, n2, n3);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
    }

    @Override
    public String getPlanSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.left.getPlanSQL()).append(')');
        switch (this.unionType) {
            case 1: {
                stringBuilder.append("\nUNION ALL\n");
                break;
            }
            case 0: {
                stringBuilder.append("\nUNION\n");
                break;
            }
            case 3: {
                stringBuilder.append("\nINTERSECT\n");
                break;
            }
            case 2: {
                stringBuilder.append("\nEXCEPT\n");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
        stringBuilder.append('(').append(this.right.getPlanSQL()).append(')');
        Expression[] expressionArray = this.expressions.toArray(new Expression[this.expressions.size()]);
        if (this.sort != null) {
            stringBuilder.append("\nORDER BY ").append(this.sort.getSQL(expressionArray, expressionArray.length));
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nLIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
            if (this.offsetExpr != null) {
                stringBuilder.append("\nOFFSET ").append(StringUtils.unEnclose(this.offsetExpr.getSQL()));
            }
        }
        if (this.sampleSizeExpr != null) {
            stringBuilder.append("\nSAMPLE_SIZE ").append(StringUtils.unEnclose(this.sampleSizeExpr.getSQL()));
        }
        if (this.isForUpdate) {
            stringBuilder.append("\nFOR UPDATE");
        }
        return stringBuilder.toString();
    }

    @Override
    public LocalResult query(int n2, ResultTarget resultTarget) {
        return this.queryWithoutCache(n2, resultTarget);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public boolean isReadOnly() {
        return this.left.isReadOnly() && this.right.isReadOnly();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }

    @Override
    public void fireBeforeSelectTriggers() {
        this.left.fireBeforeSelectTriggers();
        this.right.fireBeforeSelectTriggers();
    }

    @Override
    public int getType() {
        return 66;
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.left.allowGlobalConditions() && this.right.allowGlobalConditions();
    }
}

