/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.dml.Optimizer;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectListColumnResolver;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.JoinBatch;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public class Select
extends Query {
    private TableFilter topTableFilter;
    private final ArrayList<TableFilter> filters = New.arrayList();
    private final ArrayList<TableFilter> topFilters = New.arrayList();
    private ArrayList<Expression> expressions;
    private Expression[] expressionArray;
    private Expression having;
    private Expression condition;
    private int visibleColumnCount;
    private int distinctColumnCount;
    private ArrayList<SelectOrderBy> orderList;
    private ArrayList<Expression> group;
    private int[] groupIndex;
    private boolean[] groupByExpression;
    private HashMap<Expression, Object> currentGroup;
    private int havingIndex;
    private boolean isGroupQuery;
    private boolean isGroupSortedQuery;
    private boolean isForUpdate;
    private boolean isForUpdateMvcc;
    private double cost;
    private boolean isQuickAggregateQuery;
    private boolean isDistinctQuery;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean sortUsingIndex;
    private SortOrder sort;
    private int currentGroupRowId;

    public Select(Session session) {
        super(session);
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    public void addTableFilter(TableFilter tableFilter, boolean bl2) {
        this.filters.add(tableFilter);
        if (bl2) {
            this.topFilters.add(tableFilter);
        }
    }

    public ArrayList<TableFilter> getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ArrayList<Expression> arrayList) {
        this.expressions = arrayList;
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setGroupBy(ArrayList<Expression> arrayList) {
        this.group = arrayList;
    }

    public ArrayList<Expression> getGroupBy() {
        return this.group;
    }

    public HashMap<Expression, Object> getCurrentGroup() {
        return this.currentGroup;
    }

    public int getCurrentGroupRowId() {
        return this.currentGroupRowId;
    }

    @Override
    public void setOrder(ArrayList<SelectOrderBy> arrayList) {
        this.orderList = arrayList;
    }

    @Override
    public boolean hasOrder() {
        return this.orderList != null || this.sort != null;
    }

    public void addCondition(Expression expression) {
        this.condition = this.condition == null ? expression : new ConditionAndOr(0, expression, this.condition);
    }

    private void queryGroupSorted(int n2, ResultTarget resultTarget) {
        int n3 = 0;
        this.setCurrentRowNumber(0);
        this.currentGroup = null;
        Object[] objectArray = null;
        while (this.topTableFilter.next()) {
            int n4;
            this.setCurrentRowNumber(n3 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++n3;
            Object[] objectArray2 = new Value[this.groupIndex.length];
            for (n4 = 0; n4 < this.groupIndex.length; ++n4) {
                int n5 = this.groupIndex[n4];
                Expression expression = this.expressions.get(n5);
                objectArray2[n4] = expression.getValue(this.session);
            }
            if (objectArray == null) {
                objectArray = objectArray2;
                this.currentGroup = New.hashMap();
            } else if (!Arrays.equals(objectArray, objectArray2)) {
                this.addGroupSortedRow((Value[])objectArray, n2, resultTarget);
                objectArray = objectArray2;
                this.currentGroup = New.hashMap();
            }
            ++this.currentGroupRowId;
            for (n4 = 0; n4 < n2; ++n4) {
                if (this.groupByExpression != null && this.groupByExpression[n4]) continue;
                Expression expression = this.expressions.get(n4);
                expression.updateAggregate(this.session);
            }
        }
        if (objectArray != null) {
            this.addGroupSortedRow((Value[])objectArray, n2, resultTarget);
        }
    }

    private void addGroupSortedRow(Value[] valueArray, int n2, ResultTarget resultTarget) {
        int n3;
        Value[] valueArray2 = new Value[n2];
        for (n3 = 0; this.groupIndex != null && n3 < this.groupIndex.length; ++n3) {
            valueArray2[this.groupIndex[n3]] = valueArray[n3];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (this.groupByExpression != null && this.groupByExpression[n3]) continue;
            Expression expression = this.expressions.get(n3);
            valueArray2[n3] = expression.getValue(this.session);
        }
        if (this.isHavingNullOrFalse(valueArray2)) {
            return;
        }
        valueArray2 = this.keepOnlyDistinct(valueArray2, n2);
        resultTarget.addRow(valueArray2);
    }

    private Value[] keepOnlyDistinct(Value[] valueArray, int n2) {
        if (n2 == this.distinctColumnCount) {
            return valueArray;
        }
        Value[] valueArray2 = new Value[this.distinctColumnCount];
        System.arraycopy(valueArray, 0, valueArray2, 0, this.distinctColumnCount);
        return valueArray2;
    }

    private boolean isHavingNullOrFalse(Value[] valueArray) {
        if (this.havingIndex >= 0) {
            Value value = valueArray[this.havingIndex];
            if (value == ValueNull.INSTANCE) {
                return true;
            }
            if (!Boolean.TRUE.equals(value.getBoolean())) {
                return true;
            }
        }
        return false;
    }

    private Index getGroupSortedIndex() {
        if (this.groupIndex == null || this.groupByExpression == null) {
            return null;
        }
        ArrayList<Index> arrayList = this.topTableFilter.getTable().getIndexes();
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Index index = arrayList.get(i2);
                if (index.getIndexType().isScan() || index.getIndexType().isHash() || !this.isGroupSortedIndex(this.topTableFilter, index)) continue;
                return index;
            }
        }
        return null;
    }

    private boolean isGroupSortedIndex(TableFilter tableFilter, Index index) {
        int n2;
        Column[] columnArray = index.getColumns();
        boolean[] blArray = new boolean[columnArray.length];
        int n3 = this.expressions.size();
        block0: for (n2 = 0; n2 < n3; ++n2) {
            if (!this.groupByExpression[n2]) continue;
            Expression expression = this.expressions.get(n2).getNonAliasExpression();
            if (!(expression instanceof ExpressionColumn)) {
                return false;
            }
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            for (int i2 = 0; i2 < columnArray.length; ++i2) {
                if (tableFilter != expressionColumn.getTableFilter() || !columnArray[i2].equals(expressionColumn.getColumn())) continue;
                blArray[i2] = true;
                continue block0;
            }
            return false;
        }
        for (n2 = 1; n2 < blArray.length; ++n2) {
            if (blArray[n2 - 1] || !blArray[n2]) continue;
            return false;
        }
        return true;
    }

    private int getGroupByExpressionCount() {
        if (this.groupByExpression == null) {
            return 0;
        }
        int n2 = 0;
        for (boolean bl2 : this.groupByExpression) {
            if (!bl2) continue;
            ++n2;
        }
        return n2;
    }

    private void queryGroup(int n2, LocalResult localResult) {
        Object object;
        Object object2;
        Object object3;
        ValueHashMap valueHashMap = ValueHashMap.newInstance();
        int n3 = 0;
        this.setCurrentRowNumber(0);
        this.currentGroup = null;
        ValueArray valueArray = ValueArray.get(new Value[0]);
        int n4 = this.getSampleSizeValue(this.session);
        while (this.topTableFilter.next()) {
            int n5;
            int n6;
            this.setCurrentRowNumber(n3 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++n3;
            if (this.groupIndex == null) {
                object3 = valueArray;
            } else {
                object2 = new Value[this.groupIndex.length];
                for (n6 = 0; n6 < this.groupIndex.length; ++n6) {
                    n5 = this.groupIndex[n6];
                    object = this.expressions.get(n5);
                    object2[n6] = ((Expression)object).getValue(this.session);
                }
                object3 = ValueArray.get(object2);
            }
            object2 = (HashMap)valueHashMap.get((Value)object3);
            if (object2 == null) {
                object2 = new HashMap();
                valueHashMap.put((Value)object3, object2);
            }
            this.currentGroup = object2;
            ++this.currentGroupRowId;
            n6 = n2;
            for (n5 = 0; n5 < n6; ++n5) {
                if (this.groupByExpression != null && this.groupByExpression[n5]) continue;
                object = this.expressions.get(n5);
                ((Expression)object).updateAggregate(this.session);
            }
            if (n4 <= 0 || n3 < n4) continue;
            break;
        }
        if (this.groupIndex == null && valueHashMap.size() == 0) {
            valueHashMap.put(valueArray, new HashMap());
        }
        object3 = valueHashMap.keys();
        object2 = ((ArrayList)object3).iterator();
        while (object2.hasNext()) {
            int n7;
            Value value = object2.next();
            ValueArray valueArray2 = (ValueArray)value;
            this.currentGroup = (HashMap)valueHashMap.get(valueArray2);
            object = valueArray2.getList();
            Value[] valueArray3 = new Value[n2];
            for (n7 = 0; this.groupIndex != null && n7 < this.groupIndex.length; ++n7) {
                valueArray3[this.groupIndex[n7]] = object[n7];
            }
            for (n7 = 0; n7 < n2; ++n7) {
                if (this.groupByExpression != null && this.groupByExpression[n7]) continue;
                Expression expression = this.expressions.get(n7);
                valueArray3[n7] = expression.getValue(this.session);
            }
            if (this.isHavingNullOrFalse(valueArray3)) continue;
            valueArray3 = this.keepOnlyDistinct(valueArray3, n2);
            localResult.addRow(valueArray3);
        }
    }

    private Index getSortIndex() {
        Index index;
        Object object;
        if (this.sort == null) {
            return null;
        }
        ArrayList<Column> arrayList = New.arrayList();
        for (int index2 : this.sort.getQueryColumnIndexes()) {
            if (index2 < 0 || index2 >= this.expressions.size()) {
                throw DbException.getInvalidValueException("ORDER BY", index2 + 1);
            }
            Expression n3 = this.expressions.get(index2);
            if ((n3 = n3.getNonAliasExpression()).isConstant()) continue;
            if (!(n3 instanceof ExpressionColumn)) {
                return null;
            }
            object = (ExpressionColumn)n3;
            if (((ExpressionColumn)object).getTableFilter() != this.topTableFilter) {
                return null;
            }
            arrayList.add(((ExpressionColumn)object).getColumn());
        }
        Column[] columnArray = arrayList.toArray(new Column[arrayList.size()]);
        int[] nArray = this.sort.getSortTypes();
        if (columnArray.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        ArrayList<Index> arrayList2 = this.topTableFilter.getTable().getIndexes();
        if (arrayList2 != null) {
            int n2 = arrayList2.size();
            for (int index2 = 0; index2 < n2; ++index2) {
                IndexColumn[] indexColumnArray;
                object = arrayList2.get(index2);
                if (object.getCreateSQL() == null || object.getIndexType().isHash() || (indexColumnArray = object.getIndexColumns()).length < columnArray.length) continue;
                boolean bl2 = true;
                for (int i2 = 0; i2 < columnArray.length; ++i2) {
                    IndexColumn indexColumn = indexColumnArray[i2];
                    Column column = columnArray[i2];
                    if (indexColumn.column != column) {
                        bl2 = false;
                        break;
                    }
                    if (indexColumn.sortType == nArray[i2]) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                return object;
            }
        }
        if (columnArray.length == 1 && columnArray[0].getColumnId() == -1 && (index = this.topTableFilter.getTable().getScanIndex(this.session)).isRowIdIndex()) {
            return index;
        }
        return null;
    }

    private void queryDistinct(ResultTarget resultTarget, long l2) {
        int n2;
        if (l2 > 0L && this.offsetExpr != null && (n2 = this.offsetExpr.getValue(this.session).getInt()) > 0) {
            l2 += (long)n2;
        }
        n2 = 0;
        this.setCurrentRowNumber(0);
        Index index = this.topTableFilter.getIndex();
        SearchRow searchRow = null;
        int n3 = index.getColumns()[0].getColumnId();
        int n4 = this.getSampleSizeValue(this.session);
        do {
            this.setCurrentRowNumber(n2 + 1);
            Cursor cursor = index.findNext(this.session, searchRow, null);
            if (!cursor.next()) break;
            SearchRow searchRow2 = cursor.getSearchRow();
            Value value = searchRow2.getValue(n3);
            if (searchRow == null) {
                searchRow = this.topTableFilter.getTable().getTemplateSimpleRow(true);
            }
            searchRow.setValue(n3, value);
            Value[] valueArray = new Value[]{value};
            resultTarget.addRow(valueArray);
        } while ((this.sort != null && !this.sortUsingIndex || l2 <= 0L || (long)(++n2) < l2) && (n4 <= 0 || n2 < n4));
    }

    private void queryFlat(int n2, ResultTarget resultTarget, long l2) {
        int n3;
        if (l2 > 0L && this.offsetExpr != null && (n3 = this.offsetExpr.getValue(this.session).getInt()) > 0) {
            l2 += (long)n3;
        }
        n3 = 0;
        this.setCurrentRowNumber(0);
        ArrayList<Row> arrayList = null;
        if (this.isForUpdateMvcc) {
            arrayList = New.arrayList();
        }
        int n4 = this.getSampleSizeValue(this.session);
        while (this.topTableFilter.next()) {
            this.setCurrentRowNumber(n3 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            Value[] valueArray = new Value[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Expression expression = this.expressions.get(i2);
                valueArray[i2] = expression.getValue(this.session);
            }
            if (this.isForUpdateMvcc) {
                this.topTableFilter.lockRowAdd(arrayList);
            }
            resultTarget.addRow(valueArray);
            if ((this.sort != null && !this.sortUsingIndex || l2 <= 0L || (long)resultTarget.getRowCount() < l2) && (n4 <= 0 || ++n3 < n4)) continue;
            break;
        }
        if (this.isForUpdateMvcc) {
            this.topTableFilter.lockRows(arrayList);
        }
    }

    private void queryQuick(int n2, ResultTarget resultTarget) {
        Value[] valueArray = new Value[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = this.expressions.get(i2);
            valueArray[i2] = expression.getValue(this.session);
        }
        resultTarget.addRow(valueArray);
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, this.visibleColumnCount);
        localResult.done();
        return localResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LocalResult queryWithoutCache(int n2, ResultTarget resultTarget) {
        ResultTarget resultTarget2;
        boolean bl2;
        int n3;
        int n4 = n3 = n2 == 0 ? -1 : n2;
        if (this.limitExpr != null) {
            int n5;
            Value value = this.limitExpr.getValue(this.session);
            int n6 = n5 = value == ValueNull.INSTANCE ? -1 : value.getInt();
            if (n3 < 0) {
                n3 = n5;
            } else if (n5 >= 0) {
                n3 = Math.min(n5, n3);
            }
        }
        int n7 = this.expressions.size();
        LocalResult localResult = null;
        if (resultTarget == null || !this.session.getDatabase().getSettings().optimizeInsertFromSelect) {
            localResult = this.createLocalResult(localResult);
        }
        if (this.sort != null && (!this.sortUsingIndex || this.distinct)) {
            localResult = this.createLocalResult(localResult);
            localResult.setSortOrder(this.sort);
        }
        if (this.distinct && !this.isDistinctQuery) {
            localResult = this.createLocalResult(localResult);
            localResult.setDistinct();
        }
        if (this.randomAccessResult) {
            localResult = this.createLocalResult(localResult);
        }
        if (this.isGroupQuery && !this.isGroupSortedQuery) {
            localResult = this.createLocalResult(localResult);
        }
        if (n3 >= 0 || this.offsetExpr != null) {
            localResult = this.createLocalResult(localResult);
        }
        this.topTableFilter.startQuery(this.session);
        this.topTableFilter.reset();
        boolean bl3 = bl2 = this.isForUpdate && !this.isForUpdateMvcc;
        if (this.isForUpdateMvcc) {
            if (this.isGroupQuery) {
                throw DbException.getUnsupportedException("MVCC=TRUE && FOR UPDATE && GROUP");
            }
            if (this.distinct) {
                throw DbException.getUnsupportedException("MVCC=TRUE && FOR UPDATE && DISTINCT");
            }
            if (this.isQuickAggregateQuery) {
                throw DbException.getUnsupportedException("MVCC=TRUE && FOR UPDATE && AGGREGATE");
            }
            if (this.topTableFilter.getJoin() != null) {
                throw DbException.getUnsupportedException("MVCC=TRUE && FOR UPDATE && JOIN");
            }
        }
        this.topTableFilter.lock(this.session, bl2, bl2);
        ResultTarget resultTarget3 = resultTarget2 = localResult != null ? localResult : resultTarget;
        if (n3 != 0) {
            try {
                if (this.isQuickAggregateQuery) {
                    this.queryQuick(n7, resultTarget2);
                } else if (this.isGroupQuery) {
                    if (this.isGroupSortedQuery) {
                        this.queryGroupSorted(n7, resultTarget2);
                    } else {
                        this.queryGroup(n7, localResult);
                    }
                } else if (this.isDistinctQuery) {
                    this.queryDistinct(resultTarget2, n3);
                } else {
                    this.queryFlat(n7, resultTarget2, n3);
                }
            }
            finally {
                JoinBatch joinBatch = this.getJoinBatch();
                if (joinBatch != null) {
                    joinBatch.reset(false);
                }
            }
        }
        if (this.offsetExpr != null) {
            localResult.setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (n3 >= 0) {
            localResult.setLimit(n3);
        }
        if (localResult != null) {
            localResult.done();
            if (resultTarget != null) {
                while (localResult.next()) {
                    resultTarget.addRow(localResult.currentRow());
                }
                localResult.close();
                return null;
            }
            return localResult;
        }
        return null;
    }

    private LocalResult createLocalResult(LocalResult localResult) {
        return localResult != null ? localResult : new LocalResult(this.session, this.expressionArray, this.visibleColumnCount);
    }

    private void expandColumnList() {
        Database database = this.session.getDatabase();
        for (int i2 = 0; i2 < this.expressions.size(); ++i2) {
            Expression expression = this.expressions.get(i2);
            if (!expression.isWildcard()) continue;
            String string = expression.getSchemaName();
            String string2 = expression.getTableAlias();
            if (string2 == null) {
                this.expressions.remove(i2);
                for (TableFilter tableFilter : this.filters) {
                    i2 = this.expandColumnList(tableFilter, i2);
                }
                --i2;
                continue;
            }
            Object object3 = null;
            for (TableFilter tableFilter : this.filters) {
                if (!database.equalsIdentifiers(string2, tableFilter.getTableAlias()) || string != null && !database.equalsIdentifiers(string, tableFilter.getSchemaName())) continue;
                object3 = tableFilter;
                break;
            }
            if (object3 == null) {
                throw DbException.get(42102, string2);
            }
            this.expressions.remove(i2);
            i2 = this.expandColumnList((TableFilter)object3, i2);
            --i2;
        }
    }

    private int expandColumnList(TableFilter tableFilter, int n2) {
        Column[] columnArray;
        Table table = tableFilter.getTable();
        String string = tableFilter.getTableAlias();
        for (Column column : columnArray = table.getColumns()) {
            if (tableFilter.isNaturalJoinColumn(column)) continue;
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), null, string, column.getName());
            this.expressions.add(n2++, expressionColumn);
        }
        return n2;
    }

    @Override
    public void init() {
        ArrayList<String> arrayList;
        if (SysProperties.CHECK && this.checkInit) {
            DbException.throwInternalError();
        }
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.orderList != null || this.group != null) {
            arrayList = New.arrayList();
            for (int i2 = 0; i2 < this.visibleColumnCount; ++i2) {
                Expression expression = this.expressions.get(i2);
                expression = expression.getNonAliasExpression();
                String string = expression.getSQL();
                arrayList.add(string);
            }
        } else {
            arrayList = null;
        }
        if (this.orderList != null) {
            Select.initOrder(this.session, this.expressions, arrayList, this.orderList, this.visibleColumnCount, this.distinct, this.filters);
        }
        this.distinctColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        Database database = this.session.getDatabase();
        if (this.group != null) {
            int n2 = this.group.size();
            int n3 = arrayList.size();
            this.groupIndex = new int[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object;
                int n4;
                Expression expression = this.group.get(i3);
                String string = expression.getSQL();
                int n5 = -1;
                for (n4 = 0; n4 < n3; ++n4) {
                    object = arrayList.get(n4);
                    if (!database.equalsIdentifiers((String)object, string)) continue;
                    n5 = n4;
                    break;
                }
                if (n5 < 0) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        object = this.expressions.get(n4);
                        if (database.equalsIdentifiers(string, ((Expression)object).getAlias())) {
                            n5 = n4;
                            break;
                        }
                        string = expression.getAlias();
                        if (!database.equalsIdentifiers(string, ((Expression)object).getAlias())) continue;
                        n5 = n4;
                        break;
                    }
                }
                if (n5 < 0) {
                    this.groupIndex[i3] = n4 = this.expressions.size();
                    this.expressions.add(expression);
                    continue;
                }
                this.groupIndex[i3] = n5;
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            for (int n5 : this.groupIndex) {
                this.groupByExpression[n5] = true;
            }
            this.group = null;
        }
        for (TableFilter tableFilter : this.filters) {
            this.mapColumns(tableFilter, 0);
        }
        if (this.havingIndex >= 0) {
            Expression expression = this.expressions.get(this.havingIndex);
            SelectListColumnResolver selectListColumnResolver = new SelectListColumnResolver(this);
            expression.mapColumns(selectListColumnResolver, 0);
        }
        this.checkInit = true;
    }

    @Override
    public void prepare() {
        boolean bl2;
        Object object;
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        if (this.orderList != null) {
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        for (int i2 = 0; i2 < this.expressions.size(); ++i2) {
            Expression object22 = this.expressions.get(i2);
            this.expressions.set(i2, object22.optimize(this.session));
        }
        if (this.condition != null) {
            this.condition = this.condition.optimize(this.session);
            for (TableFilter tableFilter : this.filters) {
                if (tableFilter.isJoinOuter() || tableFilter.isJoinOuterIndirect()) continue;
                this.condition.createIndexConditions(this.session, tableFilter);
            }
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.filters.size() == 1 && this.condition == null) {
            Table table = this.filters.get(0).getTable();
            ExpressionVisitor expressionVisitor = ExpressionVisitor.getOptimizableVisitor(table);
            this.isQuickAggregateQuery = this.isEverything(expressionVisitor);
        }
        this.cost = this.preparePlan(this.session.isParsingView());
        if (this.distinct && this.session.getDatabase().getSettings().optimizeDistinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expression = this.expressions.get(0);
            if ((expression = expression.getNonAliasExpression()) instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)expression).getColumn();
                int n2 = column.getSelectivity();
                object = this.topTableFilter.getTable().getIndexForColumn(column);
                if (object != null && n2 != 50 && n2 < 20) {
                    IndexType indexType;
                    bl2 = object.getIndexColumns()[0].sortType == 0;
                    Index index = this.topTableFilter.getIndex();
                    if (!(!object.canFindNext() || !bl2 || index != null && !index.getIndexType().isScan() && object != index || (indexType = object.getIndexType()).isHash() || indexType.isUnique() && object.getColumns().length <= 1)) {
                        this.topTableFilter.setIndex((Index)object);
                        this.isDistinctQuery = true;
                    }
                }
            }
        }
        if (this.sort != null && !this.isQuickAggregateQuery && !this.isGroupQuery) {
            Index index = this.getSortIndex();
            Index index2 = this.topTableFilter.getIndex();
            if (index != null && index2 != null) {
                if (index2.getIndexType().isScan() || index2 == index) {
                    this.topTableFilter.setIndex(index);
                    if (!this.topTableFilter.hasInComparisons()) {
                        this.sortUsingIndex = true;
                    }
                } else if (index.getIndexColumns().length >= index2.getIndexColumns().length) {
                    IndexColumn[] indexColumnArray = index.getIndexColumns();
                    object = index2.getIndexColumns();
                    bl2 = false;
                    for (int i2 = 0; i2 < ((IndexColumn[])object).length; ++i2) {
                        if (indexColumnArray[i2].column != object[i2].column) {
                            bl2 = false;
                            break;
                        }
                        if (indexColumnArray[i2].sortType == ((IndexColumn)object[i2]).sortType) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        this.topTableFilter.setIndex(index);
                        this.sortUsingIndex = true;
                    }
                }
            }
        }
        if (!this.isQuickAggregateQuery && this.isGroupQuery && this.getGroupByExpressionCount() > 0) {
            Index index = this.getGroupSortedIndex();
            Index index3 = this.topTableFilter.getIndex();
            if (index != null && index3 != null && (index3.getIndexType().isScan() || index3 == index)) {
                this.topTableFilter.setIndex(index);
                this.isGroupSortedQuery = true;
            }
        }
        this.expressionArray = new Expression[this.expressions.size()];
        this.expressions.toArray(this.expressionArray);
        this.isPrepared = true;
    }

    @Override
    public void prepareJoinBatch() {
        ArrayList<TableFilter> arrayList = New.arrayList();
        TableFilter tableFilter = this.getTopTableFilter();
        do {
            if (tableFilter.getNestedJoin() != null) {
                return;
            }
            arrayList.add(tableFilter);
        } while ((tableFilter = tableFilter.getJoin()) != null);
        TableFilter[] tableFilterArray = arrayList.toArray(new TableFilter[arrayList.size()]);
        JoinBatch joinBatch = null;
        for (int i2 = tableFilterArray.length - 1; i2 >= 0; --i2) {
            joinBatch = tableFilterArray[i2].prepareJoinBatch(joinBatch, tableFilterArray, i2);
        }
    }

    public JoinBatch getJoinBatch() {
        return this.getTopTableFilter().getJoinBatch();
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = New.hashSet();
        for (TableFilter tableFilter : this.filters) {
            hashSet.add(tableFilter.getTable());
        }
        return hashSet;
    }

    @Override
    public void fireBeforeSelectTriggers() {
        int n2 = this.filters.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TableFilter tableFilter = this.filters.get(i2);
            tableFilter.getTable().fire(this.session, 8, true);
        }
    }

    private double preparePlan(boolean bl2) {
        TableFilter[] tableFilterArray = this.topFilters.toArray(new TableFilter[this.topFilters.size()]);
        for (TableFilter tableFilter : tableFilterArray) {
            tableFilter.setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer(tableFilterArray, this.condition, this.session);
        optimizer.optimize(bl2);
        this.topTableFilter = optimizer.getTopFilter();
        double d2 = optimizer.getCost();
        this.setEvaluatableRecursive(this.topTableFilter);
        if (!bl2) {
            this.topTableFilter.prepare();
        }
        return d2;
    }

    private void setEvaluatableRecursive(TableFilter tableFilter) {
        while (tableFilter != null) {
            Expression expression;
            TableFilter tableFilter2;
            tableFilter.setEvaluatable(tableFilter, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(tableFilter, true);
            }
            if ((tableFilter2 = tableFilter.getNestedJoin()) != null) {
                this.setEvaluatableRecursive(tableFilter2);
            }
            if ((expression = tableFilter.getJoinCondition()) != null && !expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                if (this.session.getDatabase().getSettings().nestedJoins) {
                    expression = expression.optimize(this.session);
                    if (!tableFilter.isJoinOuter() && !tableFilter.isJoinOuterIndirect()) {
                        tableFilter.removeJoinCondition();
                        this.addCondition(expression);
                    }
                } else {
                    if (tableFilter.isJoinOuter()) {
                        expression = expression.optimize(this.session);
                        throw DbException.get(90136, expression.getSQL());
                    }
                    tableFilter.removeJoinCondition();
                    expression = expression.optimize(this.session);
                    this.addCondition(expression);
                }
            }
            if ((expression = tableFilter.getFilterCondition()) != null && !expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                tableFilter.removeFilterCondition();
                this.addCondition(expression);
            }
            for (Expression expression2 : this.expressions) {
                expression2.setEvaluatable(tableFilter, true);
            }
            tableFilter = tableFilter.getJoin();
        }
    }

    @Override
    public String getPlanSQL() {
        int n2;
        Expression[] expressionArray = this.expressions.toArray(new Expression[this.expressions.size()]);
        StatementBuilder statementBuilder = new StatementBuilder("SELECT");
        if (this.distinct) {
            statementBuilder.append(" DISTINCT");
        }
        for (int i2 = 0; i2 < this.visibleColumnCount; ++i2) {
            statementBuilder.appendExceptFirst(",");
            statementBuilder.append('\n');
            statementBuilder.append(StringUtils.indent(expressionArray[i2].getSQL(), 4, false));
        }
        statementBuilder.append("\nFROM ");
        TableFilter tableFilter = this.topTableFilter;
        if (tableFilter != null) {
            statementBuilder.resetCount();
            n2 = 0;
            do {
                statementBuilder.appendExceptFirst("\n");
                statementBuilder.append(tableFilter.getPlanSQL(n2++ > 0));
            } while ((tableFilter = tableFilter.getJoin()) != null);
        } else {
            statementBuilder.resetCount();
            n2 = 0;
            for (TableFilter tableFilter2 : this.topFilters) {
                do {
                    statementBuilder.appendExceptFirst("\n");
                    statementBuilder.append(tableFilter2.getPlanSQL(n2++ > 0));
                } while ((tableFilter2 = tableFilter2.getJoin()) != null);
            }
        }
        if (this.condition != null) {
            statementBuilder.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.groupIndex != null) {
            statementBuilder.append("\nGROUP BY ");
            statementBuilder.resetCount();
            for (int n3 : this.groupIndex) {
                Expression expression = expressionArray[n3];
                expression = expression.getNonAliasExpression();
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.unEnclose(expression.getSQL()));
            }
        }
        if (this.group != null) {
            statementBuilder.append("\nGROUP BY ");
            statementBuilder.resetCount();
            for (Expression expression : this.group) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.unEnclose(expression.getSQL()));
            }
        }
        if (this.having != null) {
            Expression expression = this.having;
            statementBuilder.append("\nHAVING ").append(StringUtils.unEnclose(expression.getSQL()));
        } else if (this.havingIndex >= 0) {
            Expression expression = expressionArray[this.havingIndex];
            statementBuilder.append("\nHAVING ").append(StringUtils.unEnclose(expression.getSQL()));
        }
        if (this.sort != null) {
            statementBuilder.append("\nORDER BY ").append(this.sort.getSQL(expressionArray, this.visibleColumnCount));
        }
        if (this.orderList != null) {
            statementBuilder.append("\nORDER BY ");
            statementBuilder.resetCount();
            for (SelectOrderBy selectOrderBy : this.orderList) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.unEnclose(selectOrderBy.getSQL()));
            }
        }
        if (this.limitExpr != null) {
            statementBuilder.append("\nLIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
            if (this.offsetExpr != null) {
                statementBuilder.append(" OFFSET ").append(StringUtils.unEnclose(this.offsetExpr.getSQL()));
            }
        }
        if (this.sampleSizeExpr != null) {
            statementBuilder.append("\nSAMPLE_SIZE ").append(StringUtils.unEnclose(this.sampleSizeExpr.getSQL()));
        }
        if (this.isForUpdate) {
            statementBuilder.append("\nFOR UPDATE");
        }
        if (this.isQuickAggregateQuery) {
            statementBuilder.append("\n/* direct lookup */");
        }
        if (this.isDistinctQuery) {
            statementBuilder.append("\n/* distinct */");
        }
        if (this.sortUsingIndex) {
            statementBuilder.append("\n/* index sorted */");
        }
        if (this.isGroupQuery && this.isGroupSortedQuery) {
            statementBuilder.append("\n/* group sorted */");
        }
        return statementBuilder.toString();
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public Expression getHaving() {
        return this.having;
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    @Override
    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void setForUpdate(boolean bl2) {
        this.isForUpdate = bl2;
        if (this.session.getDatabase().getSettings().selectForUpdateMvcc && this.session.getDatabase().isMultiVersion()) {
            this.isForUpdateMvcc = bl2;
        }
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n2) {
        for (Expression expression : this.expressions) {
            expression.mapColumns(columnResolver, n2);
        }
        if (this.condition != null) {
            this.condition.mapColumns(columnResolver, n2);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl2) {
        for (Expression expression : this.expressions) {
            expression.setEvaluatable(tableFilter, bl2);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, bl2);
        }
    }

    public boolean isQuickAggregateQuery() {
        return this.isQuickAggregateQuery;
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n2, int n3) {
        this.addParameter(parameter);
        Expression expression = this.expressions.get(n2);
        expression = expression.getNonAliasExpression();
        Expression expression2 = expression.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR) ? new Comparison(this.session, n3, expression, parameter) : new Comparison(this.session, 16, parameter, parameter);
        expression2 = ((Expression)expression2).optimize(this.session);
        boolean bl2 = true;
        if (this.isGroupQuery) {
            bl2 = false;
            for (int i2 = 0; this.groupIndex != null && i2 < this.groupIndex.length; ++i2) {
                if (this.groupIndex[i2] != n2) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                if (this.havingIndex >= 0) {
                    this.having = this.expressions.get(this.havingIndex);
                }
                this.having = this.having == null ? expression2 : new ConditionAndOr(0, this.having, expression2);
            }
        }
        if (bl2) {
            this.condition = this.condition == null ? expression2 : new ConditionAndOr(0, this.condition, expression2);
        }
    }

    @Override
    public void updateAggregate(Session session) {
        for (Expression expression : this.expressions) {
            expression.updateAggregate(session);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(session);
        }
        if (this.having != null) {
            this.having.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        int n2;
        switch (expressionVisitor.getType()) {
            case 2: {
                TableFilter tableFilter;
                int n3;
                if (this.isForUpdate) {
                    return false;
                }
                n2 = this.filters.size();
                for (n3 = 0; n3 < n2; ++n3) {
                    tableFilter = this.filters.get(n3);
                    if (tableFilter.getTable().isDeterministic()) continue;
                    return false;
                }
                break;
            }
            case 4: {
                TableFilter tableFilter;
                int n3;
                n2 = this.filters.size();
                for (n3 = 0; n3 < n2; ++n3) {
                    tableFilter = this.filters.get(n3);
                    long l2 = tableFilter.getTable().getMaxDataModificationId();
                    expressionVisitor.addDataModificationId(l2);
                }
                break;
            }
            case 3: {
                if (this.session.getDatabase().getSettings().optimizeEvaluatableSubqueries) break;
                return false;
            }
            case 7: {
                TableFilter tableFilter;
                int n3;
                n2 = this.filters.size();
                for (n3 = 0; n3 < n2; ++n3) {
                    tableFilter = this.filters.get(n3);
                    Table table = tableFilter.getTable();
                    expressionVisitor.addDependency(table);
                    table.addDependencies(expressionVisitor.getDependencies());
                }
                break;
            }
        }
        ExpressionVisitor expressionVisitor2 = expressionVisitor.incrementQueryLevel(1);
        n2 = 1;
        int n4 = this.expressions.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            Expression expression = this.expressions.get(i2);
            if (expression.isEverything(expressionVisitor2)) continue;
            n2 = 0;
            break;
        }
        if (n2 != 0 && this.condition != null && !this.condition.isEverything(expressionVisitor2)) {
            n2 = 0;
        }
        if (n2 != 0 && this.having != null && !this.having.isEverything(expressionVisitor2)) {
            n2 = 0;
        }
        return n2 != 0;
    }

    @Override
    public boolean isReadOnly() {
        return this.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    @Override
    public boolean isCacheable() {
        return !this.isForUpdate;
    }

    @Override
    public int getType() {
        return 66;
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.offsetExpr == null && (this.limitExpr == null || this.sort == null);
    }

    public SortOrder getSortOrder() {
        return this.sort;
    }
}

