/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public abstract class Query
extends Prepared {
    protected Expression limitExpr;
    protected Expression offsetExpr;
    protected Expression sampleSizeExpr;
    protected boolean distinct;
    protected boolean randomAccessResult;
    private boolean noCache;
    private int lastLimit;
    private long lastEvaluated;
    private LocalResult lastResult;
    private Value[] lastParameters;
    private boolean cacheableChecked;

    Query(Session session) {
        super(session);
    }

    public abstract boolean isUnion();

    public abstract void prepareJoinBatch();

    protected abstract LocalResult queryWithoutCache(int var1, ResultTarget var2);

    public abstract void init();

    public abstract ArrayList<Expression> getExpressions();

    public abstract double getCost();

    public int getCostAsExpression() {
        return (int)Math.min(1000000.0, 10.0 + 10.0 * this.getCost());
    }

    public abstract HashSet<Table> getTables();

    public abstract void setOrder(ArrayList<SelectOrderBy> var1);

    public abstract boolean hasOrder();

    public abstract void setForUpdate(boolean var1);

    public abstract int getColumnCount();

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3);

    public abstract boolean allowGlobalConditions();

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract void updateAggregate(Session var1);

    public abstract void fireBeforeSelectTriggers();

    public void setDistinct(boolean bl2) {
        this.distinct = bl2;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setRandomAccessResult(boolean bl2) {
        this.randomAccessResult = bl2;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void disableCache() {
        this.noCache = true;
    }

    private boolean sameResultAsLast(Session session, Value[] valueArray, Value[] valueArray2, long l2) {
        if (!this.cacheableChecked) {
            long l3 = this.getMaxDataModificationId();
            this.noCache = l3 == Long.MAX_VALUE;
            this.cacheableChecked = true;
        }
        if (this.noCache) {
            return false;
        }
        Database database = session.getDatabase();
        for (int i2 = 0; i2 < valueArray.length; ++i2) {
            Value value = valueArray2[i2];
            Value value2 = valueArray[i2];
            if (value.getType() == value2.getType() && database.areEqual(value, value2)) continue;
            return false;
        }
        if (!this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) || !this.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return false;
        }
        return database.getModificationDataId() <= l2 || this.getMaxDataModificationId() <= l2;
    }

    public final Value[] getParameterValues() {
        ArrayList<Parameter> arrayList = this.getParameters();
        if (arrayList == null) {
            arrayList = New.arrayList();
        }
        int n2 = arrayList.size();
        Value[] valueArray = new Value[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Value value;
            valueArray[i2] = value = arrayList.get(i2).getParamValue();
        }
        return valueArray;
    }

    @Override
    public LocalResult query(int n2) {
        return this.query(n2, null);
    }

    LocalResult query(int n2, ResultTarget resultTarget) {
        LocalResult localResult;
        this.fireBeforeSelectTriggers();
        if (this.noCache || !this.session.getDatabase().getOptimizeReuseResults()) {
            return this.queryWithoutCache(n2, resultTarget);
        }
        Value[] valueArray = this.getParameterValues();
        long l2 = this.session.getDatabase().getModificationDataId();
        if (this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && this.lastResult != null && !this.lastResult.isClosed() && n2 == this.lastLimit && this.sameResultAsLast(this.session, valueArray, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.lastParameters = valueArray;
        this.closeLastResult();
        this.lastResult = localResult = this.queryWithoutCache(n2, resultTarget);
        this.lastEvaluated = l2;
        this.lastLimit = n2;
        return localResult;
    }

    private void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    static void initOrder(Session session, ArrayList<Expression> arrayList, ArrayList<String> arrayList2, ArrayList<SelectOrderBy> arrayList3, int n2, boolean bl2, ArrayList<TableFilter> arrayList4) {
        Database database = session.getDatabase();
        for (SelectOrderBy selectOrderBy : arrayList3) {
            Object object;
            Expression expression = selectOrderBy.expression;
            if (expression == null) continue;
            boolean bl3 = false;
            int n3 = arrayList.size();
            if (expression instanceof ExpressionColumn) {
                object = (ExpressionColumn)expression;
                String string = ((ExpressionColumn)object).getOriginalTableAliasName();
                String string2 = ((ExpressionColumn)object).getOriginalColumnName();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object2;
                    Object object3;
                    Expression expression2;
                    boolean bl4 = false;
                    Expression expression3 = arrayList.get(i2);
                    if (expression3 instanceof ExpressionColumn) {
                        expression2 = (ExpressionColumn)expression3;
                        bl4 = database.equalsIdentifiers(string2, ((ExpressionColumn)expression2).getColumnName());
                        if (bl4 && string != null) {
                            object3 = ((ExpressionColumn)expression2).getOriginalTableAliasName();
                            if (object3 == null) {
                                bl4 = false;
                                if (arrayList4 != null) {
                                    int n4 = arrayList4.size();
                                    for (int i3 = 0; i3 < n4; ++i3) {
                                        object2 = arrayList4.get(i3);
                                        if (!database.equalsIdentifiers(((TableFilter)object2).getTableAlias(), string)) continue;
                                        bl4 = true;
                                        break;
                                    }
                                }
                            } else {
                                bl4 = database.equalsIdentifiers((String)object3, string);
                            }
                        }
                    } else {
                        if (!(expression3 instanceof Alias)) continue;
                        if (string == null && database.equalsIdentifiers(string2, expression3.getAlias())) {
                            bl4 = true;
                        } else {
                            expression2 = expression3.getNonAliasExpression();
                            if (expression2 instanceof ExpressionColumn) {
                                object3 = expression2;
                                String string3 = ((ExpressionColumn)object).getSQL();
                                String string4 = ((ExpressionColumn)object3).getSQL();
                                object2 = ((ExpressionColumn)object3).getColumnName();
                                bl4 = database.equalsIdentifiers(string2, (String)object2);
                                if (!database.equalsIdentifiers(string3, string4)) {
                                    bl4 = false;
                                }
                            }
                        }
                    }
                    if (!bl4) continue;
                    n3 = i2;
                    bl3 = true;
                    break;
                }
            } else {
                object = expression.getSQL();
                if (arrayList2 != null) {
                    int n5 = arrayList2.size();
                    for (int i4 = 0; i4 < n5; ++i4) {
                        String string = arrayList2.get(i4);
                        if (!database.equalsIdentifiers(string, (String)object)) continue;
                        n3 = i4;
                        bl3 = true;
                        break;
                    }
                }
            }
            if (!bl3) {
                if (bl2) {
                    throw DbException.get(90068, expression.getSQL());
                }
                arrayList.add(expression);
                object = expression.getSQL();
                arrayList2.add((String)object);
            }
            selectOrderBy.columnIndexExpr = ValueExpression.get(ValueInt.get(n3 + 1));
            selectOrderBy.expression = object = arrayList.get(n3).getNonAliasExpression();
        }
    }

    public SortOrder prepareOrder(ArrayList<SelectOrderBy> arrayList, int n2) {
        int n3 = arrayList.size();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5;
            SelectOrderBy selectOrderBy = arrayList.get(i2);
            boolean bl2 = false;
            Expression expression = selectOrderBy.columnIndexExpr;
            Value value = expression.getValue(null);
            if (value == ValueNull.INSTANCE) {
                n5 = 0;
            } else {
                n5 = value.getInt();
                if (n5 < 0) {
                    bl2 = true;
                    n5 = -n5;
                }
                if (--n5 < 0 || n5 >= n2) {
                    throw DbException.get(90068, "" + (n5 + 1));
                }
            }
            nArray[i2] = n5;
            boolean bl3 = selectOrderBy.descending;
            if (bl2) {
                bl3 = !bl3;
            }
            int n6 = n4 = bl3 ? 1 : 0;
            if (selectOrderBy.nullsFirst) {
                n4 += 2;
            } else if (selectOrderBy.nullsLast) {
                n4 += 4;
            }
            nArray2[i2] = n4;
        }
        return new SortOrder(this.session.getDatabase(), nArray, nArray2, arrayList);
    }

    public void setOffset(Expression expression) {
        this.offsetExpr = expression;
    }

    public Expression getOffset() {
        return this.offsetExpr;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    public Expression getLimit() {
        return this.limitExpr;
    }

    void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = New.arrayList();
        }
        this.parameters.add(parameter);
    }

    public void setSampleSize(Expression expression) {
        this.sampleSizeExpr = expression;
    }

    int getSampleSizeValue(Session session) {
        if (this.sampleSizeExpr == null) {
            return 0;
        }
        Value value = this.sampleSizeExpr.optimize(session).getValue(session);
        if (value == ValueNull.INSTANCE) {
            return 0;
        }
        return value.getInt();
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getMaxModificationIdVisitor();
        this.isEverything(expressionVisitor);
        return expressionVisitor.getMaxDataModificationId();
    }
}

