/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.Random;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.table.Plan;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.util.BitField;
import org.h2.util.Permutations;

class Optimizer {
    private static final int MAX_BRUTE_FORCE_FILTERS = 7;
    private static final int MAX_BRUTE_FORCE = 2000;
    private static final int MAX_GENETIC = 500;
    private long start;
    private BitField switched;
    private final TableFilter[] filters;
    private final Expression condition;
    private final Session session;
    private Plan bestPlan;
    private TableFilter topFilter;
    private double cost;
    private Random random;

    Optimizer(TableFilter[] tableFilterArray, Expression expression, Session session) {
        this.filters = tableFilterArray;
        this.condition = expression;
        this.session = session;
    }

    private static int getMaxBruteForceFilters(int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = n2;
        while (n4 > 0 && n5 * (n4 * (n4 - 1) / 2) < 2000) {
            n5 *= --n4;
            ++n3;
        }
        return n3;
    }

    private void calculateBestPlan() {
        this.cost = -1.0;
        if (this.filters.length == 1 || this.session.isForceJoinOrder()) {
            this.testPlan(this.filters);
        } else {
            this.start = System.currentTimeMillis();
            if (this.filters.length <= 7) {
                this.calculateBruteForceAll();
            } else {
                this.calculateBruteForceSome();
                this.random = new Random(0L);
                this.calculateGenetic();
            }
        }
    }

    private void calculateFakePlan() {
        this.cost = -1.0;
        this.bestPlan = new Plan(this.filters, this.filters.length, this.condition);
    }

    private boolean canStop(int n2) {
        if ((n2 & 0x7F) == 0) {
            long l2 = System.currentTimeMillis() - this.start;
            if (this.cost >= 0.0 && (double)(10L * l2) > this.cost) {
                return true;
            }
        }
        return false;
    }

    private void calculateBruteForceAll() {
        TableFilter[] tableFilterArray = new TableFilter[this.filters.length];
        Permutations<TableFilter> permutations = Permutations.create(this.filters, tableFilterArray);
        int n2 = 0;
        while (!this.canStop(n2) && permutations.next()) {
            this.testPlan(tableFilterArray);
            ++n2;
        }
    }

    private void calculateBruteForceSome() {
        int n2 = Optimizer.getMaxBruteForceFilters(this.filters.length);
        TableFilter[] tableFilterArray = new TableFilter[this.filters.length];
        Permutations<TableFilter> permutations = Permutations.create(this.filters, tableFilterArray, n2);
        int n3 = 0;
        while (!this.canStop(n3) && permutations.next()) {
            int n4;
            for (TableFilter tableFilter : this.filters) {
                tableFilter.setUsed(false);
            }
            for (n4 = 0; n4 < n2; ++n4) {
                tableFilterArray[n4].setUsed(true);
            }
            for (n4 = n2; n4 < this.filters.length; ++n4) {
                double d2 = -1.0;
                int n5 = -1;
                for (int i2 = 0; i2 < this.filters.length; ++i2) {
                    if (this.filters[i2].isUsed()) continue;
                    if (n4 == this.filters.length - 1) {
                        n5 = i2;
                        break;
                    }
                    tableFilterArray[n4] = this.filters[i2];
                    Plan plan = new Plan(tableFilterArray, n4 + 1, this.condition);
                    double d3 = plan.calculateCost(this.session);
                    if (!(d2 < 0.0) && !(d3 < d2)) continue;
                    d2 = d3;
                    n5 = i2;
                }
                this.filters[n5].setUsed(true);
                tableFilterArray[n4] = this.filters[n5];
            }
            this.testPlan(tableFilterArray);
            ++n3;
        }
    }

    private void calculateGenetic() {
        TableFilter[] tableFilterArray = new TableFilter[this.filters.length];
        TableFilter[] tableFilterArray2 = new TableFilter[this.filters.length];
        for (int i2 = 0; i2 < 500 && !this.canStop(i2); ++i2) {
            boolean bl2;
            boolean bl3 = bl2 = (i2 & 0x7F) == 0;
            if (!bl2) {
                System.arraycopy(tableFilterArray, 0, tableFilterArray2, 0, this.filters.length);
                if (!this.shuffleTwo(tableFilterArray2)) {
                    bl2 = true;
                }
            }
            if (bl2) {
                this.switched = new BitField();
                System.arraycopy(this.filters, 0, tableFilterArray, 0, this.filters.length);
                this.shuffleAll(tableFilterArray);
                System.arraycopy(tableFilterArray, 0, tableFilterArray2, 0, this.filters.length);
            }
            if (!this.testPlan(tableFilterArray2)) continue;
            this.switched = new BitField();
            System.arraycopy(tableFilterArray2, 0, tableFilterArray, 0, this.filters.length);
        }
    }

    private boolean testPlan(TableFilter[] tableFilterArray) {
        Plan plan = new Plan(tableFilterArray, tableFilterArray.length, this.condition);
        double d2 = plan.calculateCost(this.session);
        if (this.cost < 0.0 || d2 < this.cost) {
            this.cost = d2;
            this.bestPlan = plan;
            return true;
        }
        return false;
    }

    private void shuffleAll(TableFilter[] tableFilterArray) {
        for (int i2 = 0; i2 < tableFilterArray.length - 1; ++i2) {
            int n2 = i2 + this.random.nextInt(tableFilterArray.length - i2);
            if (n2 == i2) continue;
            TableFilter tableFilter = tableFilterArray[i2];
            tableFilterArray[i2] = tableFilterArray[n2];
            tableFilterArray[n2] = tableFilter;
        }
    }

    private boolean shuffleTwo(TableFilter[] tableFilterArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < 20; ++n2) {
            int n5;
            n3 = this.random.nextInt(tableFilterArray.length);
            if (n3 == (n4 = this.random.nextInt(tableFilterArray.length))) continue;
            if (n3 < n4) {
                n5 = n3;
                n3 = n4;
                n4 = n5;
            }
            if (this.switched.get(n5 = n3 * tableFilterArray.length + n4)) continue;
            this.switched.set(n5);
            break;
        }
        if (n2 == 20) {
            return false;
        }
        TableFilter tableFilter = tableFilterArray[n3];
        tableFilterArray[n3] = tableFilterArray[n4];
        tableFilterArray[n4] = tableFilter;
        return true;
    }

    void optimize(boolean bl2) {
        if (bl2) {
            this.calculateFakePlan();
        } else {
            this.calculateBestPlan();
            this.bestPlan.removeUnusableIndexConditions();
        }
        TableFilter[] tableFilterArray = this.bestPlan.getFilters();
        this.topFilter = tableFilterArray[0];
        for (int i2 = 0; i2 < tableFilterArray.length - 1; ++i2) {
            tableFilterArray[i2].addJoin(tableFilterArray[i2 + 1], false, false, null);
        }
        if (bl2) {
            return;
        }
        for (TableFilter tableFilter : tableFilterArray) {
            PlanItem planItem = this.bestPlan.getItem(tableFilter);
            tableFilter.setPlanItem(planItem);
        }
    }

    public TableFilter getTopFilter() {
        return this.topFilter;
    }

    double getCost() {
        return this.cost;
    }
}

