/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public class Merge
extends Prepared {
    private Table table;
    private Column[] columns;
    private Column[] keys;
    private final ArrayList<Expression[]> list = New.arrayList();
    private Query query;
    private Prepared update;

    public Merge(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setKeys(Column[] columnArray) {
        this.keys = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expressionArray) {
        this.list.add(expressionArray);
    }

    @Override
    public int update() {
        int n2;
        this.session.getUser().checkRight(this.table, 4);
        this.session.getUser().checkRight(this.table, 8);
        this.setCurrentRowNumber(0);
        if (this.list.size() > 0) {
            n2 = 0;
            int n3 = this.list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.setCurrentRowNumber(i2 + 1);
                Expression[] expressionArray = this.list.get(i2);
                Row row = this.table.getTemplateRow();
                int n4 = this.columns.length;
                for (int i3 = 0; i3 < n4; ++i3) {
                    Column column = this.columns[i3];
                    int n5 = column.getColumnId();
                    Expression expression = expressionArray[i3];
                    if (expression == null) continue;
                    try {
                        Value value = column.convert(expression.getValue(this.session));
                        row.setValue(n5, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n2, Merge.getSQL(expressionArray));
                    }
                }
                this.merge(row);
                ++n2;
            }
        } else {
            LocalResult localResult = this.query.query(0);
            n2 = 0;
            this.table.fire(this.session, 3, true);
            this.table.lock(this.session, true, false);
            while (localResult.next()) {
                Value[] valueArray = localResult.currentRow();
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(++n2);
                for (int i4 = 0; i4 < this.columns.length; ++i4) {
                    Column column = this.columns[i4];
                    int n6 = column.getColumnId();
                    try {
                        Value value = column.convert(valueArray[i4]);
                        row.setValue(n6, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n2, Merge.getSQL(valueArray));
                    }
                }
                this.merge(row);
            }
            localResult.close();
            this.table.fire(this.session, 3, false);
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(Row row) {
        Column[] columnArray;
        Object object;
        Column column;
        int n2;
        ArrayList<Parameter> arrayList = this.update.getParameters();
        for (n2 = 0; n2 < this.columns.length; ++n2) {
            column = this.columns[n2];
            object = row.getValue(column.getColumnId());
            columnArray = arrayList.get(n2);
            columnArray.setValue((Value)object);
        }
        for (n2 = 0; n2 < this.keys.length; ++n2) {
            column = this.keys[n2];
            object = row.getValue(column.getColumnId());
            if (object == null) {
                throw DbException.get(90081, column.getSQL());
            }
            columnArray = arrayList.get(this.columns.length + n2);
            columnArray.setValue((Value)object);
        }
        n2 = this.update.update();
        if (n2 == 0) {
            try {
                this.table.validateConvertUpdateSequence(this.session, row);
                boolean bl2 = this.table.fireBeforeRow(this.session, null, row);
                if (bl2) return;
                this.table.lock(this.session, true, false);
                this.table.addRow(this.session, row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row, false);
                return;
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() != 23505 || (object = (Index)dbException.getSource()) == null) throw dbException;
                columnArray = object.getColumns();
                boolean bl3 = false;
                if (columnArray.length <= this.keys.length) {
                    for (int i2 = 0; i2 < columnArray.length; ++i2) {
                        if (columnArray[i2] == this.keys[i2]) continue;
                        bl3 = false;
                        break;
                    }
                }
                if (!bl3) throw dbException;
                throw DbException.get(90131, this.table.getName());
            }
        } else {
            if (n2 == 1) return;
            throw DbException.get(23505, this.table.getSQL());
        }
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("MERGE INTO ");
        statementBuilder.append(this.table.getSQL()).append('(');
        for (Column expressionArray : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray.getSQL());
        }
        statementBuilder.append(')');
        if (this.keys != null) {
            statementBuilder.append(" KEY(");
            statementBuilder.resetCount();
            for (Column column : this.keys) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getSQL());
            }
            statementBuilder.append(')');
        }
        statementBuilder.append('\n');
        if (this.list.size() > 0) {
            statementBuilder.append("VALUES ");
            int n2 = 0;
            for (Expression[] expressionArray : this.list) {
                if (n2++ > 0) {
                    statementBuilder.append(", ");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (Expression expression : expressionArray) {
                    statementBuilder.appendExceptFirst(", ");
                    if (expression == null) {
                        statementBuilder.append("DEFAULT");
                        continue;
                    }
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
            }
        } else {
            statementBuilder.append(this.query.getPlanSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public void prepare() {
        Object object;
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (Expression[] object22 : this.list) {
                if (object22.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i2 = 0; i2 < object22.length; ++i2) {
                    Expression expression = object22[i2];
                    if (expression == null) continue;
                    object22[i2] = expression.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            object = this.table.getPrimaryKey();
            if (object == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = object.getColumns();
        }
        object = new StatementBuilder("UPDATE ");
        ((StatementBuilder)object).append(this.table.getSQL()).append(" SET ");
        for (Column column : this.columns) {
            ((StatementBuilder)object).appendExceptFirst(", ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
        }
        ((StatementBuilder)object).append(" WHERE ");
        ((StatementBuilder)object).resetCount();
        for (Column column : this.keys) {
            ((StatementBuilder)object).appendExceptFirst(" AND ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
        }
        String string = ((StatementBuilder)object).toString();
        this.update = this.session.prepare(string);
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 62;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

