/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class AlterTableSet
extends SchemaCommand {
    private boolean ifTableExists;
    private String tableName;
    private final int type;
    private final boolean value;
    private boolean checkExisting;

    public AlterTableSet(Session session, Schema schema, int n2, boolean bl2) {
        super(session, schema);
        this.type = n2;
        this.value = bl2;
    }

    public void setCheckExisting(boolean bl2) {
        this.checkExisting = bl2;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void setIfTableExists(boolean bl2) {
        this.ifTableExists = bl2;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    @Override
    public int update() {
        Table table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        switch (this.type) {
            case 55: {
                table.setCheckForeignKeyConstraints(this.session, this.value, this.value ? this.checkExisting : false);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    @Override
    public int getType() {
        return this.type;
    }
}

