/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.util.New;

public class GrantRevoke
extends DefineCommand {
    private ArrayList<String> roleNames;
    private int operationType;
    private int rightMask;
    private final ArrayList<Table> tables = New.arrayList();
    private Schema schema;
    private RightOwner grantee;

    public GrantRevoke(Session session) {
        super(session);
    }

    public void setOperationType(int n2) {
        this.operationType = n2;
    }

    public void addRight(int n2) {
        this.rightMask |= n2;
    }

    public void addRoleName(String string) {
        if (this.roleNames == null) {
            this.roleNames = New.arrayList();
        }
        this.roleNames.add(string);
    }

    public void setGranteeName(String string) {
        Database database = this.session.getDatabase();
        this.grantee = database.findUser(string);
        if (this.grantee == null) {
            this.grantee = database.findRole(string);
            if (this.grantee == null) {
                throw DbException.get(90071, string);
            }
        }
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.roleNames != null) {
            for (String string : this.roleNames) {
                Role role = database.findRole(string);
                if (role == null) {
                    throw DbException.get(90070, string);
                }
                if (this.operationType == 49) {
                    this.grantRole(role);
                    continue;
                }
                if (this.operationType == 50) {
                    this.revokeRole(role);
                    continue;
                }
                DbException.throwInternalError("type=" + this.operationType);
            }
        } else if (this.operationType == 49) {
            this.grantRight();
        } else if (this.operationType == 50) {
            this.revokeRight();
        } else {
            DbException.throwInternalError("type=" + this.operationType);
        }
        return 0;
    }

    private void grantRight() {
        if (this.schema != null) {
            this.grantRight(this.schema);
        }
        for (Table table : this.tables) {
            this.grantRight(table);
        }
    }

    private void grantRight(DbObject dbObject) {
        Database database = this.session.getDatabase();
        Right right = this.grantee.getRightForObject(dbObject);
        if (right == null) {
            int n2 = this.getObjectId();
            right = new Right(database, n2, this.grantee, this.rightMask, dbObject);
            this.grantee.grantRight(dbObject, right);
            database.addDatabaseObject(this.session, right);
        } else {
            right.setRightMask(right.getRightMask() | this.rightMask);
            database.updateMeta(this.session, right);
        }
    }

    private void grantRole(Role role) {
        Object object;
        if (role != this.grantee && this.grantee.isRoleGranted(role)) {
            return;
        }
        if (this.grantee instanceof Role && role.isRoleGranted((Role)(object = (Role)this.grantee))) {
            throw DbException.get(90074, role.getSQL());
        }
        object = this.session.getDatabase();
        int n2 = this.getObjectId();
        Right right = new Right((Database)object, n2, this.grantee, role);
        ((Database)object).addDatabaseObject(this.session, right);
        this.grantee.grantRole(role, right);
    }

    private void revokeRight() {
        if (this.schema != null) {
            this.revokeRight(this.schema);
        }
        for (Table table : this.tables) {
            this.revokeRight(table);
        }
    }

    private void revokeRight(DbObject dbObject) {
        Right right = this.grantee.getRightForObject(dbObject);
        if (right == null) {
            return;
        }
        int n2 = right.getRightMask();
        int n3 = n2 & ~this.rightMask;
        Database database = this.session.getDatabase();
        if (n3 == 0) {
            database.removeDatabaseObject(this.session, right);
        } else {
            right.setRightMask(n3);
            database.updateMeta(this.session, right);
        }
    }

    private void revokeRole(Role role) {
        Right right = this.grantee.getRightForRole(role);
        if (right == null) {
            return;
        }
        Database database = this.session.getDatabase();
        database.removeDatabaseObject(this.session, right);
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    public void addTable(Table table) {
        this.tables.add(table);
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public int getType() {
        return this.operationType;
    }

    public boolean isRoleMode() {
        return this.roleNames != null;
    }

    public boolean isRightMode() {
        return this.rightMask != 0;
    }
}

