/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.StatementBuilder;

public class DropTable
extends SchemaCommand {
    private boolean ifExists;
    private String tableName;
    private Table table;
    private DropTable next;
    private int dropAction;

    public DropTable(Session session, Schema schema) {
        super(session, schema);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? 0 : 1;
    }

    public void addNextDropTable(DropTable dropTable) {
        if (this.next == null) {
            this.next = dropTable;
        } else {
            this.next.addNextDropTable(dropTable);
        }
    }

    public void setIfExists(boolean bl2) {
        this.ifExists = bl2;
        if (this.next != null) {
            this.next.setIfExists(bl2);
        }
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    private void prepareDrop() {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table == null) {
            if (!this.ifExists) {
                throw DbException.get(42102, this.tableName);
            }
        } else {
            ArrayList<TableView> arrayList;
            this.session.getUser().checkRight(this.table, 15);
            if (!this.table.canDrop()) {
                throw DbException.get(90118, this.tableName);
            }
            if (this.dropAction == 0 && (arrayList = this.table.getViews()) != null && arrayList.size() > 0) {
                StatementBuilder statementBuilder = new StatementBuilder();
                for (TableView tableView : arrayList) {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(tableView.getName());
                }
                throw DbException.get(90107, this.tableName, statementBuilder.toString());
            }
            this.table.lock(this.session, true, true);
        }
        if (this.next != null) {
            this.next.prepareDrop();
        }
    }

    private void executeDrop() {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table != null) {
            this.table.setModified();
            Database database = this.session.getDatabase();
            database.lockMeta(this.session);
            database.removeSchemaObject(this.session, this.table);
        }
        if (this.next != null) {
            this.next.executeDrop();
        }
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.prepareDrop();
        this.executeDrop();
        return 0;
    }

    public void setDropAction(int n2) {
        this.dropAction = n2;
        if (this.next != null) {
            this.next.setDropAction(n2);
        }
    }

    @Override
    public int getType() {
        return 44;
    }
}

