/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.value.DataType;

public class CreateTable
extends SchemaCommand {
    private final CreateTableData data = new CreateTableData();
    private final ArrayList<DefineCommand> constraintCommands = New.arrayList();
    private IndexColumn[] pkColumns;
    private boolean ifNotExists;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean sortedInsertMode;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
        this.data.persistIndexes = true;
        this.data.persistData = true;
    }

    public void setQuery(Query query) {
        this.asQuery = query;
    }

    public void setTemporary(boolean bl2) {
        this.data.temporary = bl2;
    }

    public void setTableName(String string) {
        this.data.tableName = string;
    }

    public void addColumn(Column column) {
        this.data.columns.add(column);
    }

    public void addConstraintCommand(DefineCommand defineCommand) {
        if (defineCommand instanceof CreateIndex) {
            this.constraintCommands.add(defineCommand);
        } else {
            AlterTableAddConstraint alterTableAddConstraint = (AlterTableAddConstraint)defineCommand;
            boolean bl2 = alterTableAddConstraint.getType() == 6 ? this.setPrimaryKeyColumns(alterTableAddConstraint.getIndexColumns()) : false;
            if (!bl2) {
                this.constraintCommands.add(defineCommand);
            }
        }
    }

    public void setIfNotExists(boolean bl2) {
        this.ifNotExists = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        boolean bl2;
        Database database;
        if (!this.transactional) {
            this.session.commit(true);
        }
        if (!(database = this.session.getDatabase()).isPersistent()) {
            this.data.persistIndexes = false;
        }
        boolean bl3 = bl2 = this.data.temporary && !this.data.globalTemporary;
        if (!bl2) {
            database.lockMeta(this.session);
        }
        if (this.getSchema().findTableOrView(this.session, this.data.tableName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(42101, this.data.tableName);
        }
        if (this.asQuery != null) {
            this.asQuery.prepare();
            if (this.data.columns.size() == 0) {
                this.generateColumnsFromQuery();
            } else if (this.data.columns.size() != this.asQuery.getColumnCount()) {
                throw DbException.get(21002);
            }
        }
        if (this.pkColumns != null) {
            for (Column object2 : this.data.columns) {
                for (IndexColumn indexColumn : this.pkColumns) {
                    if (!object2.getName().equals(indexColumn.columnName)) continue;
                    object2.setNullable(false);
                }
            }
        }
        this.data.id = this.getObjectId();
        this.data.create = this.create;
        this.data.session = this.session;
        Table table = this.getSchema().createTable(this.data);
        ArrayList arrayList = New.arrayList();
        for (Column column : this.data.columns) {
            Sequence dbObject;
            if (column.isAutoIncrement()) {
                int sequence = this.getObjectId();
                column.convertAutoIncrementToSequence(this.session, this.getSchema(), sequence, this.data.temporary);
                if (!"''".equals(this.session.getDatabase().getCluster())) {
                    throw DbException.getUnsupportedException("CLUSTERING && auto-increment columns");
                }
            }
            if ((dbObject = column.getSequence()) == null) continue;
            arrayList.add(dbObject);
        }
        table.setComment(this.comment);
        if (bl2) {
            if (this.onCommitDrop) {
                table.setOnCommitDrop(true);
            }
            if (this.onCommitTruncate) {
                table.setOnCommitTruncate(true);
            }
            this.session.addLocalTempTable(table);
        } else {
            database.lockMeta(this.session);
            database.addSchemaObject(this.session, table);
        }
        try {
            for (Column sequence : this.data.columns) {
                sequence.prepareExpression(this.session);
            }
            for (Sequence defineCommand : arrayList) {
                table.addSequence(defineCommand);
            }
            for (DefineCommand insert : this.constraintCommands) {
                insert.setTransactional(this.transactional);
                insert.update();
            }
            if (this.asQuery != null) {
                boolean hashSet = this.session.isUndoLogEnabled();
                try {
                    this.session.setUndoLogEnabled(false);
                    this.session.startStatementWithinTransaction();
                    Insert insert = null;
                    insert = new Insert(this.session);
                    insert.setSortedInsertMode(this.sortedInsertMode);
                    insert.setQuery(this.asQuery);
                    insert.setTable(table);
                    insert.setInsertFromSelect(true);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.setUndoLogEnabled(hashSet);
                }
            }
            HashSet<DbObject> dbException = New.hashSet();
            dbException.clear();
            table.addDependencies(dbException);
            for (DbObject dbObject : dbException) {
                Table table2;
                if (dbObject == table || dbObject.getType() != 0 || !(dbObject instanceof Table) || (table2 = (Table)dbObject).getId() <= table.getId()) continue;
                throw DbException.get(50100, "Table depends on another table with a higher ID: " + table2 + ", this is currently not supported, " + "as it would prevent the database from " + "being re-opened");
            }
        }
        catch (DbException dbException) {
            database.checkPowerOff();
            database.removeSchemaObject(this.session, table);
            if (!this.transactional) {
                this.session.commit(true);
            }
            throw dbException;
        }
        return 0;
    }

    private void generateColumnsFromQuery() {
        int n2 = this.asQuery.getColumnCount();
        ArrayList<Expression> arrayList = this.asQuery.getExpressions();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            Expression expression = arrayList.get(i2);
            int n4 = expression.getType();
            String string = expression.getAlias();
            long l2 = expression.getPrecision();
            int n5 = expression.getDisplaySize();
            DataType dataType = DataType.getDataType(n4);
            if (l2 > 0L && (dataType.defaultPrecision == 0L || dataType.defaultPrecision > l2 && dataType.defaultPrecision < 127L)) {
                l2 = dataType.defaultPrecision;
            }
            if ((n3 = expression.getScale()) > 0 && (dataType.defaultScale == 0 || dataType.defaultScale > n3 && (long)dataType.defaultScale < l2)) {
                n3 = dataType.defaultScale;
            }
            if ((long)n3 > l2) {
                l2 = n3;
            }
            Column column = new Column(string, n4, l2, n3, n5);
            this.addColumn(column);
        }
    }

    private boolean setPrimaryKeyColumns(IndexColumn[] indexColumnArray) {
        if (this.pkColumns != null) {
            int n2 = indexColumnArray.length;
            if (n2 != this.pkColumns.length) {
                throw DbException.get(90017);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (indexColumnArray[i2].columnName.equals(this.pkColumns[i2].columnName)) continue;
                throw DbException.get(90017);
            }
            return true;
        }
        this.pkColumns = indexColumnArray;
        return false;
    }

    public void setPersistIndexes(boolean bl2) {
        this.data.persistIndexes = bl2;
    }

    public void setGlobalTemporary(boolean bl2) {
        this.data.globalTemporary = bl2;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setPersistData(boolean bl2) {
        this.data.persistData = bl2;
        if (!bl2) {
            this.data.persistIndexes = false;
        }
    }

    public void setSortedInsertMode(boolean bl2) {
        this.sortedInsertMode = bl2;
    }

    public void setTableEngine(String string) {
        this.data.tableEngine = string;
    }

    public void setTableEngineParams(ArrayList<String> arrayList) {
        this.data.tableEngineParams = arrayList;
    }

    public void setHidden(boolean bl2) {
        this.data.isHidden = bl2;
    }

    @Override
    public int getType() {
        return 30;
    }
}

