/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.TableLink;

public class CreateLinkedTable
extends SchemaCommand {
    private String tableName;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalSchema;
    private String originalTable;
    private boolean ifNotExists;
    private String comment;
    private boolean emitUpdates;
    private boolean force;
    private boolean temporary;
    private boolean globalTemporary;
    private boolean readOnly;

    public CreateLinkedTable(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setOriginalTable(String string) {
        this.originalTable = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setIfNotExists(boolean bl2) {
        this.ifNotExists = bl2;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (this.getSchema().findTableOrView(this.session, this.tableName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(42101, this.tableName);
        }
        int n2 = this.getObjectId();
        TableLink tableLink = this.getSchema().createTableLink(n2, this.tableName, this.driver, this.url, this.user, this.password, this.originalSchema, this.originalTable, this.emitUpdates, this.force);
        tableLink.setTemporary(this.temporary);
        tableLink.setGlobalTemporary(this.globalTemporary);
        tableLink.setComment(this.comment);
        tableLink.setReadOnly(this.readOnly);
        if (this.temporary && !this.globalTemporary) {
            this.session.addLocalTempTable(tableLink);
        } else {
            database.addSchemaObject(this.session, tableLink);
        }
        return 0;
    }

    public void setEmitUpdates(boolean bl2) {
        this.emitUpdates = bl2;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setForce(boolean bl2) {
        this.force = bl2;
    }

    public void setTemporary(boolean bl2) {
        this.temporary = bl2;
    }

    public void setGlobalTemporary(boolean bl2) {
        this.globalTemporary = bl2;
    }

    public void setReadOnly(boolean bl2) {
        this.readOnly = bl2;
    }

    public void setOriginalSchema(String string) {
        this.originalSchema = string;
    }

    @Override
    public int getType() {
        return 26;
    }
}

