/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.IndexColumn;
import org.h2.table.Table;

public class CreateIndex
extends SchemaCommand {
    private String tableName;
    private String indexName;
    private IndexColumn[] indexColumns;
    private boolean primaryKey;
    private boolean unique;
    private boolean hash;
    private boolean spatial;
    private boolean ifTableExists;
    private boolean ifNotExists;
    private String comment;

    public CreateIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean bl2) {
        this.ifTableExists = bl2;
    }

    public void setIfNotExists(boolean bl2) {
        this.ifNotExists = bl2;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public void setIndexColumns(IndexColumn[] indexColumnArray) {
        this.indexColumns = indexColumnArray;
    }

    @Override
    public int update() {
        IndexType indexType;
        if (!this.transactional) {
            this.session.commit(true);
        }
        Database database = this.session.getDatabase();
        boolean bl2 = database.isPersistent();
        Table table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        if (this.getSchema().findIndex(this.session, this.indexName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(42111, this.indexName);
        }
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        if (!table.isPersistIndexes()) {
            bl2 = false;
        }
        int n2 = this.getObjectId();
        if (this.indexName == null) {
            this.indexName = this.primaryKey ? table.getSchema().getUniqueIndexName(this.session, table, "PRIMARY_KEY_") : table.getSchema().getUniqueIndexName(this.session, table, "INDEX_");
        }
        if (this.primaryKey) {
            if (table.findPrimaryKey() != null) {
                throw DbException.get(90017);
            }
            indexType = IndexType.createPrimaryKey(bl2, this.hash);
        } else {
            indexType = this.unique ? IndexType.createUnique(bl2, this.hash) : IndexType.createNonUnique(bl2, this.hash, this.spatial);
        }
        IndexColumn.mapColumns(this.indexColumns, table);
        table.addIndex(this.session, this.indexName, n2, this.indexColumns, indexType, this.create, this.comment);
        return 0;
    }

    public void setPrimaryKey(boolean bl2) {
        this.primaryKey = bl2;
    }

    public void setUnique(boolean bl2) {
        this.unique = bl2;
    }

    public void setHash(boolean bl2) {
        this.hash = bl2;
    }

    public void setSpatial(boolean bl2) {
        this.spatial = bl2;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public int getType() {
        return 25;
    }
}

