/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.ResultInterface;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public abstract class Prepared {
    protected Session session;
    protected String sqlStatement;
    protected boolean create = true;
    protected ArrayList<Parameter> parameters;
    protected boolean prepareAlways;
    private long modificationMetaId;
    private Command command;
    private int objectId;
    private int currentRowNumber;
    private int rowScanCount;

    public Prepared(Session session) {
        this.session = session;
        this.modificationMetaId = session.getDatabase().getModificationMetaId();
    }

    public abstract boolean isTransactional();

    public abstract ResultInterface queryMeta();

    public abstract int getType();

    public boolean isReadOnly() {
        return false;
    }

    public boolean needRecompile() {
        Database database = this.session.getDatabase();
        if (database == null) {
            throw DbException.get(90067, "database closed");
        }
        return this.prepareAlways || this.modificationMetaId < database.getModificationMetaId() || database.getSettings().recompileAlways;
    }

    long getModificationMetaId() {
        return this.modificationMetaId;
    }

    void setModificationMetaId(long l2) {
        this.modificationMetaId = l2;
    }

    public void setParameterList(ArrayList<Parameter> arrayList) {
        this.parameters = arrayList;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    protected void checkParameters() {
        if (this.parameters != null) {
            int n2 = this.parameters.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Parameter parameter = this.parameters.get(i2);
                parameter.checkSet();
            }
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean isQuery() {
        return false;
    }

    public void prepare() {
    }

    public int update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(int n2) {
        throw DbException.get(90002);
    }

    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    public String getSQL() {
        return this.sqlStatement;
    }

    protected int getCurrentObjectId() {
        return this.objectId;
    }

    protected int getObjectId() {
        int n2 = this.objectId;
        if (n2 == 0) {
            n2 = this.session.getDatabase().allocateObjectId();
        } else {
            this.objectId = 0;
        }
        return n2;
    }

    public String getPlanSQL() {
        return null;
    }

    public void checkCanceled() {
        Command command;
        this.session.checkCanceled();
        Command command2 = command = this.command != null ? this.command : this.session.getCurrentCommand();
        if (command != null) {
            command.checkCanceled();
        }
    }

    public void setObjectId(int n2) {
        this.objectId = n2;
        this.create = false;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    void trace(long l2, int n2) {
        long l3;
        if (this.session.getTrace().isInfoEnabled() && l2 > 0L) {
            l3 = System.currentTimeMillis() - l2;
            String string = Trace.formatParams(this.parameters);
            this.session.getTrace().infoSQL(this.sqlStatement, string, n2, l3);
        }
        if (this.session.getDatabase().getQueryStatistics()) {
            l3 = System.currentTimeMillis() - l2;
            this.session.getDatabase().getQueryStatisticsData().update(this.toString(), l3, n2);
        }
    }

    public void setPrepareAlways(boolean bl2) {
        this.prepareAlways = bl2;
    }

    protected void setCurrentRowNumber(int n2) {
        if ((++this.rowScanCount & 0x7F) == 0) {
            this.checkCanceled();
        }
        this.currentRowNumber = n2;
        this.setProgress();
    }

    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    private void setProgress() {
        if ((this.currentRowNumber & 0x7F) == 0) {
            this.session.getDatabase().setProgress(7, this.sqlStatement, this.currentRowNumber, 0);
        }
    }

    public String toString() {
        return this.sqlStatement;
    }

    protected static String getSQL(Value[] valueArray) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (Value value : valueArray) {
            statementBuilder.appendExceptFirst(", ");
            if (value == null) continue;
            statementBuilder.append(value.getSQL());
        }
        return statementBuilder.toString();
    }

    protected static String getSQL(Expression[] expressionArray) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (Expression expression : expressionArray) {
            statementBuilder.appendExceptFirst(", ");
            if (expression == null) continue;
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.toString();
    }

    protected DbException setRow(DbException dbException, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sqlStatement != null) {
            stringBuilder.append(this.sqlStatement);
        }
        stringBuilder.append(" -- ");
        if (n2 > 0) {
            stringBuilder.append("row #").append(n2 + 1).append(' ');
        }
        stringBuilder.append('(').append(string).append(')');
        return dbException.addSQL(stringBuilder.toString());
    }

    public boolean isCacheable() {
        return false;
    }
}

