/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.io.IOException;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionRemote;
import org.h2.engine.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ParameterRemote;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.ResultInterface;
import org.h2.result.ResultRemote;
import org.h2.util.New;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class CommandRemote
implements CommandInterface {
    private final ArrayList<Transfer> transferList;
    private final ArrayList<ParameterInterface> parameters;
    private final Trace trace;
    private final String sql;
    private final int fetchSize;
    private SessionRemote session;
    private int id;
    private boolean isQuery;
    private boolean readonly;
    private final int created;

    public CommandRemote(SessionRemote sessionRemote, ArrayList<Transfer> arrayList, String string, int n2) {
        this.transferList = arrayList;
        this.trace = sessionRemote.getTrace();
        this.sql = string;
        this.parameters = New.arrayList();
        this.prepare(sessionRemote, true);
        this.session = sessionRemote;
        this.fetchSize = n2;
        this.created = sessionRemote.getLastReconnect();
    }

    private void prepare(SessionRemote sessionRemote, boolean bl2) {
        this.id = sessionRemote.getNextId();
        int n2 = 0;
        for (int i2 = 0; i2 < this.transferList.size(); ++i2) {
            try {
                Transfer transfer = this.transferList.get(i2);
                if (bl2) {
                    sessionRemote.traceOperation("SESSION_PREPARE_READ_PARAMS", this.id);
                    transfer.writeInt(11).writeInt(this.id).writeString(this.sql);
                } else {
                    sessionRemote.traceOperation("SESSION_PREPARE", this.id);
                    transfer.writeInt(0).writeInt(this.id).writeString(this.sql);
                }
                sessionRemote.done(transfer);
                this.isQuery = transfer.readBoolean();
                this.readonly = transfer.readBoolean();
                int n3 = transfer.readInt();
                if (!bl2) continue;
                this.parameters.clear();
                for (int i3 = 0; i3 < n3; ++i3) {
                    ParameterRemote parameterRemote = new ParameterRemote(i3);
                    parameterRemote.readMetaData(transfer);
                    this.parameters.add(parameterRemote);
                }
                continue;
            }
            catch (IOException iOException) {
                sessionRemote.removeServer(iOException, i2--, ++n2);
            }
        }
    }

    @Override
    public boolean isQuery() {
        return this.isQuery;
    }

    public ArrayList<ParameterInterface> getParameters() {
        return this.parameters;
    }

    private void prepareIfRequired() {
        if (this.session.getLastReconnect() != this.created) {
            this.id = Integer.MIN_VALUE;
        }
        this.session.checkClosed();
        if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS) {
            this.prepare(this.session, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInterface getMetaData() {
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            if (!this.isQuery) {
                return null;
            }
            int n2 = this.session.getNextId();
            ResultRemote resultRemote = null;
            int n3 = 0;
            for (int i2 = 0; i2 < this.transferList.size(); ++i2) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i2);
                try {
                    this.session.traceOperation("COMMAND_GET_META_DATA", this.id);
                    transfer.writeInt(10).writeInt(this.id).writeInt(n2);
                    this.session.done(transfer);
                    int n4 = transfer.readInt();
                    resultRemote = new ResultRemote(this.session, transfer, n2, n4, Integer.MAX_VALUE);
                    break;
                }
                catch (IOException iOException) {
                    this.session.removeServer(iOException, i2--, ++n3);
                    continue;
                }
            }
            this.session.autoCommitIfCluster();
            return resultRemote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInterface executeQuery(int n2, boolean bl2) {
        this.checkParameters();
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            int n3 = this.session.getNextId();
            ResultRemote resultRemote = null;
            int n4 = 0;
            for (int i2 = 0; i2 < this.transferList.size(); ++i2) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i2);
                try {
                    this.session.traceOperation("COMMAND_EXECUTE_QUERY", this.id);
                    transfer.writeInt(2).writeInt(this.id).writeInt(n3).writeInt(n2);
                    int n5 = this.session.isClustered() || bl2 ? Integer.MAX_VALUE : this.fetchSize;
                    transfer.writeInt(n5);
                    this.sendParameters(transfer);
                    this.session.done(transfer);
                    int n6 = transfer.readInt();
                    if (resultRemote != null) {
                        resultRemote.close();
                        resultRemote = null;
                    }
                    resultRemote = new ResultRemote(this.session, transfer, n3, n6, n5);
                    if (!this.readonly) continue;
                    break;
                }
                catch (IOException iOException) {
                    this.session.removeServer(iOException, i2--, ++n4);
                }
            }
            this.session.autoCommitIfCluster();
            this.session.readSessionState();
            return resultRemote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() {
        this.checkParameters();
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            int n2 = 0;
            boolean bl2 = false;
            int n3 = 0;
            for (int i2 = 0; i2 < this.transferList.size(); ++i2) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i2);
                try {
                    this.session.traceOperation("COMMAND_EXECUTE_UPDATE", this.id);
                    transfer.writeInt(3).writeInt(this.id);
                    this.sendParameters(transfer);
                    this.session.done(transfer);
                    n2 = transfer.readInt();
                    bl2 = transfer.readBoolean();
                    continue;
                }
                catch (IOException iOException) {
                    this.session.removeServer(iOException, i2--, ++n3);
                }
            }
            this.session.setAutoCommitFromServer(bl2);
            this.session.autoCommitIfCluster();
            this.session.readSessionState();
            return n2;
        }
    }

    private void checkParameters() {
        for (ParameterInterface parameterInterface : this.parameters) {
            parameterInterface.checkSet();
        }
    }

    private void sendParameters(Transfer transfer) throws IOException {
        int n2 = this.parameters.size();
        transfer.writeInt(n2);
        for (ParameterInterface parameterInterface : this.parameters) {
            transfer.writeValue(parameterInterface.getParamValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.session == null || this.session.isClosed()) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.traceOperation("COMMAND_CLOSE", this.id);
            for (Transfer transfer : this.transferList) {
                try {
                    transfer.writeInt(4).writeInt(this.id);
                }
                catch (IOException iOException) {
                    this.trace.error(iOException, "close");
                }
            }
        }
        this.session = null;
        try {
            for (ParameterInterface parameterInterface : this.parameters) {
                Value value = parameterInterface.getParamValue();
                if (value == null) continue;
                value.remove();
            }
        }
        catch (DbException dbException) {
            this.trace.error(dbException, "close");
        }
        this.parameters.clear();
    }

    @Override
    public void cancel() {
        this.session.cancelStatement(this.id);
    }

    public String toString() {
        return this.sql + Trace.formatParams(this.getParameters());
    }

    @Override
    public int getCommandType() {
        return 0;
    }
}

