/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Query;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.result.ResultInterface;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class CommandContainer
extends Command {
    private Prepared prepared;
    private boolean readOnlyKnown;
    private boolean readOnly;

    CommandContainer(Parser parser, String string, Prepared prepared) {
        super(parser, string);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.prepared.getParameters();
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    @Override
    public void prepareJoinBatch() {
        if (this.session.isJoinBatchEnabled()) {
            CommandContainer.prepareJoinBatch(this.prepared);
        }
    }

    private static void prepareJoinBatch(Prepared prepared) {
        if (prepared.isQuery()) {
            if (prepared.getType() == 66) {
                ((Query)prepared).prepareJoinBatch();
            } else if (prepared.getType() == 60) {
                CommandContainer.prepareJoinBatch(((Explain)prepared).getCommand());
            }
        }
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String string = this.prepared.getSQL();
            ArrayList<Parameter> arrayList = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parse(string);
            long l2 = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ArrayList<Parameter> arrayList2 = this.prepared.getParameters();
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Parameter parameter = arrayList.get(i2);
                if (!parameter.isValueSet()) continue;
                Value value = parameter.getValue(this.session);
                Parameter parameter2 = arrayList2.get(i2);
                parameter2.setValue(value);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(l2);
            this.prepareJoinBatch();
        }
    }

    @Override
    public int update() {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.session.setLastScopeIdentity(ValueNull.INSTANCE);
        this.prepared.checkParameters();
        int n2 = this.prepared.update();
        this.prepared.trace(this.startTime, n2);
        this.setProgress(6);
        return n2;
    }

    @Override
    public ResultInterface query(int n2) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.prepared.checkParameters();
        ResultInterface resultInterface = this.prepared.query(n2);
        this.prepared.trace(this.startTime, resultInterface.getRowCount());
        this.setProgress(6);
        return resultInterface;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.readOnlyKnown) {
            this.readOnly = this.prepared.isReadOnly();
            this.readOnlyKnown = true;
        }
        return this.readOnly;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }
}

