/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.InputStream;
import org.bouncycastle.crypto.tls.ByteQueue;

public class ByteQueueInputStream
extends InputStream {
    private ByteQueue buffer = new ByteQueue();

    public void addBytes(byte[] byArray) {
        this.buffer.addData(byArray, 0, byArray.length);
    }

    public int peek(byte[] byArray) {
        int n2 = Math.min(this.buffer.available(), byArray.length);
        this.buffer.read(byArray, 0, n2, 0);
        return n2;
    }

    public int read() {
        if (this.buffer.available() == 0) {
            return -1;
        }
        return this.buffer.removeData(1, 0)[0] & 0xFF;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = Math.min(this.buffer.available(), n3);
        this.buffer.removeData(byArray, n2, n4, 0);
        return n4;
    }

    public long skip(long l2) {
        int n2 = Math.min((int)l2, this.buffer.available());
        this.buffer.removeData(n2);
        return n2;
    }

    public int available() {
        return this.buffer.available();
    }

    public void close() {
    }
}

