/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

public class ByteQueue {
    private static final int DEFAULT_CAPACITY = 1024;
    private byte[] databuf;
    private int skipped = 0;
    private int available = 0;

    public static int nextTwoPow(int n2) {
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        return n2 + 1;
    }

    public ByteQueue() {
        this(1024);
    }

    public ByteQueue(int n2) {
        this.databuf = new byte[n2];
    }

    public void read(byte[] byArray, int n2, int n3, int n4) {
        if (byArray.length - n2 < n3) {
            throw new IllegalArgumentException("Buffer size of " + byArray.length + " is too small for a read of " + n3 + " bytes");
        }
        if (this.available - n4 < n3) {
            throw new IllegalStateException("Not enough data to read");
        }
        System.arraycopy(this.databuf, this.skipped + n4, byArray, n2, n3);
    }

    public void addData(byte[] byArray, int n2, int n3) {
        if (this.skipped + this.available + n3 > this.databuf.length) {
            int n4 = ByteQueue.nextTwoPow(this.available + n3);
            if (n4 > this.databuf.length) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(this.databuf, this.skipped, byArray2, 0, this.available);
                this.databuf = byArray2;
            } else {
                System.arraycopy(this.databuf, this.skipped, this.databuf, 0, this.available);
            }
            this.skipped = 0;
        }
        System.arraycopy(byArray, n2, this.databuf, this.skipped + this.available, n3);
        this.available += n3;
    }

    public void removeData(int n2) {
        if (n2 > this.available) {
            throw new IllegalStateException("Cannot remove " + n2 + " bytes, only got " + this.available);
        }
        this.available -= n2;
        this.skipped += n2;
    }

    public void removeData(byte[] byArray, int n2, int n3, int n4) {
        this.read(byArray, n2, n3, n4);
        this.removeData(n4 + n3);
    }

    public byte[] removeData(int n2, int n3) {
        byte[] byArray = new byte[n2];
        this.removeData(byArray, 0, n2, n3);
        return byArray;
    }

    public int size() {
        return this.available;
    }

    public int available() {
        return this.available;
    }
}

