/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.xsd2inst;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CommandLine;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;

public class SchemaInstanceGenerator {
    public static void printUsage() {
        System.out.println("Generates a document based on the given Schema file");
        System.out.println("having the given element as root.");
        System.out.println("The tool makes reasonable attempts to create a valid document,");
        System.out.println("but this is not always possible since, for example, ");
        System.out.println("there are schemas for which no valid instance document ");
        System.out.println("can be produced.");
        System.out.println("Usage: xsd2inst [flags] schema.xsd -name element_name");
        System.out.println("Flags:");
        System.out.println("    -name    the name of the root element");
        System.out.println("    -dl      enable network downloads for imports and includes");
        System.out.println("    -nopvr   disable particle valid (restriction) rule");
        System.out.println("    -noupa   disable unique particle attribution rule");
        System.out.println("    -license prints license information");
        System.out.println("    -version prints version information");
    }

    public static void main(String[] args) {
        HashSet<String> flags = new HashSet<String>();
        HashSet<String> opts = new HashSet<String>();
        flags.add("h");
        flags.add("help");
        flags.add("usage");
        flags.add("license");
        flags.add("version");
        flags.add("dl");
        flags.add("noupa");
        flags.add("nopvr");
        flags.add("partial");
        opts.add("name");
        CommandLine cl2 = new CommandLine(args, flags, opts);
        if (cl2.getOpt("h") != null || cl2.getOpt("help") != null || cl2.getOpt("usage") != null) {
            SchemaInstanceGenerator.printUsage();
            return;
        }
        String[] badOpts = cl2.getBadOpts();
        if (badOpts.length > 0) {
            for (int i2 = 0; i2 < badOpts.length; ++i2) {
                System.out.println("Unrecognized option: " + badOpts[i2]);
            }
            SchemaInstanceGenerator.printUsage();
            return;
        }
        if (cl2.getOpt("license") != null) {
            CommandLine.printLicense();
            System.exit(0);
            return;
        }
        if (cl2.getOpt("version") != null) {
            CommandLine.printVersion();
            System.exit(0);
            return;
        }
        boolean dl2 = cl2.getOpt("dl") != null;
        boolean nopvr = cl2.getOpt("nopvr") != null;
        boolean noupa = cl2.getOpt("noupa") != null;
        File[] schemaFiles = cl2.filesEndingWith(".xsd");
        String rootName = cl2.getOpt("name");
        if (rootName == null) {
            System.out.println("Required option \"-name\" must be present");
            return;
        }
        ArrayList<XmlObject> sdocs = new ArrayList<XmlObject>();
        for (int i3 = 0; i3 < schemaFiles.length; ++i3) {
            try {
                sdocs.add(XmlObject.Factory.parse(schemaFiles[i3], new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
                continue;
            }
            catch (Exception e2) {
                System.err.println("Can not load schema file: " + schemaFiles[i3] + ": ");
                e2.printStackTrace();
            }
        }
        XmlObject[] schemas = sdocs.toArray(new XmlObject[sdocs.size()]);
        Xsd2InstOptions options = new Xsd2InstOptions();
        options.setNetworkDownloads(dl2);
        options.setNopvr(nopvr);
        options.setNoupa(noupa);
        String result = SchemaInstanceGenerator.xsd2inst(schemas, rootName, options);
        System.out.println(result);
    }

    public static String xsd2inst(String[] xsds, String rootName, Xsd2InstOptions options) throws XmlException, IOException {
        Reader[] instReaders = new Reader[xsds.length];
        for (int i2 = 0; i2 < xsds.length; ++i2) {
            instReaders[i2] = new StringReader(xsds[i2]);
        }
        String res = SchemaInstanceGenerator.xsd2inst(instReaders, rootName, options);
        return res;
    }

    public static String xsd2inst(Reader[] schemaReaders, String rootName, Xsd2InstOptions options) {
        ArrayList<XmlObject> sdocs = new ArrayList<XmlObject>();
        for (int i2 = 0; i2 < schemaReaders.length; ++i2) {
            try {
                sdocs.add(XmlObject.Factory.parse(schemaReaders[i2], new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
                continue;
            }
            catch (Exception e2) {
                System.err.println("Can not load schema reader: " + i2 + "  " + schemaReaders[i2] + ": ");
                e2.printStackTrace();
            }
        }
        XmlObject[] schemas = sdocs.toArray(new XmlObject[sdocs.size()]);
        return SchemaInstanceGenerator.xsd2inst(schemas, rootName, options);
    }

    public static String xsd2inst(XmlObject[] schemas, String rootName, Xsd2InstOptions options) {
        SchemaTypeSystem sts = null;
        if (schemas.length > 0) {
            ArrayList errors = new ArrayList();
            XmlOptions compileOptions = new XmlOptions();
            if (options.isNetworkDownloads()) {
                compileOptions.setCompileDownloadUrls();
            }
            if (options.isNopvr()) {
                compileOptions.setCompileNoPvrRule();
            }
            if (options.isNoupa()) {
                compileOptions.setCompileNoUpaRule();
            }
            try {
                sts = XmlBeans.compileXsd(schemas, XmlBeans.getBuiltinTypeSystem(), compileOptions);
            }
            catch (Exception e2) {
                if (errors.isEmpty() || !(e2 instanceof XmlException)) {
                    e2.printStackTrace();
                }
                System.out.println("Schema compilation errors: ");
                Iterator i2 = errors.iterator();
                while (i2.hasNext()) {
                    System.out.println(i2.next());
                }
            }
        }
        if (sts == null) {
            throw new RuntimeException("No Schemas to process.");
        }
        SchemaType[] globalElems = sts.documentTypes();
        SchemaType elem = null;
        for (int i3 = 0; i3 < globalElems.length; ++i3) {
            if (!rootName.equals(globalElems[i3].getDocumentElementName().getLocalPart())) continue;
            elem = globalElems[i3];
            break;
        }
        if (elem == null) {
            throw new RuntimeException("Could not find a global element with name \"" + rootName + "\"");
        }
        String result = SampleXmlUtil.createSampleForType(elem);
        return result;
    }

    public static class Xsd2InstOptions {
        private boolean _downloads = false;
        private boolean _nopvr = false;
        private boolean _noupa = false;

        public boolean isNetworkDownloads() {
            return this._downloads;
        }

        public void setNetworkDownloads(boolean downloads) {
            this._downloads = downloads;
        }

        public boolean isNopvr() {
            return this._nopvr;
        }

        public void setNopvr(boolean nopvr) {
            this._nopvr = nopvr;
        }

        public boolean isNoupa() {
            return this._noupa;
        }

        public void setNoupa(boolean noupa) {
            this._noupa = noupa;
        }
    }
}

