/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.util.XsTypeConverter;
import org.apache.xmlbeans.impl.values.JavaDecimalHolder;
import org.apache.xmlbeans.impl.values.JavaIntHolder;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public abstract class JavaIntHolderEx
extends JavaIntHolder {
    private SchemaType _schemaType;

    public JavaIntHolderEx(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    public SchemaType schemaType() {
        return this._schemaType;
    }

    protected void set_text(String s2) {
        int v2;
        try {
            v2 = XsTypeConverter.lexInt(s2);
        }
        catch (Exception e2) {
            throw new XmlValueOutOfRangeException();
        }
        if (this._validateOnSet()) {
            JavaIntHolderEx.validateValue(v2, this._schemaType, _voorVc);
            JavaIntHolderEx.validateLexical(s2, this._schemaType, _voorVc);
        }
        super.set_int(v2);
    }

    protected void set_int(int v2) {
        if (this._validateOnSet()) {
            JavaIntHolderEx.validateValue(v2, this._schemaType, _voorVc);
        }
        super.set_int(v2);
    }

    public static void validateLexical(String v2, SchemaType sType, ValidationContext context) {
        JavaDecimalHolder.validateLexical(v2, context);
        if (sType.hasPatternFacet() && !sType.matchPatternFacet(v2)) {
            context.invalid("cvc-datatype-valid.1.1", new Object[]{"int", v2, QNameHelper.readable(sType)});
        }
    }

    private static void validateValue(int v2, SchemaType sType, ValidationContext context) {
        int m2;
        int m3;
        int m4;
        XmlAnySimpleType mine;
        int m5;
        XmlAnySimpleType td = sType.getFacet(7);
        if (td != null) {
            String temp = Integer.toString(v2);
            int len = temp.length();
            if (len > 0 && temp.charAt(0) == '-') {
                --len;
            }
            if (len > (m5 = JavaIntHolderEx.getIntValue(td))) {
                context.invalid("cvc-totalDigits-valid", new Object[]{new Integer(len), temp, new Integer(JavaIntHolderEx.getIntValue(td)), QNameHelper.readable(sType)});
                return;
            }
        }
        if ((mine = sType.getFacet(3)) != null && v2 <= (m4 = JavaIntHolderEx.getIntValue(mine))) {
            context.invalid("cvc-minExclusive-valid", new Object[]{"int", new Integer(v2), new Integer(m4), QNameHelper.readable(sType)});
            return;
        }
        XmlAnySimpleType mini = sType.getFacet(4);
        if (mini != null && v2 < (m5 = JavaIntHolderEx.getIntValue(mini))) {
            context.invalid("cvc-minInclusive-valid", new Object[]{"int", new Integer(v2), new Integer(m5), QNameHelper.readable(sType)});
            return;
        }
        XmlAnySimpleType maxi = sType.getFacet(5);
        if (maxi != null && v2 > (m3 = JavaIntHolderEx.getIntValue(maxi))) {
            context.invalid("cvc-maxExclusive-valid", new Object[]{"int", new Integer(v2), new Integer(m3), QNameHelper.readable(sType)});
            return;
        }
        XmlAnySimpleType maxe = sType.getFacet(6);
        if (maxe != null && v2 >= (m2 = JavaIntHolderEx.getIntValue(maxe))) {
            context.invalid("cvc-maxExclusive-valid", new Object[]{"int", new Integer(v2), new Integer(m2), QNameHelper.readable(sType)});
            return;
        }
        XmlAnySimpleType[] vals = sType.getEnumerationValues();
        if (vals != null) {
            for (int i2 = 0; i2 < vals.length; ++i2) {
                if (v2 != JavaIntHolderEx.getIntValue(vals[i2])) continue;
                return;
            }
            context.invalid("cvc-enumeration-valid", new Object[]{"int", new Integer(v2), QNameHelper.readable(sType)});
        }
    }

    private static int getIntValue(XmlObject o2) {
        SchemaType s2 = o2.schemaType();
        switch (s2.getDecimalSize()) {
            case 1000001: {
                return ((XmlObjectBase)o2).getBigDecimalValue().intValue();
            }
            case 1000000: {
                return ((XmlObjectBase)o2).getBigIntegerValue().intValue();
            }
            case 64: {
                return (int)((XmlObjectBase)o2).getLongValue();
            }
        }
        return ((XmlObjectBase)o2).getIntValue();
    }

    protected void validate_simpleval(String lexical, ValidationContext ctx) {
        JavaIntHolderEx.validateLexical(lexical, this.schemaType(), ctx);
        JavaIntHolderEx.validateValue(this.getIntValue(), this.schemaType(), ctx);
    }
}

