/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.util;

import java.io.UnsupportedEncodingException;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static byte[] hexNumberTable;
    private static byte[] lookUpHexAlphabet;

    static boolean isHex(byte octect) {
        return hexNumberTable[octect] != -1;
    }

    public static String bytesToString(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        return new String(HexBin.encode(binaryData));
    }

    public static byte[] stringToBytes(String hexEncoded) {
        return HexBin.decode(hexEncoded.getBytes());
    }

    public static byte[] encode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        int lengthEncode = lengthData * 2;
        byte[] encodedData = new byte[lengthEncode];
        for (int i2 = 0; i2 < lengthData; ++i2) {
            encodedData[i2 * 2] = lookUpHexAlphabet[binaryData[i2] >> 4 & 0xF];
            encodedData[i2 * 2 + 1] = lookUpHexAlphabet[binaryData[i2] & 0xF];
        }
        return encodedData;
    }

    public static byte[] decode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        if (lengthData % 2 != 0) {
            return null;
        }
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        for (int i2 = 0; i2 < lengthDecode; ++i2) {
            if (!HexBin.isHex(binaryData[i2 * 2]) || !HexBin.isHex(binaryData[i2 * 2 + 1])) {
                return null;
            }
            decodedData[i2] = (byte)(hexNumberTable[binaryData[i2 * 2]] << 4 | hexNumberTable[binaryData[i2 * 2 + 1]]);
        }
        return decodedData;
    }

    public static String decode(String binaryData) {
        if (binaryData == null) {
            return null;
        }
        byte[] decoded = null;
        try {
            decoded = HexBin.decode(binaryData.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded == null ? null : new String(decoded);
    }

    public static String encode(String binaryData) {
        if (binaryData == null) {
            return null;
        }
        byte[] encoded = null;
        try {
            encoded = HexBin.encode(binaryData.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded == null ? null : new String(encoded);
    }

    static {
        int i2;
        hexNumberTable = new byte[255];
        lookUpHexAlphabet = new byte[16];
        for (i2 = 0; i2 < 255; ++i2) {
            HexBin.hexNumberTable[i2] = -1;
        }
        for (i2 = 57; i2 >= 48; --i2) {
            HexBin.hexNumberTable[i2] = (byte)(i2 - 48);
        }
        for (i2 = 70; i2 >= 65; --i2) {
            HexBin.hexNumberTable[i2] = (byte)(i2 - 65 + 10);
        }
        for (i2 = 102; i2 >= 97; --i2) {
            HexBin.hexNumberTable[i2] = (byte)(i2 - 97 + 10);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            HexBin.lookUpHexAlphabet[i2] = (byte)(48 + i2);
        }
        for (i2 = 10; i2 <= 15; ++i2) {
            HexBin.lookUpHexAlphabet[i2] = (byte)(65 + i2 - 10);
        }
    }
}

