/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CommandLine;

public class RunXQuery {
    public static void printUsage() {
        System.out.println("Run an XQuery against an XML instance");
        System.out.println("Usage:");
        System.out.println("xquery [-verbose] [-pretty] [-q <query> | -qf query.xq] [file.xml]*");
        System.out.println(" -q <query> to specify a query on the command-line");
        System.out.println(" -qf <query> to specify a file containing a query");
        System.out.println(" -pretty pretty-prints the results");
        System.out.println(" -license prints license information");
        System.out.println(" the query is run on each XML file specified");
        System.out.println("");
    }

    public static void main(String[] args) throws Exception {
        HashSet<String> flags = new HashSet<String>();
        flags.add("h");
        flags.add("help");
        flags.add("usage");
        flags.add("license");
        flags.add("version");
        flags.add("verbose");
        flags.add("pretty");
        CommandLine cl2 = new CommandLine(args, flags, Arrays.asList("q", "qf"));
        if (cl2.getOpt("h") != null || cl2.getOpt("help") != null || cl2.getOpt("usage") != null) {
            RunXQuery.printUsage();
            System.exit(0);
            return;
        }
        String[] badopts = cl2.getBadOpts();
        if (badopts.length > 0) {
            for (int i2 = 0; i2 < badopts.length; ++i2) {
                System.out.println("Unrecognized option: " + badopts[i2]);
            }
            RunXQuery.printUsage();
            System.exit(0);
            return;
        }
        if (cl2.getOpt("license") != null) {
            CommandLine.printLicense();
            System.exit(0);
            return;
        }
        if (cl2.getOpt("version") != null) {
            CommandLine.printVersion();
            System.exit(0);
            return;
        }
        args = cl2.args();
        if (args.length == 0) {
            RunXQuery.printUsage();
            System.exit(0);
            return;
        }
        boolean verbose = cl2.getOpt("verbose") != null;
        boolean pretty = cl2.getOpt("pretty") != null;
        String query = cl2.getOpt("q");
        String queryfile = cl2.getOpt("qf");
        if (query == null && queryfile == null) {
            System.err.println("No query specified");
            System.exit(0);
            return;
        }
        if (query != null && queryfile != null) {
            System.err.println("Specify -qf or -q, not both.");
            System.exit(0);
            return;
        }
        try {
            if (queryfile != null) {
                int ch2;
                File queryFile = new File(queryfile);
                FileInputStream is2 = new FileInputStream(queryFile);
                InputStreamReader r2 = new InputStreamReader(is2);
                StringBuffer sb = new StringBuffer();
                while ((ch2 = r2.read()) >= 0) {
                    sb.append((char)ch2);
                }
                r2.close();
                is2.close();
                query = sb.toString();
            }
        }
        catch (Throwable e2) {
            System.err.println("Cannot read query file: " + e2.getMessage());
            System.exit(1);
            return;
        }
        if (verbose) {
            System.out.println("Compile Query:");
            System.out.println(query);
            System.out.println();
        }
        try {
            query = XmlBeans.compileQuery(query);
        }
        catch (Exception e3) {
            System.err.println("Error compiling query: " + e3.getMessage());
            System.exit(1);
            return;
        }
        File[] files = cl2.getFiles();
        for (int i3 = 0; i3 < files.length; ++i3) {
            XmlObject x2;
            try {
                if (verbose) {
                    int ch3;
                    FileInputStream is3 = new FileInputStream(files[i3]);
                    while ((ch3 = ((InputStream)is3).read()) >= 0) {
                        System.out.write(ch3);
                    }
                    ((InputStream)is3).close();
                    System.out.println();
                }
                x2 = XmlObject.Factory.parse(files[i3]);
            }
            catch (Throwable e4) {
                System.err.println("Error parsing instance: " + e4.getMessage());
                System.exit(1);
                return;
            }
            if (verbose) {
                System.out.println("Executing Query...");
                System.err.println();
            }
            XmlObject[] result = null;
            try {
                result = x2.execQuery(query);
            }
            catch (Throwable e5) {
                System.err.println("Error executing query: " + e5.getMessage());
                System.exit(1);
                return;
            }
            if (verbose) {
                System.out.println("Query Result:");
            }
            XmlOptions opts = new XmlOptions();
            opts.setSaveOuter();
            if (pretty) {
                opts.setSavePrettyPrint();
            }
            for (int j2 = 0; j2 < result.length; ++j2) {
                result[j2].save(System.out, opts);
                System.out.println();
            }
        }
    }
}

