/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CommandLine;

public class InstanceValidator {
    public static void printUsage() {
        System.out.println("Validates the specified instance against the specified schema.");
        System.out.println("Contrast with the svalidate tool, which validates using a stream.");
        System.out.println("Usage: validate [-dl] [-nopvr] [-noupa] [-license] schema.xsd instance.xml");
        System.out.println("Options:");
        System.out.println("    -dl - permit network downloads for imports and includes (default is off)");
        System.out.println("    -noupa - do not enforce the unique particle attribution rule");
        System.out.println("    -nopvr - do not enforce the particle valid (restriction) rule");
        System.out.println("    -strict - performs strict(er) validation");
        System.out.println("    -partial - allow partial schema type system");
        System.out.println("    -license - prints license information");
    }

    public static void main(String[] args) {
        System.exit(InstanceValidator.extraMain(args));
    }

    public static int extraMain(String[] args) {
        HashSet<String> flags = new HashSet<String>();
        flags.add("h");
        flags.add("help");
        flags.add("usage");
        flags.add("license");
        flags.add("version");
        flags.add("dl");
        flags.add("noupa");
        flags.add("nopvr");
        flags.add("strict");
        flags.add("partial");
        CommandLine cl2 = new CommandLine(args, flags, Collections.EMPTY_SET);
        if (cl2.getOpt("h") != null || cl2.getOpt("help") != null || cl2.getOpt("usage") != null || args.length < 1) {
            InstanceValidator.printUsage();
            return 0;
        }
        String[] badopts = cl2.getBadOpts();
        if (badopts.length > 0) {
            for (int i2 = 0; i2 < badopts.length; ++i2) {
                System.out.println("Unrecognized option: " + badopts[i2]);
            }
            InstanceValidator.printUsage();
            return 0;
        }
        if (cl2.getOpt("license") != null) {
            CommandLine.printLicense();
            return 0;
        }
        if (cl2.getOpt("version") != null) {
            CommandLine.printVersion();
            return 0;
        }
        if (cl2.args().length == 0) {
            return 0;
        }
        boolean dl2 = cl2.getOpt("dl") != null;
        boolean nopvr = cl2.getOpt("nopvr") != null;
        boolean noupa = cl2.getOpt("noupa") != null;
        boolean strict = cl2.getOpt("strict") != null;
        boolean partial = cl2.getOpt("partial") != null;
        File[] schemaFiles = cl2.filesEndingWith(".xsd");
        File[] instanceFiles = cl2.filesEndingWith(".xml");
        File[] jarFiles = cl2.filesEndingWith(".jar");
        ArrayList<XmlObject> sdocs = new ArrayList<XmlObject>();
        for (int i3 = 0; i3 < schemaFiles.length; ++i3) {
            try {
                sdocs.add(XmlObject.Factory.parse(schemaFiles[i3], new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
                continue;
            }
            catch (Exception e2) {
                System.err.println(schemaFiles[i3] + " not loadable: " + e2);
            }
        }
        XmlObject[] schemas = sdocs.toArray(new XmlObject[0]);
        SchemaTypeLoader sLoader = null;
        ArrayList compErrors = new ArrayList();
        XmlOptions schemaOptions = new XmlOptions();
        schemaOptions.setErrorListener(compErrors);
        if (dl2) {
            schemaOptions.setCompileDownloadUrls();
        }
        if (nopvr) {
            schemaOptions.setCompileNoPvrRule();
        }
        if (noupa) {
            schemaOptions.setCompileNoUpaRule();
        }
        if (partial) {
            schemaOptions.put("COMPILE_PARTIAL_TYPESYSTEM");
        }
        if (jarFiles != null && jarFiles.length > 0) {
            sLoader = XmlBeans.typeLoaderForResource(XmlBeans.resourceLoaderForPath(jarFiles));
        }
        int returnCode = 0;
        try {
            if (schemas != null && schemas.length > 0) {
                sLoader = XmlBeans.compileXsd(schemas, sLoader, schemaOptions);
            }
        }
        catch (Exception e3) {
            if (compErrors.isEmpty() || !(e3 instanceof XmlException)) {
                e3.printStackTrace(System.err);
            }
            System.out.println("Schema invalid:" + (partial ? " couldn't recover from errors" : ""));
            Iterator i4 = compErrors.iterator();
            while (i4.hasNext()) {
                System.out.println(i4.next());
            }
            returnCode = 10;
            return returnCode;
        }
        if (partial && !compErrors.isEmpty()) {
            returnCode = 11;
            System.out.println("Schema invalid: partial schema type system recovered");
            Iterator i5 = compErrors.iterator();
            while (i5.hasNext()) {
                System.out.println(i5.next());
            }
        }
        if (sLoader == null) {
            sLoader = XmlBeans.getContextTypeLoader();
        }
        for (int i6 = 0; i6 < instanceFiles.length; ++i6) {
            XmlObject xobj;
            try {
                xobj = sLoader.parse(instanceFiles[i6], null, new XmlOptions().setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT"));
            }
            catch (Exception e4) {
                System.err.println(instanceFiles[i6] + " not loadable: " + e4);
                e4.printStackTrace(System.err);
                continue;
            }
            ArrayList errors = new ArrayList();
            if (xobj.schemaType() == XmlObject.type) {
                System.out.println(instanceFiles[i6] + " NOT valid.  ");
                System.out.println("  Document type not found.");
                continue;
            }
            if (xobj.validate(strict ? new XmlOptions().setErrorListener(errors).setValidateStrict() : new XmlOptions().setErrorListener(errors))) {
                System.out.println(instanceFiles[i6] + " valid.");
                continue;
            }
            returnCode = 1;
            System.out.println(instanceFiles[i6] + " NOT valid.");
            Iterator it2 = errors.iterator();
            while (it2.hasNext()) {
                System.out.println(it2.next());
            }
        }
        return returnCode;
    }
}

