/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.QNameSetBuilder;
import org.apache.xmlbeans.SchemaAttributeModel;
import org.apache.xmlbeans.SchemaBookmark;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaIdentityConstraint;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlNonNegativeInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlPositiveInteger;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.XMLChar;
import org.apache.xmlbeans.impl.common.XPath;
import org.apache.xmlbeans.impl.regex.RegularExpression;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.schema.SchemaAnnotationImpl;
import org.apache.xmlbeans.impl.schema.SchemaAttributeGroupImpl;
import org.apache.xmlbeans.impl.schema.SchemaContainer;
import org.apache.xmlbeans.impl.schema.SchemaGlobalAttributeImpl;
import org.apache.xmlbeans.impl.schema.SchemaGlobalElementImpl;
import org.apache.xmlbeans.impl.schema.SchemaIdentityConstraintImpl;
import org.apache.xmlbeans.impl.schema.SchemaLocalAttributeImpl;
import org.apache.xmlbeans.impl.schema.SchemaLocalElementImpl;
import org.apache.xmlbeans.impl.schema.SchemaModelGroupImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;
import org.apache.xmlbeans.impl.schema.StscImporter;
import org.apache.xmlbeans.impl.schema.StscResolver;
import org.apache.xmlbeans.impl.schema.StscState;
import org.apache.xmlbeans.impl.values.NamespaceContext;
import org.apache.xmlbeans.impl.values.XmlNonNegativeIntegerImpl;
import org.apache.xmlbeans.impl.values.XmlPositiveIntegerImpl;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import org.apache.xmlbeans.impl.xb.xsdschema.Annotated;
import org.apache.xmlbeans.impl.xb.xsdschema.AnnotationDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.Attribute;
import org.apache.xmlbeans.impl.xb.xsdschema.AttributeGroup;
import org.apache.xmlbeans.impl.xb.xsdschema.Element;
import org.apache.xmlbeans.impl.xb.xsdschema.FieldDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.FormChoice;
import org.apache.xmlbeans.impl.xb.xsdschema.Keybase;
import org.apache.xmlbeans.impl.xb.xsdschema.KeyrefDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.LocalElement;
import org.apache.xmlbeans.impl.xb.xsdschema.LocalSimpleType;
import org.apache.xmlbeans.impl.xb.xsdschema.NamedAttributeGroup;
import org.apache.xmlbeans.impl.xb.xsdschema.NamedGroup;
import org.apache.xmlbeans.impl.xb.xsdschema.RedefineDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.SimpleType;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelAttribute;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelComplexType;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelElement;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelSimpleType;
import org.apache.xmlbeans.soap.SOAPArrayType;

public class StscTranslator {
    private static final QName WSDL_ARRAYTYPE_NAME;
    private static final String FORM_QUALIFIED = "qualified";
    public static final RegularExpression XPATH_REGEXP;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void addAllDefinitions(StscImporter.SchemaToProcess[] schemasAndChameleons) {
        ArrayList<RedefinitionHolder> redefinitions = new ArrayList<RedefinitionHolder>();
        for (int i2 = 0; i2 < schemasAndChameleons.length; ++i2) {
            List redefines = schemasAndChameleons[i2].getRedefines();
            if (redefines == null) continue;
            List redefineObjects = schemasAndChameleons[i2].getRedefineObjects();
            Iterator it2 = redefines.iterator();
            Iterator ito = redefineObjects.iterator();
            while (it2.hasNext()) {
                if (!$assertionsDisabled && !ito.hasNext()) {
                    throw new AssertionError((Object)"The array of redefines and redefine objects have to have the same length");
                }
                redefinitions.add(new RedefinitionHolder((StscImporter.SchemaToProcess)it2.next(), (RedefineDocument.Redefine)ito.next()));
            }
        }
        RedefinitionMaster globalRedefinitions = new RedefinitionMaster(redefinitions.toArray(new RedefinitionHolder[redefinitions.size()]));
        StscState state = StscState.get();
        for (int j2 = 0; j2 < schemasAndChameleons.length; ++j2) {
            SchemaDocument.Schema schema = schemasAndChameleons[j2].getSchema();
            String givenTargetNamespace = schemasAndChameleons[j2].getChameleonNamespace();
            if (schema.sizeOfNotationArray() > 0) {
                state.warning("Schema <notation> is not yet supported for this release.", 51, (XmlObject)schema.getNotationArray(0));
            }
            String targetNamespace = schema.getTargetNamespace();
            boolean chameleon = false;
            if (givenTargetNamespace != null && targetNamespace == null) {
                targetNamespace = givenTargetNamespace;
                chameleon = true;
            }
            if (targetNamespace == null) {
                targetNamespace = "";
            }
            if (targetNamespace.length() > 0 || !StscTranslator.isEmptySchema(schema)) {
                state.registerContribution(targetNamespace, schema.documentProperties().getSourceName());
                state.addNewContainer(targetNamespace);
            }
            ArrayList<Annotated> redefChain = new ArrayList<Annotated>();
            TopLevelComplexType[] complexTypes = schema.getComplexTypeArray();
            for (int i3 = 0; i3 < complexTypes.length; ++i3) {
                TopLevelComplexType redef;
                TopLevelComplexType type = complexTypes[i3];
                RedefinitionHolder[] rhArray = globalRedefinitions.getComplexTypeRedefinitions(type.getName(), schemasAndChameleons[j2]);
                for (int k2 = 0; k2 < rhArray.length; ++k2) {
                    if (rhArray[k2] == null) continue;
                    redef = rhArray[k2].redefineComplexType(type.getName());
                    if (!$assertionsDisabled && redef == null) {
                        throw new AssertionError();
                    }
                    redefChain.add(type);
                    type = redef;
                }
                SchemaTypeImpl t2 = StscTranslator.translateGlobalComplexType(type, targetNamespace, chameleon, redefChain.size() > 0);
                state.addGlobalType(t2, null);
                for (int k3 = redefChain.size() - 1; k3 >= 0; --k3) {
                    redef = (TopLevelComplexType)redefChain.remove(k3);
                    SchemaTypeImpl r2 = StscTranslator.translateGlobalComplexType(redef, targetNamespace, chameleon, k3 > 0);
                    state.addGlobalType(r2, t2);
                    t2 = r2;
                }
            }
            TopLevelSimpleType[] simpleTypes = schema.getSimpleTypeArray();
            for (int i4 = 0; i4 < simpleTypes.length; ++i4) {
                TopLevelSimpleType redef;
                TopLevelSimpleType type = simpleTypes[i4];
                RedefinitionHolder[] rhArray = globalRedefinitions.getSimpleTypeRedefinitions(type.getName(), schemasAndChameleons[j2]);
                for (int k4 = 0; k4 < rhArray.length; ++k4) {
                    if (rhArray[k4] == null) continue;
                    redef = rhArray[k4].redefineSimpleType(type.getName());
                    if (!$assertionsDisabled && redef == null) {
                        throw new AssertionError();
                    }
                    redefChain.add(type);
                    type = redef;
                }
                SchemaTypeImpl t3 = StscTranslator.translateGlobalSimpleType(type, targetNamespace, chameleon, redefChain.size() > 0);
                state.addGlobalType(t3, null);
                for (int k5 = redefChain.size() - 1; k5 >= 0; --k5) {
                    redef = (TopLevelSimpleType)redefChain.remove(k5);
                    SchemaTypeImpl r3 = StscTranslator.translateGlobalSimpleType(redef, targetNamespace, chameleon, k5 > 0);
                    state.addGlobalType(r3, t3);
                    t3 = r3;
                }
            }
            TopLevelElement[] elements = schema.getElementArray();
            for (int i5 = 0; i5 < elements.length; ++i5) {
                TopLevelElement element = elements[i5];
                state.addDocumentType(StscTranslator.translateDocumentType(element, targetNamespace, chameleon), QNameHelper.forLNS(element.getName(), targetNamespace));
            }
            TopLevelAttribute[] attributes = schema.getAttributeArray();
            for (int i6 = 0; i6 < attributes.length; ++i6) {
                TopLevelAttribute attribute = attributes[i6];
                state.addAttributeType(StscTranslator.translateAttributeType(attribute, targetNamespace, chameleon), QNameHelper.forLNS(attribute.getName(), targetNamespace));
            }
            NamedGroup[] modelgroups = schema.getGroupArray();
            for (int i7 = 0; i7 < modelgroups.length; ++i7) {
                NamedGroup redef;
                NamedGroup group = modelgroups[i7];
                RedefinitionHolder[] rhArray = globalRedefinitions.getModelGroupRedefinitions(group.getName(), schemasAndChameleons[j2]);
                for (int k6 = 0; k6 < rhArray.length; ++k6) {
                    if (rhArray[k6] == null) continue;
                    redef = rhArray[k6].redefineModelGroup(group.getName());
                    if (!$assertionsDisabled && redef == null) {
                        throw new AssertionError();
                    }
                    redefChain.add(group);
                    group = redef;
                }
                SchemaModelGroupImpl g2 = StscTranslator.translateModelGroup(group, targetNamespace, chameleon, redefChain.size() > 0);
                state.addModelGroup(g2, null);
                for (int k7 = redefChain.size() - 1; k7 >= 0; --k7) {
                    redef = (NamedGroup)redefChain.remove(k7);
                    SchemaModelGroupImpl r4 = StscTranslator.translateModelGroup(redef, targetNamespace, chameleon, k7 > 0);
                    state.addModelGroup(r4, g2);
                    g2 = r4;
                }
            }
            NamedAttributeGroup[] attrgroups = schema.getAttributeGroupArray();
            for (int i8 = 0; i8 < attrgroups.length; ++i8) {
                NamedAttributeGroup redef;
                NamedAttributeGroup group = attrgroups[i8];
                RedefinitionHolder[] rhArray = globalRedefinitions.getAttributeGroupRedefinitions(group.getName(), schemasAndChameleons[j2]);
                for (int k8 = 0; k8 < rhArray.length; ++k8) {
                    if (rhArray[k8] == null) continue;
                    redef = rhArray[k8].redefineAttributeGroup(group.getName());
                    if (!$assertionsDisabled && redef == null) {
                        throw new AssertionError();
                    }
                    redefChain.add(group);
                    group = redef;
                }
                SchemaAttributeGroupImpl g3 = StscTranslator.translateAttributeGroup(group, targetNamespace, chameleon, redefChain.size() > 0);
                state.addAttributeGroup(g3, null);
                for (int k9 = redefChain.size() - 1; k9 >= 0; --k9) {
                    redef = (NamedAttributeGroup)redefChain.remove(k9);
                    SchemaAttributeGroupImpl r5 = StscTranslator.translateAttributeGroup(redef, targetNamespace, chameleon, k9 > 0);
                    state.addAttributeGroup(r5, g3);
                    g3 = r5;
                }
            }
            AnnotationDocument.Annotation[] annotations = schema.getAnnotationArray();
            for (int i9 = 0; i9 < annotations.length; ++i9) {
                state.addAnnotation(SchemaAnnotationImpl.getAnnotation(state.getContainer(targetNamespace), schema, annotations[i9]), targetNamespace);
            }
        }
        for (int i10 = 0; i10 < redefinitions.size(); ++i10) {
            ((RedefinitionHolder)redefinitions.get(i10)).complainAboutMissingDefinitions();
        }
    }

    private static String findFilename(XmlObject xobj) {
        return StscState.get().sourceNameForUri(xobj.documentProperties().getSourceName());
    }

    private static SchemaTypeImpl translateDocumentType(TopLevelElement xsdType, String targetNamespace, boolean chameleon) {
        SchemaTypeImpl sType = new SchemaTypeImpl(StscState.get().getContainer(targetNamespace));
        sType.setDocumentType(true);
        sType.setParseContext(xsdType, targetNamespace, chameleon, null, null, false);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        return sType;
    }

    private static SchemaTypeImpl translateAttributeType(TopLevelAttribute xsdType, String targetNamespace, boolean chameleon) {
        SchemaTypeImpl sType = new SchemaTypeImpl(StscState.get().getContainer(targetNamespace));
        sType.setAttributeType(true);
        sType.setParseContext(xsdType, targetNamespace, chameleon, null, null, false);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        return sType;
    }

    private static SchemaTypeImpl translateGlobalComplexType(TopLevelComplexType xsdType, String targetNamespace, boolean chameleon, boolean redefinition) {
        QName name;
        StscState state = StscState.get();
        String localname = xsdType.getName();
        if (localname == null) {
            state.error("missing-name", new Object[]{"global type"}, (XmlObject)xsdType);
            return null;
        }
        if (!XMLChar.isValidNCName(localname)) {
            state.error("invalid-value", new Object[]{localname, "name"}, (XmlObject)xsdType.xgetName());
        }
        if (StscTranslator.isReservedTypeName(name = QNameHelper.forLNS(localname, targetNamespace))) {
            state.warning("reserved-type-name", new Object[]{QNameHelper.pretty(name)}, (XmlObject)xsdType);
            return null;
        }
        SchemaTypeImpl sType = new SchemaTypeImpl(state.getContainer(targetNamespace));
        sType.setParseContext(xsdType, targetNamespace, chameleon, null, null, redefinition);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        sType.setName(QNameHelper.forLNS(localname, targetNamespace));
        sType.setAnnotation(SchemaAnnotationImpl.getAnnotation(state.getContainer(targetNamespace), xsdType));
        sType.setUserData(StscTranslator.getUserData(xsdType));
        return sType;
    }

    private static SchemaTypeImpl translateGlobalSimpleType(TopLevelSimpleType xsdType, String targetNamespace, boolean chameleon, boolean redefinition) {
        QName name;
        StscState state = StscState.get();
        String localname = xsdType.getName();
        if (localname == null) {
            state.error("missing-name", new Object[]{"global type"}, (XmlObject)xsdType);
            return null;
        }
        if (!XMLChar.isValidNCName(localname)) {
            state.error("invalid-value", new Object[]{localname, "name"}, (XmlObject)xsdType.xgetName());
        }
        if (StscTranslator.isReservedTypeName(name = QNameHelper.forLNS(localname, targetNamespace))) {
            state.warning("reserved-type-name", new Object[]{QNameHelper.pretty(name)}, (XmlObject)xsdType);
            return null;
        }
        SchemaTypeImpl sType = new SchemaTypeImpl(state.getContainer(targetNamespace));
        sType.setSimpleType(true);
        sType.setParseContext(xsdType, targetNamespace, chameleon, null, null, redefinition);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        sType.setName(name);
        sType.setAnnotation(SchemaAnnotationImpl.getAnnotation(state.getContainer(targetNamespace), xsdType));
        sType.setUserData(StscTranslator.getUserData(xsdType));
        return sType;
    }

    static SchemaTypeImpl translateAnonymousSimpleType(SimpleType typedef, String targetNamespace, boolean chameleon, String elemFormDefault, String attFormDefault, List anonymousTypes, SchemaType outerType) {
        StscState state = StscState.get();
        SchemaTypeImpl sType = new SchemaTypeImpl(state.getContainer(targetNamespace));
        sType.setSimpleType(true);
        sType.setParseContext(typedef, targetNamespace, chameleon, elemFormDefault, attFormDefault, false);
        sType.setOuterSchemaTypeRef(outerType.getRef());
        sType.setAnnotation(SchemaAnnotationImpl.getAnnotation(state.getContainer(targetNamespace), typedef));
        sType.setUserData(StscTranslator.getUserData(typedef));
        anonymousTypes.add(sType);
        return sType;
    }

    static FormChoice findElementFormDefault(XmlObject obj) {
        XmlCursor cur = obj.newCursor();
        while (cur.getObject().schemaType() != SchemaDocument.Schema.type) {
            if (cur.toParent()) continue;
            return null;
        }
        return ((SchemaDocument.Schema)cur.getObject()).xgetElementFormDefault();
    }

    public static boolean uriMatch(String s1, String s2) {
        if (s1 == null) {
            return s2 == null || s2.equals("");
        }
        if (s2 == null) {
            return s1.equals("");
        }
        return s1.equals(s2);
    }

    public static void copyGlobalElementToLocalElement(SchemaGlobalElement referenced, SchemaLocalElementImpl target) {
        target.setNameAndTypeRef(referenced.getName(), referenced.getType().getRef());
        target.setNillable(referenced.isNillable());
        target.setDefault(referenced.getDefaultText(), referenced.isFixed(), ((SchemaGlobalElementImpl)referenced).getParseObject());
        target.setIdentityConstraints(((SchemaLocalElementImpl)((Object)referenced)).getIdentityConstraintRefs());
        target.setBlock(referenced.blockExtension(), referenced.blockRestriction(), referenced.blockSubstitution());
        target.setAbstract(referenced.isAbstract());
        target.setTransitionRules(((SchemaParticle)((Object)referenced)).acceptedStartNames(), ((SchemaParticle)((Object)referenced)).isSkippable());
        target.setAnnotation(referenced.getAnnotation());
    }

    public static void copyGlobalAttributeToLocalAttribute(SchemaGlobalAttributeImpl referenced, SchemaLocalAttributeImpl target) {
        target.init(referenced.getName(), referenced.getTypeRef(), referenced.getUse(), referenced.getDefaultText(), referenced.getParseObject(), referenced._defaultValue, referenced.isFixed(), referenced.getWSDLArrayType(), referenced.getAnnotation(), null);
    }

    public static SchemaLocalElementImpl translateElement(Element xsdElt, String targetNamespace, boolean chameleon, String elemFormDefault, String attFormDefault, List anonymousTypes, SchemaType outerType) {
        SchemaGlobalElementImpl head;
        QName qname;
        SchemaLocalElementImpl impl;
        StscState state = StscState.get();
        SchemaTypeImpl sgHead = null;
        if (xsdElt.isSetSubstitutionGroup() && (sgHead = state.findDocumentType(xsdElt.getSubstitutionGroup(), ((SchemaTypeImpl)outerType).getChameleonNamespace(), targetNamespace)) != null) {
            StscResolver.resolveType(sgHead);
        }
        String name = xsdElt.getName();
        QName ref = xsdElt.getRef();
        if (ref != null && name != null) {
            state.error("src-element.2.1a", new Object[]{name}, (XmlObject)xsdElt.xgetRef());
            name = null;
        }
        if (ref == null && name == null) {
            state.error("src-element.2.1b", null, (XmlObject)xsdElt);
            return null;
        }
        if (name != null && !XMLChar.isValidNCName(name)) {
            state.error("invalid-value", new Object[]{name, "name"}, (XmlObject)xsdElt.xgetName());
        }
        if (ref != null) {
            if (xsdElt.getType() != null) {
                state.error("src-element.2.2", new Object[]{"type"}, (XmlObject)xsdElt.xgetType());
            }
            if (xsdElt.getSimpleType() != null) {
                state.error("src-element.2.2", new Object[]{"<simpleType>"}, (XmlObject)xsdElt.getSimpleType());
            }
            if (xsdElt.getComplexType() != null) {
                state.error("src-element.2.2", new Object[]{"<complexType>"}, (XmlObject)xsdElt.getComplexType());
            }
            if (xsdElt.getForm() != null) {
                state.error("src-element.2.2", new Object[]{"form"}, (XmlObject)xsdElt.xgetForm());
            }
            if (xsdElt.sizeOfKeyArray() > 0) {
                state.warning("src-element.2.2", new Object[]{"<key>"}, (XmlObject)xsdElt);
            }
            if (xsdElt.sizeOfKeyrefArray() > 0) {
                state.warning("src-element.2.2", new Object[]{"<keyref>"}, (XmlObject)xsdElt);
            }
            if (xsdElt.sizeOfUniqueArray() > 0) {
                state.warning("src-element.2.2", new Object[]{"<unique>"}, (XmlObject)xsdElt);
            }
            if (xsdElt.isSetDefault()) {
                state.warning("src-element.2.2", new Object[]{"default"}, (XmlObject)xsdElt.xgetDefault());
            }
            if (xsdElt.isSetFixed()) {
                state.warning("src-element.2.2", new Object[]{"fixed"}, (XmlObject)xsdElt.xgetFixed());
            }
            if (xsdElt.isSetBlock()) {
                state.warning("src-element.2.2", new Object[]{"block"}, (XmlObject)xsdElt.xgetBlock());
            }
            if (xsdElt.isSetNillable()) {
                state.warning("src-element.2.2", new Object[]{"nillable"}, (XmlObject)xsdElt.xgetNillable());
            }
            if (!$assertionsDisabled && !(xsdElt instanceof LocalElement)) {
                throw new AssertionError();
            }
            SchemaGlobalElementImpl referenced = state.findGlobalElement(ref, chameleon ? targetNamespace : null, targetNamespace);
            if (referenced == null) {
                state.notFoundError(ref, 1, xsdElt.xgetRef(), true);
                return null;
            }
            SchemaLocalElementImpl target = new SchemaLocalElementImpl();
            target.setParticleType(4);
            target.setUserData(StscTranslator.getUserData(xsdElt));
            StscTranslator.copyGlobalElementToLocalElement(referenced, target);
            return target;
        }
        SchemaType sType = null;
        if (xsdElt instanceof LocalElement) {
            impl = new SchemaLocalElementImpl();
            boolean qualified = false;
            FormChoice form = xsdElt.xgetForm();
            qualified = form != null ? form.getStringValue().equals(FORM_QUALIFIED) : (elemFormDefault != null ? elemFormDefault.equals(FORM_QUALIFIED) : (form = StscTranslator.findElementFormDefault(xsdElt)) != null && form.getStringValue().equals(FORM_QUALIFIED));
            qname = qualified ? QNameHelper.forLNS(name, targetNamespace) : QNameHelper.forLN(name);
        } else {
            SchemaGlobalElementImpl head2;
            SchemaGlobalElementImpl gelt = new SchemaGlobalElementImpl(state.getContainer(targetNamespace));
            impl = gelt;
            if (sgHead != null && (head2 = state.findGlobalElement(xsdElt.getSubstitutionGroup(), chameleon ? targetNamespace : null, targetNamespace)) != null) {
                gelt.setSubstitutionGroup(head2.getRef());
            }
            qname = QNameHelper.forLNS(name, targetNamespace);
            SchemaTypeImpl docType = (SchemaTypeImpl)outerType;
            QName[] sgMembers = docType.getSubstitutionGroupMembers();
            QNameSetBuilder transitionRules = new QNameSetBuilder();
            transitionRules.add(qname);
            for (int i2 = 0; i2 < sgMembers.length; ++i2) {
                gelt.addSubstitutionGroupMember(sgMembers[i2]);
                transitionRules.add(sgMembers[i2]);
            }
            impl.setTransitionRules(QNameSet.forSpecification(transitionRules), false);
            impl.setTransitionNotes(QNameSet.EMPTY, true);
            boolean finalExt = false;
            boolean finalRest = false;
            Object ds2 = xsdElt.getFinal();
            if (ds2 != null) {
                if (ds2 instanceof String && ds2.equals("#all")) {
                    finalRest = true;
                    finalExt = true;
                } else if (ds2 instanceof List) {
                    if (((List)ds2).contains("extension")) {
                        finalExt = true;
                    }
                    if (((List)ds2).contains("restriction")) {
                        finalRest = true;
                    }
                }
            }
            gelt.setFinal(finalExt, finalRest);
            gelt.setAbstract(xsdElt.getAbstract());
            gelt.setFilename(StscTranslator.findFilename(xsdElt));
            gelt.setParseContext(xsdElt, targetNamespace, chameleon);
        }
        SchemaAnnotationImpl ann = SchemaAnnotationImpl.getAnnotation(state.getContainer(targetNamespace), xsdElt);
        impl.setAnnotation(ann);
        impl.setUserData(StscTranslator.getUserData(xsdElt));
        if (xsdElt.getType() != null && (sType = state.findGlobalType(xsdElt.getType(), chameleon ? targetNamespace : null, targetNamespace)) == null) {
            state.notFoundError(xsdElt.getType(), 0, xsdElt.xgetType(), true);
        }
        boolean simpleTypedef = false;
        Annotated typedef = xsdElt.getComplexType();
        if (typedef == null) {
            typedef = xsdElt.getSimpleType();
            simpleTypedef = true;
        }
        if (sType != null && typedef != null) {
            state.error("src-element.3", null, (XmlObject)typedef);
            typedef = null;
        }
        if (typedef != null) {
            Object[] grps = state.getCurrentProcessing();
            QName[] context = new QName[grps.length];
            for (int i3 = 0; i3 < context.length; ++i3) {
                if (!(grps[i3] instanceof SchemaModelGroupImpl)) continue;
                context[i3] = ((SchemaModelGroupImpl)grps[i3]).getName();
            }
            SchemaType repeat = StscTranslator.checkRecursiveGroupReference(context, qname, (SchemaTypeImpl)outerType);
            if (repeat != null) {
                sType = repeat;
            } else {
                SchemaTypeImpl sTypeImpl = new SchemaTypeImpl(state.getContainer(targetNamespace));
                sType = sTypeImpl;
                sTypeImpl.setContainerField(impl);
                sTypeImpl.setOuterSchemaTypeRef(outerType == null ? null : outerType.getRef());
                sTypeImpl.setGroupReferenceContext(context);
                anonymousTypes.add(sType);
                sTypeImpl.setSimpleType(simpleTypedef);
                sTypeImpl.setParseContext(typedef, targetNamespace, chameleon, elemFormDefault, attFormDefault, false);
                sTypeImpl.setAnnotation(SchemaAnnotationImpl.getAnnotation(state.getContainer(targetNamespace), typedef));
                sTypeImpl.setUserData(StscTranslator.getUserData(typedef));
            }
        }
        if (sType == null && sgHead != null && (head = state.findGlobalElement(xsdElt.getSubstitutionGroup(), chameleon ? targetNamespace : null, targetNamespace)) != null) {
            sType = head.getType();
        }
        if (sType == null) {
            sType = BuiltinSchemaTypeSystem.ST_ANY_TYPE;
        }
        SOAPArrayType wat = null;
        XmlCursor c2 = xsdElt.newCursor();
        String arrayType = c2.getAttributeText(WSDL_ARRAYTYPE_NAME);
        c2.dispose();
        if (arrayType != null) {
            try {
                wat = new SOAPArrayType(arrayType, new NamespaceContext(xsdElt));
            }
            catch (XmlValueOutOfRangeException e2) {
                state.error("soaparray", new Object[]{arrayType}, (XmlObject)xsdElt);
            }
        }
        impl.setWsdlArrayType(wat);
        boolean isFixed = xsdElt.isSetFixed();
        if (xsdElt.isSetDefault() && isFixed) {
            state.error("src-element.1", null, (XmlObject)xsdElt.xgetFixed());
            isFixed = false;
        }
        impl.setParticleType(4);
        impl.setNameAndTypeRef(qname, sType.getRef());
        impl.setNillable(xsdElt.getNillable());
        impl.setDefault(isFixed ? xsdElt.getFixed() : xsdElt.getDefault(), isFixed, xsdElt);
        Object block = xsdElt.getBlock();
        boolean blockExt = false;
        boolean blockRest = false;
        boolean blockSubst = false;
        if (block != null) {
            if (block instanceof String && block.equals("#all")) {
                blockSubst = true;
                blockRest = true;
                blockExt = true;
            } else if (block instanceof List) {
                if (((List)block).contains("extension")) {
                    blockExt = true;
                }
                if (((List)block).contains("restriction")) {
                    blockRest = true;
                }
                if (((List)block).contains("substitution")) {
                    blockSubst = true;
                }
            }
        }
        impl.setBlock(blockExt, blockRest, blockSubst);
        boolean constraintFailed = false;
        int length = xsdElt.sizeOfKeyArray() + xsdElt.sizeOfKeyrefArray() + xsdElt.sizeOfUniqueArray();
        SchemaIdentityConstraintImpl[] constraints = new SchemaIdentityConstraintImpl[length];
        int cur = 0;
        Keybase[] keys = xsdElt.getKeyArray();
        int i4 = 0;
        while (i4 < keys.length) {
            constraints[cur] = StscTranslator.translateIdentityConstraint(keys[i4], targetNamespace, chameleon);
            if (constraints[cur] != null) {
                constraints[cur].setConstraintCategory(1);
            } else {
                constraintFailed = true;
            }
            ++i4;
            ++cur;
        }
        Keybase[] uc = xsdElt.getUniqueArray();
        int i5 = 0;
        while (i5 < uc.length) {
            constraints[cur] = StscTranslator.translateIdentityConstraint(uc[i5], targetNamespace, chameleon);
            if (constraints[cur] != null) {
                constraints[cur].setConstraintCategory(3);
            } else {
                constraintFailed = true;
            }
            ++i5;
            ++cur;
        }
        KeyrefDocument.Keyref[] krs = xsdElt.getKeyrefArray();
        int i6 = 0;
        while (i6 < krs.length) {
            constraints[cur] = StscTranslator.translateIdentityConstraint(krs[i6], targetNamespace, chameleon);
            if (constraints[cur] != null) {
                constraints[cur].setConstraintCategory(2);
            } else {
                constraintFailed = true;
            }
            ++i6;
            ++cur;
        }
        if (!constraintFailed) {
            SchemaIdentityConstraint.Ref[] refs = new SchemaIdentityConstraint.Ref[length];
            for (int i7 = 0; i7 < refs.length; ++i7) {
                refs[i7] = constraints[i7].getRef();
            }
            impl.setIdentityConstraints(refs);
        }
        return impl;
    }

    private static SchemaType checkRecursiveGroupReference(QName[] context, QName containingElement, SchemaTypeImpl outerType) {
        if (context.length < 1) {
            return null;
        }
        for (SchemaTypeImpl type = outerType; type != null; type = (SchemaTypeImpl)type.getOuterType()) {
            QName[] outerContext;
            if (type.getName() != null || type.isDocumentType()) {
                return null;
            }
            if (!containingElement.equals(type.getContainerField().getName()) || (outerContext = type.getGroupReferenceContext()) == null || outerContext.length != context.length) continue;
            boolean equal = true;
            for (int i2 = 0; i2 < context.length; ++i2) {
                if (context[i2] == null && outerContext[i2] == null || context[i2] != null && context[i2].equals(outerContext[i2])) continue;
                equal = false;
                break;
            }
            if (!equal) continue;
            return type;
        }
        return null;
    }

    private static String removeWhitespace(String xpath) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < xpath.length(); ++i2) {
            char ch2 = xpath.charAt(i2);
            if (XMLChar.isSpace(ch2)) continue;
            sb.append(ch2);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkXPathSyntax(String xpath) {
        if (xpath == null) {
            return false;
        }
        xpath = StscTranslator.removeWhitespace(xpath);
        RegularExpression regularExpression = XPATH_REGEXP;
        synchronized (regularExpression) {
            return XPATH_REGEXP.matches(xpath);
        }
    }

    private static SchemaIdentityConstraintImpl translateIdentityConstraint(Keybase parseIC, String targetNamespace, boolean chameleon) {
        String selector;
        StscState state = StscState.get();
        String string = selector = parseIC.getSelector() == null ? null : parseIC.getSelector().getXpath();
        if (!StscTranslator.checkXPathSyntax(selector)) {
            state.error("c-selector-xpath", new Object[]{selector}, (XmlObject)parseIC.getSelector().xgetXpath());
            return null;
        }
        FieldDocument.Field[] fieldElts = parseIC.getFieldArray();
        for (int j2 = 0; j2 < fieldElts.length; ++j2) {
            if (StscTranslator.checkXPathSyntax(fieldElts[j2].getXpath())) continue;
            state.error("c-fields-xpaths", new Object[]{fieldElts[j2].getXpath()}, (XmlObject)fieldElts[j2].xgetXpath());
            return null;
        }
        SchemaIdentityConstraintImpl ic2 = new SchemaIdentityConstraintImpl(state.getContainer(targetNamespace));
        ic2.setName(QNameHelper.forLNS(parseIC.getName(), targetNamespace));
        ic2.setSelector(parseIC.getSelector().getXpath());
        ic2.setParseContext(parseIC, targetNamespace, chameleon);
        SchemaAnnotationImpl ann = SchemaAnnotationImpl.getAnnotation(state.getContainer(targetNamespace), parseIC);
        ic2.setAnnotation(ann);
        ic2.setUserData(StscTranslator.getUserData(parseIC));
        XmlCursor c2 = parseIC.newCursor();
        HashMap nsMap = new HashMap();
        c2.getAllNamespaces(nsMap);
        nsMap.remove("");
        ic2.setNSMap(nsMap);
        c2.dispose();
        String[] fields = new String[fieldElts.length];
        for (int j3 = 0; j3 < fields.length; ++j3) {
            fields[j3] = fieldElts[j3].getXpath();
        }
        ic2.setFields(fields);
        try {
            ic2.buildPaths();
        }
        catch (XPath.XPathCompileException e2) {
            state.error("invalid-xpath", new Object[]{e2.getMessage()}, (XmlObject)parseIC);
            return null;
        }
        state.addIdConstraint(ic2);
        ic2.setFilename(StscTranslator.findFilename(parseIC));
        return state.findIdConstraint(ic2.getName(), targetNamespace, null);
    }

    public static SchemaModelGroupImpl translateModelGroup(NamedGroup namedGroup, String targetNamespace, boolean chameleon, boolean redefinition) {
        String name = namedGroup.getName();
        if (name == null) {
            StscState.get().error("missing-name", new Object[]{"model group"}, (XmlObject)namedGroup);
            return null;
        }
        SchemaContainer c2 = StscState.get().getContainer(targetNamespace);
        SchemaModelGroupImpl result = new SchemaModelGroupImpl(c2);
        SchemaAnnotationImpl ann = SchemaAnnotationImpl.getAnnotation(c2, namedGroup);
        FormChoice elemFormDefault = StscTranslator.findElementFormDefault(namedGroup);
        FormChoice attFormDefault = StscTranslator.findAttributeFormDefault(namedGroup);
        result.init(QNameHelper.forLNS(name, targetNamespace), targetNamespace, chameleon, elemFormDefault == null ? null : elemFormDefault.getStringValue(), attFormDefault == null ? null : attFormDefault.getStringValue(), redefinition, namedGroup, ann, StscTranslator.getUserData(namedGroup));
        result.setFilename(StscTranslator.findFilename(namedGroup));
        return result;
    }

    public static SchemaAttributeGroupImpl translateAttributeGroup(AttributeGroup attrGroup, String targetNamespace, boolean chameleon, boolean redefinition) {
        String name = attrGroup.getName();
        if (name == null) {
            StscState.get().error("missing-name", new Object[]{"attribute group"}, (XmlObject)attrGroup);
            return null;
        }
        SchemaContainer c2 = StscState.get().getContainer(targetNamespace);
        SchemaAttributeGroupImpl result = new SchemaAttributeGroupImpl(c2);
        SchemaAnnotationImpl ann = SchemaAnnotationImpl.getAnnotation(c2, attrGroup);
        FormChoice formDefault = StscTranslator.findAttributeFormDefault(attrGroup);
        result.init(QNameHelper.forLNS(name, targetNamespace), targetNamespace, chameleon, formDefault == null ? null : formDefault.getStringValue(), redefinition, attrGroup, ann, StscTranslator.getUserData(attrGroup));
        result.setFilename(StscTranslator.findFilename(attrGroup));
        return result;
    }

    static FormChoice findAttributeFormDefault(XmlObject obj) {
        XmlCursor cur = obj.newCursor();
        while (cur.getObject().schemaType() != SchemaDocument.Schema.type) {
            if (cur.toParent()) continue;
            return null;
        }
        return ((SchemaDocument.Schema)cur.getObject()).xgetAttributeFormDefault();
    }

    static SchemaLocalAttributeImpl translateAttribute(Attribute xsdAttr, String targetNamespace, String formDefault, boolean chameleon, List anonymousTypes, SchemaType outerType, SchemaAttributeModel baseModel, boolean local) {
        QName qname;
        SchemaLocalAttributeImpl sAttr;
        StscState state = StscState.get();
        String name = xsdAttr.getName();
        QName ref = xsdAttr.getRef();
        if (ref != null && name != null) {
            if (name.equals(ref.getLocalPart()) && StscTranslator.uriMatch(targetNamespace, ref.getNamespaceURI())) {
                state.warning("src-attribute.3.1a", new Object[]{name}, (XmlObject)xsdAttr.xgetRef());
            } else {
                state.error("src-attribute.3.1a", new Object[]{name}, (XmlObject)xsdAttr.xgetRef());
            }
            name = null;
        }
        if (ref == null && name == null) {
            state.error("src-attribute.3.1b", null, (XmlObject)xsdAttr);
            return null;
        }
        if (name != null && !XMLChar.isValidNCName(name)) {
            state.error("invalid-value", new Object[]{name, "name"}, (XmlObject)xsdAttr.xgetName());
        }
        boolean isFixed = false;
        String deftext = null;
        String fmrfixedtext = null;
        SchemaType sType = null;
        int use = 2;
        if (local) {
            sAttr = new SchemaLocalAttributeImpl();
        } else {
            sAttr = new SchemaGlobalAttributeImpl(state.get().getContainer(targetNamespace));
            ((SchemaGlobalAttributeImpl)sAttr).setParseContext(xsdAttr, targetNamespace, chameleon);
        }
        if (ref != null) {
            SchemaGlobalAttributeImpl referenced;
            if (xsdAttr.getType() != null) {
                state.error("src-attribute.3.2", new Object[]{"type"}, (XmlObject)xsdAttr.xgetType());
            }
            if (xsdAttr.getSimpleType() != null) {
                state.error("src-attribute.3.2", new Object[]{"<simpleType>"}, (XmlObject)xsdAttr.getSimpleType());
            }
            if (xsdAttr.getForm() != null) {
                state.error("src-attribute.3.2", new Object[]{"form"}, (XmlObject)xsdAttr.xgetForm());
            }
            if ((referenced = state.findGlobalAttribute(ref, chameleon ? targetNamespace : null, targetNamespace)) == null) {
                state.notFoundError(ref, 3, xsdAttr.xgetRef(), true);
                return null;
            }
            qname = ref;
            use = referenced.getUse();
            sType = referenced.getType();
            deftext = referenced.getDefaultText();
            if (deftext != null && (isFixed = referenced.isFixed())) {
                fmrfixedtext = deftext;
            }
        } else {
            if (local) {
                boolean qualified = false;
                FormChoice form = xsdAttr.xgetForm();
                qualified = form != null ? form.getStringValue().equals(FORM_QUALIFIED) : (formDefault != null ? formDefault.equals(FORM_QUALIFIED) : (form = StscTranslator.findAttributeFormDefault(xsdAttr)) != null && form.getStringValue().equals(FORM_QUALIFIED));
                qname = qualified ? QNameHelper.forLNS(name, targetNamespace) : QNameHelper.forLN(name);
            } else {
                qname = QNameHelper.forLNS(name, targetNamespace);
            }
            if (xsdAttr.getType() != null && (sType = state.findGlobalType(xsdAttr.getType(), chameleon ? targetNamespace : null, targetNamespace)) == null) {
                state.notFoundError(xsdAttr.getType(), 0, xsdAttr.xgetType(), true);
            }
            if (qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                state.error("no-xsi", new Object[]{"http://www.w3.org/2001/XMLSchema-instance"}, (XmlObject)xsdAttr.xgetName());
            }
            if (qname.getNamespaceURI().length() == 0 && qname.getLocalPart().equals("xmlns")) {
                state.error("no-xmlns", null, (XmlObject)xsdAttr.xgetName());
            }
            LocalSimpleType typedef = xsdAttr.getSimpleType();
            if (sType != null && typedef != null) {
                state.error("src-attribute.4", null, (XmlObject)typedef);
                typedef = null;
            }
            if (typedef != null) {
                SchemaTypeImpl sTypeImpl = new SchemaTypeImpl(state.getContainer(targetNamespace));
                sType = sTypeImpl;
                sTypeImpl.setContainerField(sAttr);
                sTypeImpl.setOuterSchemaTypeRef(outerType == null ? null : outerType.getRef());
                anonymousTypes.add(sType);
                sTypeImpl.setSimpleType(true);
                sTypeImpl.setParseContext(typedef, targetNamespace, chameleon, null, null, false);
                sTypeImpl.setAnnotation(SchemaAnnotationImpl.getAnnotation(state.getContainer(targetNamespace), typedef));
                sTypeImpl.setUserData(StscTranslator.getUserData(typedef));
            }
            if (sType == null && baseModel != null && baseModel.getAttribute(qname) != null) {
                sType = baseModel.getAttribute(qname).getType();
            }
        }
        if (sType == null) {
            sType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (!sType.isSimpleType()) {
            state.error("Attributes must have a simple type (not complex).", 46, (XmlObject)xsdAttr);
            sType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (xsdAttr.isSetUse() && (use = StscTranslator.translateUseCode(xsdAttr.xgetUse())) != 2 && !isFixed) {
            deftext = null;
        }
        if (xsdAttr.isSetDefault() || xsdAttr.isSetFixed()) {
            if (isFixed && !xsdAttr.isSetFixed()) {
                state.error("A use of a fixed attribute definition must also be fixed", 9, (XmlObject)xsdAttr.xgetFixed());
            }
            isFixed = xsdAttr.isSetFixed();
            if (xsdAttr.isSetDefault() && isFixed) {
                state.error("src-attribute.1", null, (XmlObject)xsdAttr.xgetFixed());
                isFixed = false;
            }
            String string = deftext = isFixed ? xsdAttr.getFixed() : xsdAttr.getDefault();
            if (fmrfixedtext != null && !fmrfixedtext.equals(deftext)) {
                state.error("au-value_constraint", null, (XmlObject)xsdAttr.xgetFixed());
                deftext = fmrfixedtext;
            }
        }
        if (!local) {
            ((SchemaGlobalAttributeImpl)sAttr).setFilename(StscTranslator.findFilename(xsdAttr));
        }
        SOAPArrayType wat = null;
        XmlCursor c2 = xsdAttr.newCursor();
        String arrayType = c2.getAttributeText(WSDL_ARRAYTYPE_NAME);
        c2.dispose();
        if (arrayType != null) {
            try {
                wat = new SOAPArrayType(arrayType, new NamespaceContext(xsdAttr));
            }
            catch (XmlValueOutOfRangeException e2) {
                state.error("soaparray", new Object[]{arrayType}, (XmlObject)xsdAttr);
            }
        }
        SchemaAnnotationImpl ann = SchemaAnnotationImpl.getAnnotation(state.getContainer(targetNamespace), xsdAttr);
        sAttr.init(qname, sType.getRef(), use, deftext, xsdAttr, null, isFixed, wat, ann, StscTranslator.getUserData(xsdAttr));
        return sAttr;
    }

    static int translateUseCode(Attribute.Use attruse) {
        if (attruse == null) {
            return 2;
        }
        String val = attruse.getStringValue();
        if (val.equals("optional")) {
            return 2;
        }
        if (val.equals("required")) {
            return 3;
        }
        if (val.equals("prohibited")) {
            return 1;
        }
        return 2;
    }

    static BigInteger buildBigInt(XmlAnySimpleType value) {
        BigInteger bigInt;
        if (value == null) {
            return null;
        }
        String text = value.getStringValue();
        try {
            bigInt = new BigInteger(text);
        }
        catch (NumberFormatException e2) {
            StscState.get().error("invalid-value-detail", new Object[]{text, "nonNegativeInteger", e2.getMessage()}, (XmlObject)value);
            return null;
        }
        if (bigInt.signum() < 0) {
            StscState.get().error("invalid-value", new Object[]{text, "nonNegativeInteger"}, (XmlObject)value);
            return null;
        }
        return bigInt;
    }

    static XmlNonNegativeInteger buildNnInteger(XmlAnySimpleType value) {
        BigInteger bigInt = StscTranslator.buildBigInt(value);
        try {
            XmlNonNegativeIntegerImpl i2 = new XmlNonNegativeIntegerImpl();
            i2.set(bigInt);
            i2.setImmutable();
            return i2;
        }
        catch (XmlValueOutOfRangeException e2) {
            StscState.get().error("Internal error processing number", 21, (XmlObject)value);
            return null;
        }
    }

    static XmlPositiveInteger buildPosInteger(XmlAnySimpleType value) {
        BigInteger bigInt = StscTranslator.buildBigInt(value);
        try {
            XmlPositiveIntegerImpl i2 = new XmlPositiveIntegerImpl();
            i2.set(bigInt);
            i2.setImmutable();
            return i2;
        }
        catch (XmlValueOutOfRangeException e2) {
            StscState.get().error("Internal error processing number", 21, (XmlObject)value);
            return null;
        }
    }

    private static Object getUserData(XmlObject pos) {
        XmlCursor.XmlBookmark b2 = pos.newCursor().getBookmark(SchemaBookmark.class);
        if (b2 != null && b2 instanceof SchemaBookmark) {
            return ((SchemaBookmark)b2).getValue();
        }
        return null;
    }

    private static boolean isEmptySchema(SchemaDocument.Schema schema) {
        XmlCursor cursor = schema.newCursor();
        boolean result = !cursor.toFirstChild();
        cursor.dispose();
        return result;
    }

    private static boolean isReservedTypeName(QName name) {
        return BuiltinSchemaTypeSystem.get().findType(name) != null;
    }

    static {
        $assertionsDisabled = !StscTranslator.class.desiredAssertionStatus();
        WSDL_ARRAYTYPE_NAME = QNameHelper.forLNS("arrayType", "http://schemas.xmlsoap.org/wsdl/");
        XPATH_REGEXP = new RegularExpression("(\\.//)?((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)/)*((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))(\\|(\\.//)?((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)/)*((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*)))))*", "X");
    }

    private static class RedefinitionMaster {
        private Map stRedefinitions = Collections.EMPTY_MAP;
        private Map ctRedefinitions = Collections.EMPTY_MAP;
        private Map agRedefinitions = Collections.EMPTY_MAP;
        private Map mgRedefinitions = Collections.EMPTY_MAP;
        private static final RedefinitionHolder[] EMPTY_REDEFINTION_HOLDER_ARRAY;
        private static final short SIMPLE_TYPE = 1;
        private static final short COMPLEX_TYPE = 2;
        private static final short MODEL_GROUP = 3;
        private static final short ATTRIBUTE_GROUP = 4;
        static final /* synthetic */ boolean $assertionsDisabled;

        RedefinitionMaster(RedefinitionHolder[] redefHolders) {
            if (redefHolders.length > 0) {
                this.stRedefinitions = new HashMap();
                this.ctRedefinitions = new HashMap();
                this.agRedefinitions = new HashMap();
                this.mgRedefinitions = new HashMap();
                for (int i2 = 0; i2 < redefHolders.length; ++i2) {
                    List<RedefinitionHolder> redefinedIn;
                    Object key;
                    RedefinitionHolder redefHolder = redefHolders[i2];
                    Iterator it2 = redefHolder.stRedefinitions.keySet().iterator();
                    while (it2.hasNext()) {
                        key = it2.next();
                        redefinedIn = (ArrayList<RedefinitionHolder>)this.stRedefinitions.get(key);
                        if (redefinedIn == null) {
                            redefinedIn = new ArrayList<RedefinitionHolder>();
                            this.stRedefinitions.put(key, redefinedIn);
                        }
                        redefinedIn.add(redefHolders[i2]);
                    }
                    it2 = redefHolder.ctRedefinitions.keySet().iterator();
                    while (it2.hasNext()) {
                        key = it2.next();
                        redefinedIn = (List)this.ctRedefinitions.get(key);
                        if (redefinedIn == null) {
                            redefinedIn = new ArrayList();
                            this.ctRedefinitions.put(key, redefinedIn);
                        }
                        redefinedIn.add(redefHolders[i2]);
                    }
                    it2 = redefHolder.agRedefinitions.keySet().iterator();
                    while (it2.hasNext()) {
                        key = it2.next();
                        redefinedIn = (List)this.agRedefinitions.get(key);
                        if (redefinedIn == null) {
                            redefinedIn = new ArrayList();
                            this.agRedefinitions.put(key, redefinedIn);
                        }
                        redefinedIn.add(redefHolders[i2]);
                    }
                    it2 = redefHolder.mgRedefinitions.keySet().iterator();
                    while (it2.hasNext()) {
                        key = it2.next();
                        redefinedIn = (List)this.mgRedefinitions.get(key);
                        if (redefinedIn == null) {
                            redefinedIn = new ArrayList();
                            this.mgRedefinitions.put(key, redefinedIn);
                        }
                        redefinedIn.add(redefHolders[i2]);
                    }
                }
            }
        }

        RedefinitionHolder[] getSimpleTypeRedefinitions(String name, StscImporter.SchemaToProcess schema) {
            List redefines = (List)this.stRedefinitions.get(name);
            if (redefines == null) {
                return EMPTY_REDEFINTION_HOLDER_ARRAY;
            }
            return this.doTopologicalSort(redefines, schema, name, (short)1);
        }

        RedefinitionHolder[] getComplexTypeRedefinitions(String name, StscImporter.SchemaToProcess schema) {
            List redefines = (List)this.ctRedefinitions.get(name);
            if (redefines == null) {
                return EMPTY_REDEFINTION_HOLDER_ARRAY;
            }
            return this.doTopologicalSort(redefines, schema, name, (short)2);
        }

        RedefinitionHolder[] getAttributeGroupRedefinitions(String name, StscImporter.SchemaToProcess schema) {
            List redefines = (List)this.agRedefinitions.get(name);
            if (redefines == null) {
                return EMPTY_REDEFINTION_HOLDER_ARRAY;
            }
            return this.doTopologicalSort(redefines, schema, name, (short)4);
        }

        RedefinitionHolder[] getModelGroupRedefinitions(String name, StscImporter.SchemaToProcess schema) {
            List redefines = (List)this.mgRedefinitions.get(name);
            if (redefines == null) {
                return EMPTY_REDEFINTION_HOLDER_ARRAY;
            }
            return this.doTopologicalSort(redefines, schema, name, (short)3);
        }

        private RedefinitionHolder[] doTopologicalSort(List genericRedefines, StscImporter.SchemaToProcess schema, String name, short componentType) {
            RedefinitionHolder[] specificRedefines = new RedefinitionHolder[genericRedefines.size()];
            int n2 = 0;
            for (int i2 = 0; i2 < genericRedefines.size(); ++i2) {
                RedefinitionHolder h2 = (RedefinitionHolder)genericRedefines.get(i2);
                if (h2.schemaRedefined != schema && !h2.schemaRedefined.indirectIncludes(schema)) continue;
                specificRedefines[n2++] = h2;
            }
            RedefinitionHolder[] sortedRedefines = new RedefinitionHolder[n2];
            int[] numberOfIncludes = new int[n2];
            for (int i3 = 0; i3 < n2 - 1; ++i3) {
                RedefinitionHolder current = specificRedefines[i3];
                for (int j2 = i3 + 1; j2 < n2; ++j2) {
                    if (current.schemaRedefined.indirectIncludes(specificRedefines[j2].schemaRedefined)) {
                        int n3 = i3;
                        numberOfIncludes[n3] = numberOfIncludes[n3] + 1;
                    }
                    if (!specificRedefines[j2].schemaRedefined.indirectIncludes(current.schemaRedefined)) continue;
                    int n4 = j2;
                    numberOfIncludes[n4] = numberOfIncludes[n4] + 1;
                }
            }
            int position = 0;
            boolean errorReported = false;
            while (position < n2) {
                int i4;
                int index = -1;
                for (i4 = 0; i4 < numberOfIncludes.length; ++i4) {
                    if (numberOfIncludes[i4] != 0 || index >= 0) continue;
                    index = i4;
                }
                if (index < 0) {
                    if (!errorReported) {
                        StringBuffer fileNameList = new StringBuffer();
                        XmlObject location = null;
                        for (int i5 = 0; i5 < n2; ++i5) {
                            if (specificRedefines[i5] == null) continue;
                            fileNameList.append(specificRedefines[i5].schemaLocation).append(',').append(' ');
                            if (location != null) continue;
                            location = this.locationFromRedefinitionAndCode(specificRedefines[i5], name, componentType);
                        }
                        StscState.get().error("Detected circular redefinition of " + this.componentNameFromCode(componentType) + " \"" + name + "\"; Files involved: " + fileNameList.toString(), 60, location);
                        errorReported = true;
                    }
                    int min = n2;
                    for (int i6 = 0; i6 < n2; ++i6) {
                        if (numberOfIncludes[i6] <= 0 || numberOfIncludes[i6] >= min) continue;
                        min = numberOfIncludes[i6];
                        index = i6;
                    }
                    int n5 = index;
                    numberOfIncludes[n5] = numberOfIncludes[n5] - 1;
                    continue;
                }
                if (!$assertionsDisabled && specificRedefines[index] == null) {
                    throw new AssertionError();
                }
                sortedRedefines[position++] = specificRedefines[index];
                for (i4 = 0; i4 < n2; ++i4) {
                    if (specificRedefines[i4] == null || !specificRedefines[i4].schemaRedefined.indirectIncludes(specificRedefines[index].schemaRedefined)) continue;
                    int n6 = i4;
                    numberOfIncludes[n6] = numberOfIncludes[n6] - 1;
                }
                specificRedefines[index] = null;
                int n7 = index;
                numberOfIncludes[n7] = numberOfIncludes[n7] - 1;
            }
            for (int i7 = 1; i7 < n2; ++i7) {
                int j3;
                for (j3 = i7 - 1; j3 >= 0 && sortedRedefines[j3] == null; --j3) {
                }
                if (sortedRedefines[i7].schemaRedefined.indirectIncludes(sortedRedefines[j3].schemaRedefined)) continue;
                StscState.get().error("Detected multiple redefinitions of " + this.componentNameFromCode(componentType) + " \"" + name + "\"; Files involved: " + sortedRedefines[j3].schemaRedefined.getSourceName() + ", " + sortedRedefines[i7].schemaRedefined.getSourceName(), 49, this.locationFromRedefinitionAndCode(sortedRedefines[i7], name, componentType));
                switch (componentType) {
                    case 1: {
                        sortedRedefines[i7].redefineSimpleType(name);
                        break;
                    }
                    case 2: {
                        sortedRedefines[i7].redefineComplexType(name);
                        break;
                    }
                    case 4: {
                        sortedRedefines[i7].redefineAttributeGroup(name);
                        break;
                    }
                    case 3: {
                        sortedRedefines[i7].redefineModelGroup(name);
                    }
                }
                sortedRedefines[i7] = null;
            }
            return sortedRedefines;
        }

        private String componentNameFromCode(short code) {
            String componentName;
            switch (code) {
                case 1: {
                    componentName = "simple type";
                    break;
                }
                case 2: {
                    componentName = "complex type";
                    break;
                }
                case 3: {
                    componentName = "model group";
                    break;
                }
                case 4: {
                    componentName = "attribute group";
                    break;
                }
                default: {
                    componentName = "";
                }
            }
            return componentName;
        }

        private XmlObject locationFromRedefinitionAndCode(RedefinitionHolder redefinition, String name, short code) {
            XmlObject location;
            switch (code) {
                case 1: {
                    location = (XmlObject)redefinition.stRedefinitions.get(name);
                    break;
                }
                case 2: {
                    location = (XmlObject)redefinition.ctRedefinitions.get(name);
                    break;
                }
                case 3: {
                    location = (XmlObject)redefinition.mgRedefinitions.get(name);
                    break;
                }
                case 4: {
                    location = (XmlObject)redefinition.agRedefinitions.get(name);
                    break;
                }
                default: {
                    location = null;
                }
            }
            return location;
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$schema$StscTranslator == null ? (class$org$apache$xmlbeans$impl$schema$StscTranslator = StscTranslator.class$("org.apache.xmlbeans.impl.schema.StscTranslator")) : class$org$apache$xmlbeans$impl$schema$StscTranslator).desiredAssertionStatus();
            EMPTY_REDEFINTION_HOLDER_ARRAY = new RedefinitionHolder[0];
        }
    }

    private static class RedefinitionHolder {
        private Map stRedefinitions = Collections.EMPTY_MAP;
        private Map ctRedefinitions = Collections.EMPTY_MAP;
        private Map agRedefinitions = Collections.EMPTY_MAP;
        private Map mgRedefinitions = Collections.EMPTY_MAP;
        private String schemaLocation = "";
        private StscImporter.SchemaToProcess schemaRedefined;

        RedefinitionHolder(StscImporter.SchemaToProcess schemaToProcess, RedefineDocument.Redefine redefine) {
            this.schemaRedefined = schemaToProcess;
            if (redefine != null) {
                StscState state = StscState.get();
                this.stRedefinitions = new HashMap();
                this.ctRedefinitions = new HashMap();
                this.agRedefinitions = new HashMap();
                this.mgRedefinitions = new HashMap();
                if (redefine.getSchemaLocation() != null) {
                    this.schemaLocation = redefine.getSchemaLocation();
                }
                TopLevelComplexType[] complexTypes = redefine.getComplexTypeArray();
                for (int i2 = 0; i2 < complexTypes.length; ++i2) {
                    if (complexTypes[i2].getName() == null) continue;
                    if (this.ctRedefinitions.containsKey(complexTypes[i2].getName())) {
                        state.error("Duplicate type redefinition: " + complexTypes[i2].getName(), 49, null);
                        continue;
                    }
                    this.ctRedefinitions.put(complexTypes[i2].getName(), complexTypes[i2]);
                }
                TopLevelSimpleType[] simpleTypes = redefine.getSimpleTypeArray();
                for (int i3 = 0; i3 < simpleTypes.length; ++i3) {
                    if (simpleTypes[i3].getName() == null) continue;
                    if (this.stRedefinitions.containsKey(simpleTypes[i3].getName())) {
                        state.error("Duplicate type redefinition: " + simpleTypes[i3].getName(), 49, null);
                        continue;
                    }
                    this.stRedefinitions.put(simpleTypes[i3].getName(), simpleTypes[i3]);
                }
                NamedGroup[] modelgroups = redefine.getGroupArray();
                for (int i4 = 0; i4 < modelgroups.length; ++i4) {
                    if (modelgroups[i4].getName() == null) continue;
                    if (this.mgRedefinitions.containsKey(modelgroups[i4].getName())) {
                        state.error("Duplicate type redefinition: " + modelgroups[i4].getName(), 49, null);
                        continue;
                    }
                    this.mgRedefinitions.put(modelgroups[i4].getName(), modelgroups[i4]);
                }
                NamedAttributeGroup[] attrgroups = redefine.getAttributeGroupArray();
                for (int i5 = 0; i5 < attrgroups.length; ++i5) {
                    if (attrgroups[i5].getName() == null) continue;
                    if (this.agRedefinitions.containsKey(attrgroups[i5].getName())) {
                        state.error("Duplicate type redefinition: " + attrgroups[i5].getName(), 49, null);
                        continue;
                    }
                    this.agRedefinitions.put(attrgroups[i5].getName(), attrgroups[i5]);
                }
            }
        }

        public TopLevelSimpleType redefineSimpleType(String name) {
            if (name == null || !this.stRedefinitions.containsKey(name)) {
                return null;
            }
            return (TopLevelSimpleType)this.stRedefinitions.remove(name);
        }

        public TopLevelComplexType redefineComplexType(String name) {
            if (name == null || !this.ctRedefinitions.containsKey(name)) {
                return null;
            }
            return (TopLevelComplexType)this.ctRedefinitions.remove(name);
        }

        public NamedGroup redefineModelGroup(String name) {
            if (name == null || !this.mgRedefinitions.containsKey(name)) {
                return null;
            }
            return (NamedGroup)this.mgRedefinitions.remove(name);
        }

        public NamedAttributeGroup redefineAttributeGroup(String name) {
            if (name == null || !this.agRedefinitions.containsKey(name)) {
                return null;
            }
            return (NamedAttributeGroup)this.agRedefinitions.remove(name);
        }

        public void complainAboutMissingDefinitions() {
            String name;
            if (this.stRedefinitions.isEmpty() && this.ctRedefinitions.isEmpty() && this.agRedefinitions.isEmpty() && this.mgRedefinitions.isEmpty()) {
                return;
            }
            StscState state = StscState.get();
            Iterator i2 = this.stRedefinitions.keySet().iterator();
            while (i2.hasNext()) {
                name = (String)i2.next();
                state.error("Redefined simple type " + name + " not found in " + this.schemaLocation, 60, (XmlObject)this.stRedefinitions.get(name));
            }
            i2 = this.ctRedefinitions.keySet().iterator();
            while (i2.hasNext()) {
                name = (String)i2.next();
                state.error("Redefined complex type " + name + " not found in " + this.schemaLocation, 60, (XmlObject)this.ctRedefinitions.get(name));
            }
            i2 = this.agRedefinitions.keySet().iterator();
            while (i2.hasNext()) {
                name = (String)i2.next();
                state.error("Redefined attribute group " + name + " not found in " + this.schemaLocation, 60, (XmlObject)this.agRedefinitions.get(name));
            }
            i2 = this.mgRedefinitions.keySet().iterator();
            while (i2.hasNext()) {
                name = (String)i2.next();
                state.error("Redefined model group " + name + " not found in " + this.schemaLocation, 60, (XmlObject)this.mgRedefinitions.get(name));
            }
        }
    }
}

