/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.piccolo.xml;

import java.io.IOException;
import java.io.Reader;
import org.apache.xmlbeans.impl.piccolo.io.IllegalCharException;
import org.apache.xmlbeans.impl.piccolo.xml.XMLInputReader;

public final class XMLReaderReader
extends XMLInputReader {
    private static final int BUFFER_SIZE = 8192;
    private Reader in;
    private boolean rewindDeclaration;
    private char[] cbuf = new char[8192];
    private int cbufPos = 0;
    private int cbufEnd = 0;
    private boolean eofReached = false;
    private boolean sawCR = false;
    private char[] oneCharBuf = new char[1];

    public XMLReaderReader() {
    }

    public XMLReaderReader(Reader in2) throws IOException {
        this(in2, true);
    }

    public XMLReaderReader(Reader in2, boolean rewindDeclaration) throws IOException {
        this.reset(in2, rewindDeclaration);
    }

    public void reset(Reader in2, boolean rewindDeclaration) throws IOException {
        super.resetInput();
        this.in = in2;
        this.rewindDeclaration = rewindDeclaration;
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.sawCR = false;
        this.eofReached = false;
        this.fillCharBuffer();
        this.processXMLDecl();
    }

    public void close() throws IOException {
        this.eofReached = true;
        this.cbufEnd = 0;
        this.cbufPos = 0;
        if (this.in != null) {
            this.in.close();
        }
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new UnsupportedOperationException("mark() not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n2 = this.read(this.oneCharBuf, 0, 1);
        if (n2 <= 0) {
            return n2;
        }
        return this.oneCharBuf[0];
    }

    public int read(char[] destbuf) throws IOException {
        return this.read(destbuf, 0, destbuf.length);
    }

    public int read(char[] destbuf, int off, int len) throws IOException {
        int charsRead = 0;
        block5: while (charsRead < len) {
            if (this.cbufPos >= this.cbufEnd) {
                if (this.eofReached || charsRead != 0 && !this.in.ready()) break;
                this.fillCharBuffer();
                continue;
            }
            char c2 = this.cbuf[this.cbufPos++];
            if (c2 >= ' ') {
                if (c2 <= '\ud7ff' || c2 >= '\ue000' && c2 <= '\ufffd' || c2 >= '\u10000' && c2 <= '\u10ffff') {
                    this.sawCR = false;
                    destbuf[off + charsRead++] = c2;
                    continue;
                }
                throw new IllegalCharException("Illegal XML Character: 0x" + Integer.toHexString(c2));
            }
            switch (c2) {
                case '\n': {
                    if (this.sawCR) {
                        this.sawCR = false;
                        continue block5;
                    }
                    destbuf[off + charsRead++] = 10;
                    continue block5;
                }
                case '\r': {
                    this.sawCR = true;
                    destbuf[off + charsRead++] = 10;
                    continue block5;
                }
                case '\t': {
                    destbuf[off + charsRead++] = 9;
                    continue block5;
                }
            }
            throw new IllegalCharException("Illegal XML character: 0x" + Integer.toHexString(c2));
        }
        return charsRead == 0 && this.eofReached ? -1 : charsRead;
    }

    public boolean ready() throws IOException {
        return this.cbufEnd - this.cbufPos > 0 || this.in.ready();
    }

    public void reset() throws IOException {
        super.resetInput();
        this.in.reset();
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.sawCR = false;
        this.eofReached = false;
    }

    public long skip(long n2) throws IOException {
        int charsRead = 0;
        block5: while ((long)charsRead < n2) {
            if (this.cbufPos >= this.cbufEnd) {
                if (this.eofReached) break;
                this.fillCharBuffer();
                continue;
            }
            char c2 = this.cbuf[this.cbufPos++];
            if (c2 >= ' ') {
                if (c2 <= '\ud7ff' || c2 >= '\ue000' && c2 <= '\ufffd' || c2 >= '\u10000' && c2 <= '\u10ffff') {
                    this.sawCR = false;
                    ++charsRead;
                    continue;
                }
                throw new IllegalCharException("Illegal XML Character: 0x" + Integer.toHexString(c2));
            }
            switch (c2) {
                case '\n': {
                    if (this.sawCR) {
                        this.sawCR = false;
                        continue block5;
                    }
                    ++charsRead;
                    continue block5;
                }
                case '\r': {
                    this.sawCR = true;
                    ++charsRead;
                    continue block5;
                }
                case '\t': {
                    ++charsRead;
                    continue block5;
                }
            }
            throw new IllegalCharException("Illegal XML character: 0x" + Integer.toHexString(c2));
        }
        return charsRead == 0 && this.eofReached ? -1 : charsRead;
    }

    private void fillCharBuffer() throws IOException {
        this.cbufPos = 0;
        this.cbufEnd = this.in.read(this.cbuf, 0, 8192);
        if (this.cbufEnd <= 0) {
            this.eofReached = true;
        }
    }

    private void processXMLDecl() throws IOException {
        int numCharsParsed = this.parseXMLDeclaration(this.cbuf, 0, this.cbufEnd);
        if (numCharsParsed > 0 && !this.rewindDeclaration) {
            this.cbufPos += numCharsParsed;
        }
    }
}

