/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.piccolo.util;

public final class CharStringConverter {
    private static final float DEFAULT_LOAD = 0.7f;
    private float loadFactor;
    private int numEntries = 0;
    private int maxEntries;
    private int hashmask;
    private char[][] keys;
    private String[] values;

    public CharStringConverter(int initialCapacity, float loadFactor) {
        int size;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int desiredSize = (int)((float)initialCapacity / loadFactor);
        for (size = 16; size < desiredSize; size <<= 1) {
        }
        this.hashmask = size - 1;
        this.maxEntries = (int)((float)size * loadFactor);
        this.keys = new char[size][];
        this.values = new String[size];
        this.loadFactor = loadFactor;
    }

    public CharStringConverter() {
        this(0, 0.7f);
    }

    public CharStringConverter(int initialCapacity) {
        this(initialCapacity, 0.7f);
    }

    public int getCacheSize() {
        return this.numEntries;
    }

    public String convert(char[] ch2) {
        return this.convert(ch2, 0, ch2.length);
    }

    public String convert(char[] ch2, int start, int length) {
        if (this.numEntries >= this.maxEntries) {
            this.rehash();
        }
        int offset = CharStringConverter.hashKey(ch2, start, length) & this.hashmask;
        char[] k2 = null;
        while ((k2 = this.keys[offset]) != null && !CharStringConverter.keysAreEqual(k2, 0, k2.length, ch2, start, length)) {
            offset = offset - 1 & this.hashmask;
        }
        if (k2 != null) {
            return this.values[offset];
        }
        k2 = new char[length];
        System.arraycopy(ch2, start, k2, 0, length);
        String v2 = new String(k2).intern();
        this.keys[offset] = k2;
        this.values[offset] = v2;
        ++this.numEntries;
        return v2;
    }

    private void rehash() {
        int newlength = this.keys.length << 1;
        char[][] newkeys = new char[newlength][];
        String[] newvalues = new String[newlength];
        int newhashmask = newlength - 1;
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            char[] k2 = this.keys[i2];
            String v2 = this.values[i2];
            if (k2 == null) continue;
            int newoffset = CharStringConverter.hashKey(k2, 0, k2.length) & newhashmask;
            char[] newk = null;
            while ((newk = newkeys[newoffset]) != null && !CharStringConverter.keysAreEqual(newk, 0, newk.length, k2, 0, k2.length)) {
                newoffset = newoffset - 1 & newhashmask;
            }
            newkeys[newoffset] = k2;
            newvalues[newoffset] = v2;
        }
        this.keys = newkeys;
        this.values = newvalues;
        this.maxEntries = (int)((float)newlength * this.loadFactor);
        this.hashmask = newhashmask;
    }

    public void clearCache() {
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            this.keys[i2] = null;
            this.values[i2] = null;
        }
        this.numEntries = 0;
    }

    private static final boolean keysAreEqual(char[] a2, int astart, int alength, char[] b2, int bstart, int blength) {
        if (alength != blength) {
            return false;
        }
        for (int i2 = 0; i2 < alength; ++i2) {
            if (a2[astart + i2] == b2[bstart + i2]) continue;
            return false;
        }
        return true;
    }

    private static final int hashKey(char[] ch2, int start, int length) {
        int hash = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            hash = (hash << 5) + ch2[start + i2];
        }
        return hash;
    }
}

