/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xmlbeans.impl.jam.provider.JamLogger;

public class DirectoryScanner {
    private boolean mCaseSensitive = true;
    private File mRoot;
    private JamLogger mLogger;
    private List mIncludeList = null;
    private List mExcludeList = null;
    private String[] mIncludes;
    private String[] mExcludes;
    private Vector mFilesIncluded;
    private Vector mDirsIncluded;
    private boolean mIsDirty = false;
    private String[] mIncludedFilesCache = null;

    public DirectoryScanner(File dirToScan, JamLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("null logger");
        }
        this.mLogger = logger;
        this.mRoot = dirToScan;
    }

    public void include(String pattern) {
        if (this.mIncludeList == null) {
            this.mIncludeList = new ArrayList();
        }
        this.mIncludeList.add(pattern);
        this.mIsDirty = true;
    }

    public void exclude(String pattern) {
        if (this.mExcludeList == null) {
            this.mExcludeList = new ArrayList();
        }
        this.mExcludeList.add(pattern);
        this.mIsDirty = true;
    }

    public String[] getIncludedFiles() throws IOException {
        if (!this.mIsDirty && this.mIncludedFilesCache != null) {
            return this.mIncludedFilesCache;
        }
        if (this.mIncludeList != null) {
            String[] inc = new String[this.mIncludeList.size()];
            this.mIncludeList.toArray(inc);
            this.setIncludes(inc);
        } else {
            this.setIncludes(null);
        }
        if (this.mExcludeList != null) {
            String[] exc = new String[this.mExcludeList.size()];
            this.mExcludeList.toArray(exc);
            this.setExcludes(exc);
        } else {
            this.setExcludes(null);
        }
        this.scan();
        this.mIncludedFilesCache = new String[this.mFilesIncluded.size()];
        this.mFilesIncluded.copyInto(this.mIncludedFilesCache);
        return this.mIncludedFilesCache;
    }

    public void setDirty() {
        this.mIsDirty = true;
    }

    public File getRoot() {
        return this.mRoot;
    }

    private void setIncludes(String[] includes) {
        if (includes == null) {
            this.mIncludes = null;
        } else {
            this.mIncludes = new String[includes.length];
            for (int i2 = 0; i2 < includes.length; ++i2) {
                String pattern = includes[i2].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.mIncludes[i2] = pattern;
            }
        }
    }

    private void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.mExcludes = null;
        } else {
            this.mExcludes = new String[excludes.length];
            for (int i2 = 0; i2 < excludes.length; ++i2) {
                String pattern = excludes[i2].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.mExcludes[i2] = pattern;
            }
        }
    }

    private void scan() throws IllegalStateException, IOException {
        if (this.mIncludes == null) {
            this.mIncludes = new String[1];
            this.mIncludes[0] = "**";
        }
        if (this.mExcludes == null) {
            this.mExcludes = new String[0];
        }
        this.mFilesIncluded = new Vector();
        this.mDirsIncluded = new Vector();
        if (this.isIncluded("") && !this.isExcluded("")) {
            this.mDirsIncluded.addElement("");
        }
        this.scandir(this.mRoot, "", true);
    }

    private void scandir(File dir, String vpath, boolean fast) throws IOException {
        String[] newfiles;
        if (this.mLogger.isVerbose(this)) {
            this.mLogger.verbose("[DirectoryScanner] scanning dir " + dir + " for '" + vpath + "'");
        }
        if ((newfiles = dir.list()) == null) {
            throw new IOException("IO error scanning directory " + dir.getAbsolutePath());
        }
        for (int i2 = 0; i2 < newfiles.length; ++i2) {
            String name = vpath + newfiles[i2];
            File file = new File(dir, newfiles[i2]);
            if (file.isDirectory()) {
                if (this.isIncluded(name) && !this.isExcluded(name)) {
                    this.mDirsIncluded.addElement(name);
                    if (this.mLogger.isVerbose(this)) {
                        this.mLogger.verbose("...including dir " + name);
                    }
                    this.scandir(file, name + File.separator, fast);
                    continue;
                }
                if (!this.couldHoldIncluded(name)) continue;
                this.scandir(file, name + File.separator, fast);
                continue;
            }
            if (!file.isFile() || !this.isIncluded(name)) continue;
            if (!this.isExcluded(name)) {
                this.mFilesIncluded.addElement(name);
                if (!this.mLogger.isVerbose(this)) continue;
                this.mLogger.verbose("...including " + name + " under '" + dir);
                continue;
            }
            if (!this.mLogger.isVerbose(this)) continue;
            this.mLogger.verbose("...EXCLUDING " + name + " under '" + dir);
        }
    }

    private boolean isIncluded(String name) {
        for (int i2 = 0; i2 < this.mIncludes.length; ++i2) {
            if (!DirectoryScanner.matchPath(this.mIncludes[i2], name, this.mCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    private boolean couldHoldIncluded(String name) {
        for (int i2 = 0; i2 < this.mIncludes.length; ++i2) {
            if (!DirectoryScanner.matchPatternStart(this.mIncludes[i2], name, this.mCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(String name) {
        for (int i2 = 0; i2 < this.mExcludes.length; ++i2) {
            if (!DirectoryScanner.matchPath(this.mExcludes[i2], name, this.mCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchPatternStart(String pattern, String str, boolean mCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        Vector patDirs = DirectoryScanner.tokenizePath(pattern);
        Vector strDirs = DirectoryScanner.tokenizePath(str);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = (String)patDirs.elementAt(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (DirectoryScanner.match(patDir, (String)strDirs.elementAt(strIdxStart), mCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    private static boolean matchPath(String pattern, String str, boolean mCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        Vector patDirs = DirectoryScanner.tokenizePath(pattern);
        Vector strDirs = DirectoryScanner.tokenizePath(str);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = (String)patDirs.elementAt(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (DirectoryScanner.match(patDir, (String)strDirs.elementAt(strIdxStart), mCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patDirs.elementAt(i2).equals("**")) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = (String)patDirs.elementAt(patIdxEnd)).equals("**")) {
            if (!DirectoryScanner.match(patDir, (String)strDirs.elementAt(strIdxEnd), mCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (patDirs.elementAt(i3).equals("**")) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = patIdxStart + 1; i4 <= patIdxEnd; ++i4) {
                if (!patDirs.elementAt(i4).equals("**")) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    String subStr;
                    String subPat = (String)patDirs.elementAt(patIdxStart + j2 + 1);
                    if (!DirectoryScanner.match(subPat, subStr = (String)strDirs.elementAt(strIdxStart + i5 + j2), mCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i6 = patIdxStart; i6 <= patIdxEnd; ++i6) {
            if (patDirs.elementAt(i6).equals("**")) continue;
            return false;
        }
        return true;
    }

    private static boolean match(String pattern, String str, boolean mCaseSensitive) {
        char ch2;
        int i2;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i2 = 0; i2 < patArr.length; ++i2) {
            if (patArr[i2] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch3 = patArr[i2];
                if (ch3 == '?') continue;
                if (mCaseSensitive && ch3 != strArr[i2]) {
                    return false;
                }
                if (mCaseSensitive || Character.toUpperCase(ch3) == Character.toUpperCase(strArr[i2])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch2 = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch2 != '?') {
                if (mCaseSensitive && ch2 != strArr[strIdxStart]) {
                    return false;
                }
                if (!mCaseSensitive && Character.toUpperCase(ch2) != Character.toUpperCase(strArr[strIdxStart])) {
                    return false;
                }
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch2 = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch2 != '?') {
                if (mCaseSensitive && ch2 != strArr[strIdxEnd]) {
                    return false;
                }
                if (!mCaseSensitive && Character.toUpperCase(ch2) != Character.toUpperCase(strArr[strIdxEnd])) {
                    return false;
                }
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i3 = patIdxStart + 1; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] != '*') continue;
                patIdxTmp = i3;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i4 = 0; i4 <= strLength - patLength; ++i4) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    ch2 = patArr[patIdxStart + j2 + 1];
                    if (ch2 != '?' && (mCaseSensitive && ch2 != strArr[strIdxStart + i4 + j2] || !mCaseSensitive && Character.toUpperCase(ch2) != Character.toUpperCase(strArr[strIdxStart + i4 + j2]))) continue block8;
                }
                foundIdx = strIdxStart + i4;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
            if (patArr[i2] == '*') continue;
            return false;
        }
        return true;
    }

    private static Vector tokenizePath(String path) {
        Vector<String> ret = new Vector<String>();
        StringTokenizer st = new StringTokenizer(path, File.separator);
        while (st.hasMoreTokens()) {
            ret.addElement(st.nextToken());
        }
        return ret;
    }
}

