/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.Internal;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.XWPFSDTCell;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;

public class XWPFTableRow {
    private CTRow ctRow;
    private XWPFTable table;
    private List<XWPFTableCell> tableCells;

    public XWPFTableRow(CTRow row, XWPFTable table) {
        this.table = table;
        this.ctRow = row;
        this.getTableCells();
    }

    @Internal
    public CTRow getCtRow() {
        return this.ctRow;
    }

    public XWPFTableCell createCell() {
        XWPFTableCell tableCell = new XWPFTableCell(this.ctRow.addNewTc(), this, this.table.getBody());
        this.tableCells.add(tableCell);
        return tableCell;
    }

    public XWPFTableCell getCell(int pos) {
        if (pos >= 0 && pos < this.ctRow.sizeOfTcArray()) {
            return this.getTableCells().get(pos);
        }
        return null;
    }

    public void removeCell(int pos) {
        if (pos >= 0 && pos < this.ctRow.sizeOfTcArray()) {
            this.tableCells.remove(pos);
        }
    }

    public XWPFTableCell addNewTableCell() {
        CTTc cell = this.ctRow.addNewTc();
        XWPFTableCell tableCell = new XWPFTableCell(cell, this, this.table.getBody());
        this.tableCells.add(tableCell);
        return tableCell;
    }

    public int getHeight() {
        CTTrPr properties = this.getTrPr();
        return properties.sizeOfTrHeightArray() == 0 ? 0 : properties.getTrHeightArray(0).getVal().intValue();
    }

    public void setHeight(int height) {
        CTTrPr properties = this.getTrPr();
        CTHeight h2 = properties.sizeOfTrHeightArray() == 0 ? properties.addNewTrHeight() : properties.getTrHeightArray(0);
        h2.setVal(new BigInteger("" + height));
    }

    private CTTrPr getTrPr() {
        return this.ctRow.isSetTrPr() ? this.ctRow.getTrPr() : this.ctRow.addNewTrPr();
    }

    public XWPFTable getTable() {
        return this.table;
    }

    public List<ICell> getTableICells() {
        ArrayList<ICell> cells = new ArrayList<ICell>();
        XmlCursor cursor = this.ctRow.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o2 = cursor.getObject();
            if (o2 instanceof CTTc) {
                cells.add(new XWPFTableCell((CTTc)o2, this, this.table.getBody()));
                continue;
            }
            if (!(o2 instanceof CTSdtCell)) continue;
            cells.add(new XWPFSDTCell((CTSdtCell)o2, this, this.table.getBody()));
        }
        cursor.dispose();
        return cells;
    }

    public List<XWPFTableCell> getTableCells() {
        if (this.tableCells == null) {
            ArrayList<XWPFTableCell> cells = new ArrayList<XWPFTableCell>();
            for (CTTc tableCell : this.ctRow.getTcArray()) {
                cells.add(new XWPFTableCell(tableCell, this, this.table.getBody()));
            }
            this.tableCells = cells;
        }
        return this.tableCells;
    }

    public XWPFTableCell getTableCell(CTTc cell) {
        for (int i2 = 0; i2 < this.tableCells.size(); ++i2) {
            if (this.tableCells.get(i2).getCTTc() != cell) continue;
            return this.tableCells.get(i2);
        }
        return null;
    }

    public boolean isCantSplitRow() {
        boolean isCant = false;
        CTTrPr trpr = this.getTrPr();
        if (trpr.sizeOfCantSplitArray() > 0) {
            CTOnOff onoff = trpr.getCantSplitArray(0);
            isCant = onoff.getVal().equals(STOnOff.ON);
        }
        return isCant;
    }

    public void setCantSplitRow(boolean split) {
        CTTrPr trpr = this.getTrPr();
        CTOnOff onoff = trpr.addNewCantSplit();
        onoff.setVal(split ? STOnOff.ON : STOnOff.OFF);
    }

    public boolean isRepeatHeader() {
        boolean repeat = false;
        CTTrPr trpr = this.getTrPr();
        if (trpr.sizeOfTblHeaderArray() > 0) {
            CTOnOff rpt = trpr.getTblHeaderArray(0);
            repeat = rpt.getVal().equals(STOnOff.ON);
        }
        return repeat;
    }

    public void setRepeatHeader(boolean repeat) {
        CTTrPr trpr = this.getTrPr();
        CTOnOff onoff = trpr.addNewTblHeader();
        onoff.setVal(repeat ? STOnOff.ON : STOnOff.OFF);
    }
}

