/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.util.Internal;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class XWPFTableCell
implements IBody,
ICell {
    private static EnumMap<XWPFVertAlign, STVerticalJc.Enum> alignMap = new EnumMap(XWPFVertAlign.class);
    private static HashMap<Integer, XWPFVertAlign> stVertAlignTypeMap;
    private final CTTc ctTc;
    protected List<XWPFParagraph> paragraphs = null;
    protected List<XWPFTable> tables = null;
    protected List<IBodyElement> bodyElements = null;
    protected IBody part;
    private XWPFTableRow tableRow = null;

    public XWPFTableCell(CTTc cell, XWPFTableRow tableRow, IBody part) {
        this.ctTc = cell;
        this.part = part;
        this.tableRow = tableRow;
        if (cell.sizeOfPArray() < 1) {
            cell.addNewP();
        }
        this.bodyElements = new ArrayList<IBodyElement>();
        this.paragraphs = new ArrayList<XWPFParagraph>();
        this.tables = new ArrayList<XWPFTable>();
        XmlCursor cursor = this.ctTc.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XWPFSDT c2;
            XmlObject o2 = cursor.getObject();
            if (o2 instanceof CTP) {
                XWPFParagraph p2 = new XWPFParagraph((CTP)o2, this);
                this.paragraphs.add(p2);
                this.bodyElements.add(p2);
            }
            if (o2 instanceof CTTbl) {
                XWPFTable t2 = new XWPFTable((CTTbl)o2, this);
                this.tables.add(t2);
                this.bodyElements.add(t2);
            }
            if (o2 instanceof CTSdtBlock) {
                c2 = new XWPFSDT((CTSdtBlock)o2, (IBody)this);
                this.bodyElements.add(c2);
            }
            if (!(o2 instanceof CTSdtRun)) continue;
            c2 = new XWPFSDT((CTSdtRun)o2, (IBody)this);
            System.out.println(c2.getContent().getText());
            this.bodyElements.add(c2);
        }
        cursor.dispose();
    }

    @Internal
    public CTTc getCTTc() {
        return this.ctTc;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public void setParagraph(XWPFParagraph p2) {
        if (this.ctTc.sizeOfPArray() == 0) {
            this.ctTc.addNewP();
        }
        this.ctTc.setPArray(0, p2.getCTP());
    }

    @Override
    public List<XWPFParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public XWPFParagraph addParagraph() {
        XWPFParagraph p2 = new XWPFParagraph(this.ctTc.addNewP(), this);
        this.addParagraph(p2);
        return p2;
    }

    public void addParagraph(XWPFParagraph p2) {
        this.paragraphs.add(p2);
    }

    public void removeParagraph(int pos) {
        this.paragraphs.remove(pos);
        this.ctTc.removeP(pos);
    }

    @Override
    public XWPFParagraph getParagraph(CTP p2) {
        for (XWPFParagraph paragraph : this.paragraphs) {
            if (!p2.equals(paragraph.getCTP())) continue;
            return paragraph;
        }
        return null;
    }

    public XWPFTableRow getTableRow() {
        return this.tableRow;
    }

    public String getColor() {
        CTShd ctshd;
        String color = null;
        CTTcPr tcpr = this.ctTc.getTcPr();
        if (tcpr != null && (ctshd = tcpr.getShd()) != null) {
            color = ctshd.xgetFill().getStringValue();
        }
        return color;
    }

    public void setColor(String rgbStr) {
        CTTcPr tcpr = this.ctTc.isSetTcPr() ? this.ctTc.getTcPr() : this.ctTc.addNewTcPr();
        CTShd ctshd = tcpr.isSetShd() ? tcpr.getShd() : tcpr.addNewShd();
        ctshd.setColor("auto");
        ctshd.setVal(STShd.CLEAR);
        ctshd.setFill(rgbStr);
    }

    public XWPFVertAlign getVerticalAlignment() {
        XWPFVertAlign vAlign = null;
        CTTcPr tcpr = this.ctTc.getTcPr();
        if (tcpr != null) {
            CTVerticalJc va = tcpr.getVAlign();
            vAlign = va != null ? stVertAlignTypeMap.get(va.getVal().intValue()) : XWPFVertAlign.TOP;
            if (va != null && va.getVal() != null) {
                vAlign = stVertAlignTypeMap.get(va.getVal().intValue());
            }
        }
        return vAlign;
    }

    public void setVerticalAlignment(XWPFVertAlign vAlign) {
        CTTcPr tcpr = this.ctTc.isSetTcPr() ? this.ctTc.getTcPr() : this.ctTc.addNewTcPr();
        CTVerticalJc va = tcpr.addNewVAlign();
        va.setVal(alignMap.get((Object)vAlign));
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (!this.isCursorInTableCell(cursor)) {
            return null;
        }
        String uri = CTP.type.getName().getNamespaceURI();
        String localPart = "p";
        cursor.beginElement(localPart, uri);
        cursor.toParent();
        CTP p2 = (CTP)cursor.getObject();
        XWPFParagraph newP = new XWPFParagraph(p2, this);
        XmlObject o2 = null;
        while (!(o2 instanceof CTP) && cursor.toPrevSibling()) {
            o2 = cursor.getObject();
        }
        if (!(o2 instanceof CTP) || (CTP)o2 == p2) {
            this.paragraphs.add(0, newP);
        } else {
            int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o2)) + 1;
            this.paragraphs.add(pos, newP);
        }
        int i2 = 0;
        XmlCursor p22 = p2.newCursor();
        cursor.toCursor(p22);
        p22.dispose();
        while (cursor.toPrevSibling()) {
            o2 = cursor.getObject();
            if (!(o2 instanceof CTP) && !(o2 instanceof CTTbl)) continue;
            ++i2;
        }
        this.bodyElements.add(i2, newP);
        p22 = p2.newCursor();
        cursor.toCursor(p22);
        p22.dispose();
        cursor.toEndToken();
        return newP;
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInTableCell(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t2 = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t2, this);
            cursor.removeXmlContents();
            XmlObject o2 = null;
            while (!(o2 instanceof CTTbl) && cursor.toPrevSibling()) {
                o2 = cursor.getObject();
            }
            if (!(o2 instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o2)) + 1;
                this.tables.add(pos, newT);
            }
            int i2 = 0;
            XmlCursor cursor2 = t2.newCursor();
            while (cursor2.toPrevSibling()) {
                o2 = cursor2.getObject();
                if (!(o2 instanceof CTP) && !(o2 instanceof CTTbl)) continue;
                ++i2;
            }
            cursor2.dispose();
            this.bodyElements.add(i2, newT);
            cursor2 = t2.newCursor();
            cursor.toCursor(cursor2);
            cursor.toEndToken();
            cursor2.dispose();
            return newT;
        }
        return null;
    }

    private boolean isCursorInTableCell(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        boolean result = verify.getObject() == this.ctTc;
        verify.dispose();
        return result;
    }

    @Override
    public XWPFParagraph getParagraphArray(int pos) {
        if (pos >= 0 && pos < this.paragraphs.size()) {
            return this.paragraphs.get(pos);
        }
        return null;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        return this.tableRow.getTable().getPart();
    }

    @Override
    public BodyType getPartType() {
        return BodyType.TABLECELL;
    }

    @Override
    public XWPFTable getTable(CTTbl ctTable) {
        for (int i2 = 0; i2 < this.tables.size(); ++i2) {
            if (this.getTables().get(i2).getCTTbl() != ctTable) continue;
            return this.getTables().get(i2);
        }
        return null;
    }

    @Override
    public XWPFTable getTableArray(int pos) {
        if (pos >= 0 && pos < this.tables.size()) {
            return this.tables.get(pos);
        }
        return null;
    }

    @Override
    public List<XWPFTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public void insertTable(int pos, XWPFTable table) {
        this.bodyElements.add(pos, table);
        int i2 = 0;
        for (CTTbl tbl : this.ctTc.getTblArray()) {
            if (tbl == table.getCTTbl()) break;
            ++i2;
        }
        this.tables.add(i2, table);
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        for (XWPFParagraph p2 : this.paragraphs) {
            text.append(p2.getText());
        }
        return text.toString();
    }

    public void setText(String text) {
        CTP ctP = this.ctTc.sizeOfPArray() == 0 ? this.ctTc.addNewP() : this.ctTc.getPArray(0);
        XWPFParagraph par = new XWPFParagraph(ctP, this);
        par.createRun().setText(text);
    }

    public String getTextRecursively() {
        StringBuffer text = new StringBuffer();
        for (int i2 = 0; i2 < this.bodyElements.size(); ++i2) {
            boolean isLast = i2 == this.bodyElements.size() - 1;
            this.appendBodyElementText(text, this.bodyElements.get(i2), isLast);
        }
        return text.toString();
    }

    private void appendBodyElementText(StringBuffer text, IBodyElement e2, boolean isLast) {
        if (e2 instanceof XWPFParagraph) {
            text.append(((XWPFParagraph)e2).getText());
            if (!isLast) {
                text.append('\t');
            }
        } else if (e2 instanceof XWPFTable) {
            XWPFTable eTable = (XWPFTable)e2;
            for (XWPFTableRow row : eTable.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    List<IBodyElement> localBodyElements = cell.getBodyElements();
                    for (int i2 = 0; i2 < localBodyElements.size(); ++i2) {
                        boolean localIsLast = i2 == localBodyElements.size() - 1;
                        this.appendBodyElementText(text, localBodyElements.get(i2), localIsLast);
                    }
                }
            }
            if (!isLast) {
                text.append('\n');
            }
        } else if (e2 instanceof XWPFSDT) {
            text.append(((XWPFSDT)e2).getContent().getText());
            if (!isLast) {
                text.append('\t');
            }
        }
    }

    @Override
    public XWPFTableCell getTableCell(CTTc cell) {
        XmlCursor cursor = cell.newCursor();
        cursor.toParent();
        XmlObject o2 = cursor.getObject();
        if (!(o2 instanceof CTRow)) {
            return null;
        }
        CTRow row = (CTRow)o2;
        cursor.toParent();
        o2 = cursor.getObject();
        cursor.dispose();
        if (!(o2 instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o2;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tr = table.getRow(row);
        if (tr == null) {
            return null;
        }
        return tr.getTableCell(cell);
    }

    @Override
    public XWPFDocument getXWPFDocument() {
        return this.part.getXWPFDocument();
    }

    static {
        alignMap.put(XWPFVertAlign.TOP, STVerticalJc.Enum.forInt(1));
        alignMap.put(XWPFVertAlign.CENTER, STVerticalJc.Enum.forInt(2));
        alignMap.put(XWPFVertAlign.BOTH, STVerticalJc.Enum.forInt(3));
        alignMap.put(XWPFVertAlign.BOTTOM, STVerticalJc.Enum.forInt(4));
        stVertAlignTypeMap = new HashMap();
        stVertAlignTypeMap.put(1, XWPFVertAlign.TOP);
        stVertAlignTypeMap.put(2, XWPFVertAlign.CENTER);
        stVertAlignTypeMap.put(3, XWPFVertAlign.BOTH);
        stVertAlignTypeMap.put(4, XWPFVertAlign.BOTTOM);
    }

    public static enum XWPFVertAlign {
        TOP,
        CENTER,
        BOTH,
        BOTTOM;

    }
}

