/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.util.Internal;
import org.apache.poi.wp.usermodel.Paragraph;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.Borders;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.LineSpacingRule;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.PositionInParagraph;
import org.apache.poi.xwpf.usermodel.TextAlignment;
import org.apache.poi.xwpf.usermodel.TextSegement;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFieldRun;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdnRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPBdr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTProofErr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRunTrackChange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSmartTagRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextAlignment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTextAlignment;

public class XWPFParagraph
implements IBodyElement,
IRunBody,
ISDTContents,
Paragraph {
    private final CTP paragraph;
    protected IBody part;
    protected XWPFDocument document;
    protected List<XWPFRun> runs;
    protected List<IRunElement> iruns;
    private StringBuffer footnoteText = new StringBuffer();

    public XWPFParagraph(CTP prgrph, IBody part) {
        this.paragraph = prgrph;
        this.part = part;
        this.document = part.getXWPFDocument();
        if (this.document == null) {
            throw new NullPointerException();
        }
        this.runs = new ArrayList<XWPFRun>();
        this.iruns = new ArrayList<IRunElement>();
        this.buildRunsInOrderFromXml(this.paragraph);
        for (XWPFRun run : this.runs) {
            CTR r2 = run.getCTR();
            XmlCursor c2 = r2.newCursor();
            c2.selectPath("child::*");
            while (c2.toNextSelection()) {
                XmlObject o2 = c2.getObject();
                if (!(o2 instanceof CTFtnEdnRef)) continue;
                CTFtnEdnRef ftn = (CTFtnEdnRef)o2;
                this.footnoteText.append(" [").append(ftn.getId()).append(": ");
                XWPFFootnote footnote = ftn.getDomNode().getLocalName().equals("footnoteReference") ? this.document.getFootnoteByID(ftn.getId().intValue()) : this.document.getEndnoteByID(ftn.getId().intValue());
                boolean first = true;
                for (XWPFParagraph p2 : footnote.getParagraphs()) {
                    if (!first) {
                        this.footnoteText.append("\n");
                        first = false;
                    }
                    this.footnoteText.append(p2.getText());
                }
                this.footnoteText.append("] ");
            }
            c2.dispose();
        }
    }

    private void buildRunsInOrderFromXml(XmlObject object) {
        XmlCursor c2 = object.newCursor();
        c2.selectPath("child::*");
        while (c2.toNextSelection()) {
            XWPFSDT cc2;
            XmlObject o2 = c2.getObject();
            if (o2 instanceof CTR) {
                XWPFRun r2 = new XWPFRun((CTR)o2, this);
                this.runs.add(r2);
                this.iruns.add(r2);
            }
            if (o2 instanceof CTHyperlink) {
                CTHyperlink link = (CTHyperlink)o2;
                for (CTR r3 : link.getRArray()) {
                    XWPFHyperlinkRun hr2 = new XWPFHyperlinkRun(link, r3, this);
                    this.runs.add(hr2);
                    this.iruns.add(hr2);
                }
            }
            if (o2 instanceof CTSimpleField) {
                CTSimpleField field = (CTSimpleField)o2;
                for (CTR r3 : field.getRArray()) {
                    XWPFFieldRun fr2 = new XWPFFieldRun(field, r3, this);
                    this.runs.add(fr2);
                    this.iruns.add(fr2);
                }
            }
            if (o2 instanceof CTSdtBlock) {
                cc2 = new XWPFSDT((CTSdtBlock)o2, this.part);
                this.iruns.add(cc2);
            }
            if (o2 instanceof CTSdtRun) {
                cc2 = new XWPFSDT((CTSdtRun)o2, this.part);
                this.iruns.add(cc2);
            }
            if (o2 instanceof CTRunTrackChange) {
                for (CTR r4 : ((CTRunTrackChange)o2).getRArray()) {
                    XWPFRun cr2 = new XWPFRun(r4, this);
                    this.runs.add(cr2);
                    this.iruns.add(cr2);
                }
            }
            if (!(o2 instanceof CTSmartTagRun)) continue;
            this.buildRunsInOrderFromXml(o2);
        }
        c2.dispose();
    }

    @Internal
    public CTP getCTP() {
        return this.paragraph;
    }

    public List<XWPFRun> getRuns() {
        return Collections.unmodifiableList(this.runs);
    }

    public List<IRunElement> getIRuns() {
        return Collections.unmodifiableList(this.iruns);
    }

    public boolean isEmpty() {
        return !this.paragraph.getDomNode().hasChildNodes();
    }

    @Override
    public XWPFDocument getDocument() {
        return this.document;
    }

    public String getText() {
        StringBuffer out = new StringBuffer();
        for (IRunElement run : this.iruns) {
            if (run instanceof XWPFRun) {
                XWPFRun xRun = (XWPFRun)run;
                if (xRun.getCTR().isSetRsidDel()) continue;
                out.append(xRun.toString());
                continue;
            }
            if (run instanceof XWPFSDT) {
                out.append(((XWPFSDT)run).getContent().getText());
                continue;
            }
            out.append(run.toString());
        }
        out.append(this.footnoteText);
        return out.toString();
    }

    public String getStyleID() {
        if (this.paragraph.getPPr() != null && this.paragraph.getPPr().getPStyle() != null && this.paragraph.getPPr().getPStyle().getVal() != null) {
            return this.paragraph.getPPr().getPStyle().getVal();
        }
        return null;
    }

    public BigInteger getNumID() {
        if (this.paragraph.getPPr() != null && this.paragraph.getPPr().getNumPr() != null && this.paragraph.getPPr().getNumPr().getNumId() != null) {
            return this.paragraph.getPPr().getNumPr().getNumId().getVal();
        }
        return null;
    }

    public void setNumID(BigInteger numPos) {
        if (this.paragraph.getPPr() == null) {
            this.paragraph.addNewPPr();
        }
        if (this.paragraph.getPPr().getNumPr() == null) {
            this.paragraph.getPPr().addNewNumPr();
        }
        if (this.paragraph.getPPr().getNumPr().getNumId() == null) {
            this.paragraph.getPPr().getNumPr().addNewNumId();
        }
        this.paragraph.getPPr().getNumPr().getNumId().setVal(numPos);
    }

    public BigInteger getNumIlvl() {
        if (this.paragraph.getPPr() != null && this.paragraph.getPPr().getNumPr() != null && this.paragraph.getPPr().getNumPr().getIlvl() != null) {
            return this.paragraph.getPPr().getNumPr().getIlvl().getVal();
        }
        return null;
    }

    public String getNumFmt() {
        XWPFNum num;
        BigInteger numID = this.getNumID();
        XWPFNumbering numbering = this.document.getNumbering();
        if (numID != null && numbering != null && (num = numbering.getNum(numID)) != null) {
            BigInteger ilvl = this.getNumIlvl();
            BigInteger abstractNumId = num.getCTNum().getAbstractNumId().getVal();
            CTAbstractNum anum = numbering.getAbstractNum(abstractNumId).getAbstractNum();
            CTLvl level = null;
            for (int i2 = 0; i2 < anum.sizeOfLvlArray(); ++i2) {
                CTLvl lvl = anum.getLvlArray(i2);
                if (!lvl.getIlvl().equals(ilvl)) continue;
                level = lvl;
                break;
            }
            if (level != null && level.getNumFmt() != null && level.getNumFmt().getVal() != null) {
                return level.getNumFmt().getVal().toString();
            }
        }
        return null;
    }

    public String getNumLevelText() {
        XWPFNum num;
        BigInteger numID = this.getNumID();
        XWPFNumbering numbering = this.document.getNumbering();
        if (numID != null && numbering != null && (num = numbering.getNum(numID)) != null) {
            BigInteger ilvl = this.getNumIlvl();
            CTNum ctNum = num.getCTNum();
            if (ctNum == null) {
                return null;
            }
            CTDecimalNumber ctDecimalNumber = ctNum.getAbstractNumId();
            if (ctDecimalNumber == null) {
                return null;
            }
            BigInteger abstractNumId = ctDecimalNumber.getVal();
            if (abstractNumId == null) {
                return null;
            }
            XWPFAbstractNum xwpfAbstractNum = numbering.getAbstractNum(abstractNumId);
            if (xwpfAbstractNum == null) {
                return null;
            }
            CTAbstractNum anum = xwpfAbstractNum.getCTAbstractNum();
            if (anum == null) {
                return null;
            }
            CTLvl level = null;
            for (int i2 = 0; i2 < anum.sizeOfLvlArray(); ++i2) {
                CTLvl lvl = anum.getLvlArray(i2);
                if (lvl == null || lvl.getIlvl() == null || !lvl.getIlvl().equals(ilvl)) continue;
                level = lvl;
                break;
            }
            if (level != null && level.getLvlText() != null && level.getLvlText().getVal() != null) {
                return level.getLvlText().getVal().toString();
            }
        }
        return null;
    }

    public BigInteger getNumStartOverride() {
        XWPFNum num;
        BigInteger numID = this.getNumID();
        XWPFNumbering numbering = this.document.getNumbering();
        if (numID != null && numbering != null && (num = numbering.getNum(numID)) != null) {
            CTNum ctNum = num.getCTNum();
            if (ctNum == null) {
                return null;
            }
            BigInteger ilvl = this.getNumIlvl();
            CTNumLvl level = null;
            for (int i2 = 0; i2 < ctNum.sizeOfLvlOverrideArray(); ++i2) {
                CTNumLvl ctNumLvl = ctNum.getLvlOverrideArray(i2);
                if (ctNumLvl == null || ctNumLvl.getIlvl() == null || !ctNumLvl.getIlvl().equals(ilvl)) continue;
                level = ctNumLvl;
                break;
            }
            if (level != null && level.getStartOverride() != null) {
                return level.getStartOverride().getVal();
            }
        }
        return null;
    }

    public String getParagraphText() {
        StringBuffer out = new StringBuffer();
        for (XWPFRun run : this.runs) {
            out.append(run.toString());
        }
        return out.toString();
    }

    public String getPictureText() {
        StringBuffer out = new StringBuffer();
        for (XWPFRun run : this.runs) {
            out.append(run.getPictureText());
        }
        return out.toString();
    }

    public String getFootnoteText() {
        return this.footnoteText.toString();
    }

    public ParagraphAlignment getAlignment() {
        CTPPr pr = this.getCTPPr();
        return pr == null || !pr.isSetJc() ? ParagraphAlignment.LEFT : ParagraphAlignment.valueOf(pr.getJc().getVal().intValue());
    }

    public void setAlignment(ParagraphAlignment align) {
        CTPPr pr = this.getCTPPr();
        CTJc jc2 = pr.isSetJc() ? pr.getJc() : pr.addNewJc();
        STJc.Enum en2 = STJc.Enum.forInt(align.getValue());
        jc2.setVal(en2);
    }

    @Override
    public int getFontAlignment() {
        return this.getAlignment().getValue();
    }

    @Override
    public void setFontAlignment(int align) {
        ParagraphAlignment pAlign = ParagraphAlignment.valueOf(align);
        this.setAlignment(pAlign);
    }

    public TextAlignment getVerticalAlignment() {
        CTPPr pr = this.getCTPPr();
        return pr == null || !pr.isSetTextAlignment() ? TextAlignment.AUTO : TextAlignment.valueOf(pr.getTextAlignment().getVal().intValue());
    }

    public void setVerticalAlignment(TextAlignment valign) {
        CTPPr pr = this.getCTPPr();
        CTTextAlignment textAlignment = pr.isSetTextAlignment() ? pr.getTextAlignment() : pr.addNewTextAlignment();
        STTextAlignment.Enum en2 = STTextAlignment.Enum.forInt(valign.getValue());
        textAlignment.setVal(en2);
    }

    public Borders getBorderTop() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct2 = null;
        if (border != null) {
            ct2 = border.getTop();
        }
        STBorder.Enum ptrn = ct2 != null ? ct2.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setBorderTop(Borders border) {
        CTBorder pr;
        CTPBdr ct2 = this.getCTPBrd(true);
        if (ct2 == null) {
            throw new RuntimeException("invalid paragraph state");
        }
        CTBorder cTBorder = pr = ct2.isSetTop() ? ct2.getTop() : ct2.addNewTop();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct2.unsetTop();
        } else {
            pr.setVal(STBorder.Enum.forInt(border.getValue()));
        }
    }

    public Borders getBorderBottom() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct2 = null;
        if (border != null) {
            ct2 = border.getBottom();
        }
        STBorder.Enum ptrn = ct2 != null ? ct2.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setBorderBottom(Borders border) {
        CTBorder pr;
        CTPBdr ct2 = this.getCTPBrd(true);
        CTBorder cTBorder = pr = ct2.isSetBottom() ? ct2.getBottom() : ct2.addNewBottom();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct2.unsetBottom();
        } else {
            pr.setVal(STBorder.Enum.forInt(border.getValue()));
        }
    }

    public Borders getBorderLeft() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct2 = null;
        if (border != null) {
            ct2 = border.getLeft();
        }
        STBorder.Enum ptrn = ct2 != null ? ct2.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setBorderLeft(Borders border) {
        CTBorder pr;
        CTPBdr ct2 = this.getCTPBrd(true);
        CTBorder cTBorder = pr = ct2.isSetLeft() ? ct2.getLeft() : ct2.addNewLeft();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct2.unsetLeft();
        } else {
            pr.setVal(STBorder.Enum.forInt(border.getValue()));
        }
    }

    public Borders getBorderRight() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct2 = null;
        if (border != null) {
            ct2 = border.getRight();
        }
        STBorder.Enum ptrn = ct2 != null ? ct2.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setBorderRight(Borders border) {
        CTBorder pr;
        CTPBdr ct2 = this.getCTPBrd(true);
        CTBorder cTBorder = pr = ct2.isSetRight() ? ct2.getRight() : ct2.addNewRight();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct2.unsetRight();
        } else {
            pr.setVal(STBorder.Enum.forInt(border.getValue()));
        }
    }

    public Borders getBorderBetween() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct2 = null;
        if (border != null) {
            ct2 = border.getBetween();
        }
        STBorder.Enum ptrn = ct2 != null ? ct2.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setBorderBetween(Borders border) {
        CTBorder pr;
        CTPBdr ct2 = this.getCTPBrd(true);
        CTBorder cTBorder = pr = ct2.isSetBetween() ? ct2.getBetween() : ct2.addNewBetween();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct2.unsetBetween();
        } else {
            pr.setVal(STBorder.Enum.forInt(border.getValue()));
        }
    }

    public boolean isPageBreak() {
        CTOnOff ct_pageBreak;
        CTPPr ppr = this.getCTPPr();
        CTOnOff cTOnOff = ct_pageBreak = ppr.isSetPageBreakBefore() ? ppr.getPageBreakBefore() : null;
        return ct_pageBreak != null && ct_pageBreak.getVal().intValue() == 1;
    }

    public void setPageBreak(boolean pageBreak) {
        CTOnOff ct_pageBreak;
        CTPPr ppr = this.getCTPPr();
        CTOnOff cTOnOff = ct_pageBreak = ppr.isSetPageBreakBefore() ? ppr.getPageBreakBefore() : ppr.addNewPageBreakBefore();
        if (pageBreak) {
            ct_pageBreak.setVal(STOnOff.TRUE);
        } else {
            ct_pageBreak.setVal(STOnOff.FALSE);
        }
    }

    public int getSpacingAfter() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetAfter() ? spacing.getAfter().intValue() : -1;
    }

    public void setSpacingAfter(int spaces) {
        CTSpacing spacing = this.getCTSpacing(true);
        if (spacing != null) {
            BigInteger bi2 = new BigInteger("" + spaces);
            spacing.setAfter(bi2);
        }
    }

    public int getSpacingAfterLines() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetAfterLines() ? spacing.getAfterLines().intValue() : -1;
    }

    public void setSpacingAfterLines(int spaces) {
        CTSpacing spacing = this.getCTSpacing(true);
        BigInteger bi2 = new BigInteger("" + spaces);
        spacing.setAfterLines(bi2);
    }

    public int getSpacingBefore() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetBefore() ? spacing.getBefore().intValue() : -1;
    }

    public void setSpacingBefore(int spaces) {
        CTSpacing spacing = this.getCTSpacing(true);
        BigInteger bi2 = new BigInteger("" + spaces);
        spacing.setBefore(bi2);
    }

    public int getSpacingBeforeLines() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetBeforeLines() ? spacing.getBeforeLines().intValue() : -1;
    }

    public void setSpacingBeforeLines(int spaces) {
        CTSpacing spacing = this.getCTSpacing(true);
        BigInteger bi2 = new BigInteger("" + spaces);
        spacing.setBeforeLines(bi2);
    }

    public LineSpacingRule getSpacingLineRule() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetLineRule() ? LineSpacingRule.valueOf(spacing.getLineRule().intValue()) : LineSpacingRule.AUTO;
    }

    public void setSpacingLineRule(LineSpacingRule rule) {
        CTSpacing spacing = this.getCTSpacing(true);
        spacing.setLineRule(STLineSpacingRule.Enum.forInt(rule.getValue()));
    }

    public int getIndentationLeft() {
        CTInd indentation = this.getCTInd(false);
        return indentation != null && indentation.isSetLeft() ? indentation.getLeft().intValue() : -1;
    }

    public void setIndentationLeft(int indentation) {
        CTInd indent = this.getCTInd(true);
        BigInteger bi2 = new BigInteger("" + indentation);
        indent.setLeft(bi2);
    }

    public int getIndentationRight() {
        CTInd indentation = this.getCTInd(false);
        return indentation != null && indentation.isSetRight() ? indentation.getRight().intValue() : -1;
    }

    public void setIndentationRight(int indentation) {
        CTInd indent = this.getCTInd(true);
        BigInteger bi2 = new BigInteger("" + indentation);
        indent.setRight(bi2);
    }

    public int getIndentationHanging() {
        CTInd indentation = this.getCTInd(false);
        return indentation != null && indentation.isSetHanging() ? indentation.getHanging().intValue() : -1;
    }

    public void setIndentationHanging(int indentation) {
        CTInd indent = this.getCTInd(true);
        BigInteger bi2 = new BigInteger("" + indentation);
        indent.setHanging(bi2);
    }

    public int getIndentationFirstLine() {
        CTInd indentation = this.getCTInd(false);
        return indentation != null && indentation.isSetFirstLine() ? indentation.getFirstLine().intValue() : -1;
    }

    public void setIndentationFirstLine(int indentation) {
        CTInd indent = this.getCTInd(true);
        BigInteger bi2 = new BigInteger("" + indentation);
        indent.setFirstLine(bi2);
    }

    @Override
    public int getIndentFromLeft() {
        return this.getIndentationLeft();
    }

    @Override
    public void setIndentFromLeft(int dxaLeft) {
        this.setIndentationLeft(dxaLeft);
    }

    @Override
    public int getIndentFromRight() {
        return this.getIndentationRight();
    }

    @Override
    public void setIndentFromRight(int dxaRight) {
        this.setIndentationRight(dxaRight);
    }

    @Override
    public int getFirstLineIndent() {
        return this.getIndentationFirstLine();
    }

    @Override
    public void setFirstLineIndent(int first) {
        this.setIndentationFirstLine(first);
    }

    @Override
    public boolean isWordWrapped() {
        CTOnOff wordWrap;
        CTOnOff cTOnOff = wordWrap = this.getCTPPr().isSetWordWrap() ? this.getCTPPr().getWordWrap() : null;
        if (wordWrap != null) {
            return wordWrap.getVal() == STOnOff.ON || wordWrap.getVal() == STOnOff.TRUE || wordWrap.getVal() == STOnOff.X_1;
        }
        return false;
    }

    @Override
    public void setWordWrapped(boolean wrap) {
        CTOnOff wordWrap;
        CTOnOff cTOnOff = wordWrap = this.getCTPPr().isSetWordWrap() ? this.getCTPPr().getWordWrap() : this.getCTPPr().addNewWordWrap();
        if (wrap) {
            wordWrap.setVal(STOnOff.TRUE);
        } else {
            wordWrap.unsetVal();
        }
    }

    public boolean isWordWrap() {
        return this.isWordWrapped();
    }

    @Deprecated
    public void setWordWrap(boolean wrap) {
        this.setWordWrapped(wrap);
    }

    public String getStyle() {
        CTPPr pr = this.getCTPPr();
        CTString style = pr.isSetPStyle() ? pr.getPStyle() : null;
        return style != null ? style.getVal() : null;
    }

    public void setStyle(String newStyle) {
        CTPPr pr = this.getCTPPr();
        CTString style = pr.getPStyle() != null ? pr.getPStyle() : pr.addNewPStyle();
        style.setVal(newStyle);
    }

    private CTPBdr getCTPBrd(boolean create) {
        CTPBdr ct2;
        CTPPr pr = this.getCTPPr();
        CTPBdr cTPBdr = ct2 = pr.isSetPBdr() ? pr.getPBdr() : null;
        if (create && ct2 == null) {
            ct2 = pr.addNewPBdr();
        }
        return ct2;
    }

    private CTSpacing getCTSpacing(boolean create) {
        CTSpacing ct2;
        CTPPr pr = this.getCTPPr();
        CTSpacing cTSpacing = ct2 = pr.getSpacing() == null ? null : pr.getSpacing();
        if (create && ct2 == null) {
            ct2 = pr.addNewSpacing();
        }
        return ct2;
    }

    private CTInd getCTInd(boolean create) {
        CTInd ct2;
        CTPPr pr = this.getCTPPr();
        CTInd cTInd = ct2 = pr.getInd() == null ? null : pr.getInd();
        if (create && ct2 == null) {
            ct2 = pr.addNewInd();
        }
        return ct2;
    }

    private CTPPr getCTPPr() {
        CTPPr pr = this.paragraph.getPPr() == null ? this.paragraph.addNewPPr() : this.paragraph.getPPr();
        return pr;
    }

    protected void addRun(CTR run) {
        int pos = this.paragraph.sizeOfRArray();
        this.paragraph.addNewR();
        this.paragraph.setRArray(pos, run);
    }

    public XWPFRun createRun() {
        XWPFRun xwpfRun = new XWPFRun(this.paragraph.addNewR(), (IRunBody)this);
        this.runs.add(xwpfRun);
        this.iruns.add(xwpfRun);
        return xwpfRun;
    }

    public XWPFRun insertNewRun(int pos) {
        if (pos >= 0 && pos <= this.runs.size()) {
            XWPFRun oldAtPos;
            int oldAt;
            int rPos = 0;
            for (int i2 = 0; i2 < pos; ++i2) {
                XWPFRun currRun = this.runs.get(i2);
                if (currRun instanceof XWPFHyperlinkRun || currRun instanceof XWPFFieldRun) continue;
                ++rPos;
            }
            CTR ctRun = this.paragraph.insertNewR(rPos);
            XWPFRun newRun = new XWPFRun(ctRun, (IRunBody)this);
            int iPos = this.iruns.size();
            if (pos < this.runs.size() && (oldAt = this.iruns.indexOf(oldAtPos = this.runs.get(pos))) != -1) {
                iPos = oldAt;
            }
            this.iruns.add(iPos, newRun);
            this.runs.add(pos, newRun);
            return newRun;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextSegement searchText(String searched, PositionInParagraph startPos) {
        int startRun = startPos.getRun();
        int startText = startPos.getText();
        int startChar = startPos.getChar();
        int beginRunPos = 0;
        int candCharPos = 0;
        boolean newList = false;
        CTR[] rArray = this.paragraph.getRArray();
        for (int runPos = startRun; runPos < rArray.length; ++runPos) {
            int beginTextPos = 0;
            int beginCharPos = 0;
            int textPos = 0;
            int charPos = 0;
            CTR ctRun = rArray[runPos];
            XmlCursor c2 = ctRun.newCursor();
            c2.selectPath("./*");
            try {
                while (c2.toNextSelection()) {
                    XmlObject o2 = c2.getObject();
                    if (o2 instanceof CTText) {
                        if (textPos >= startText) {
                            String candidate = ((CTText)o2).getStringValue();
                            for (charPos = runPos == startRun ? startChar : 0; charPos < candidate.length(); ++charPos) {
                                if (candidate.charAt(charPos) == searched.charAt(0) && candCharPos == 0) {
                                    beginTextPos = textPos;
                                    beginCharPos = charPos;
                                    beginRunPos = runPos;
                                    newList = true;
                                }
                                if (candidate.charAt(charPos) == searched.charAt(candCharPos)) {
                                    if (candCharPos + 1 < searched.length()) {
                                        ++candCharPos;
                                        continue;
                                    }
                                    if (!newList) continue;
                                    TextSegement segement = new TextSegement();
                                    segement.setBeginRun(beginRunPos);
                                    segement.setBeginText(beginTextPos);
                                    segement.setBeginChar(beginCharPos);
                                    segement.setEndRun(runPos);
                                    segement.setEndText(textPos);
                                    segement.setEndChar(charPos);
                                    TextSegement textSegement = segement;
                                    return textSegement;
                                }
                                candCharPos = 0;
                            }
                        }
                        ++textPos;
                        continue;
                    }
                    if (o2 instanceof CTProofErr) {
                        c2.removeXml();
                        continue;
                    }
                    if (o2 instanceof CTRPr) continue;
                    candCharPos = 0;
                }
                continue;
            }
            finally {
                c2.dispose();
            }
        }
        return null;
    }

    public String getText(TextSegement segment) {
        int runBegin = segment.getBeginRun();
        int textBegin = segment.getBeginText();
        int charBegin = segment.getBeginChar();
        int runEnd = segment.getEndRun();
        int textEnd = segment.getEndText();
        int charEnd = segment.getEndChar();
        StringBuilder out = new StringBuilder();
        CTR[] rArray = this.paragraph.getRArray();
        for (int i2 = runBegin; i2 <= runEnd; ++i2) {
            CTText[] tArray = rArray[i2].getTArray();
            int startText = 0;
            int endText = tArray.length - 1;
            if (i2 == runBegin) {
                startText = textBegin;
            }
            if (i2 == runEnd) {
                endText = textEnd;
            }
            for (int j2 = startText; j2 <= endText; ++j2) {
                String tmpText = tArray[j2].getStringValue();
                int startChar = 0;
                int endChar = tmpText.length() - 1;
                if (j2 == textBegin && i2 == runBegin) {
                    startChar = charBegin;
                }
                if (j2 == textEnd && i2 == runEnd) {
                    endChar = charEnd;
                }
                out.append(tmpText.substring(startChar, endChar + 1));
            }
        }
        return out.toString();
    }

    public boolean removeRun(int pos) {
        if (pos >= 0 && pos < this.runs.size()) {
            XWPFRun run = this.runs.get(pos);
            if (run instanceof XWPFHyperlinkRun || run instanceof XWPFFieldRun) {
                throw new IllegalArgumentException("Removing Field or Hyperlink runs not yet supported");
            }
            this.runs.remove(pos);
            this.iruns.remove(run);
            int rPos = 0;
            for (int i2 = 0; i2 < pos; ++i2) {
                XWPFRun currRun = this.runs.get(i2);
                if (currRun instanceof XWPFHyperlinkRun || currRun instanceof XWPFFieldRun) continue;
                ++rPos;
            }
            this.getCTP().removeR(rPos);
            return true;
        }
        return false;
    }

    @Override
    public BodyElementType getElementType() {
        return BodyElementType.PARAGRAPH;
    }

    @Override
    public IBody getBody() {
        return this.part;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        if (this.part != null) {
            return this.part.getPart();
        }
        return null;
    }

    @Override
    public BodyType getPartType() {
        return this.part.getPartType();
    }

    public void addRun(XWPFRun r2) {
        if (!this.runs.contains(r2)) {
            this.runs.add(r2);
        }
    }

    public XWPFRun getRun(CTR r2) {
        for (int i2 = 0; i2 < this.getRuns().size(); ++i2) {
            if (this.getRuns().get(i2).getCTR() != r2) continue;
            return this.getRuns().get(i2);
        }
        return null;
    }
}

