/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class EvilUnclosedBRFixingInputStream
extends InputStream {
    private InputStream source;
    private byte[] spare;
    private static byte[] detect = new byte[]{60, 98, 114, 62};

    public EvilUnclosedBRFixingInputStream(InputStream source) {
        this.source = source;
    }

    @Override
    public int read() throws IOException {
        return this.source.read();
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int read;
        int readA = this.readFromSpare(b2, off, len);
        int readB = this.source.read(b2, off + readA, len - readA);
        if (readB == -1 || readB == 0) {
            if (readA == 0) {
                return readB;
            }
            read = readA;
        } else {
            read = readA + readB;
        }
        if (read > 0) {
            read = this.fixUp(b2, off, read);
        }
        return read;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    private int readFromSpare(byte[] b2, int offset, int len) {
        if (this.spare == null) {
            return 0;
        }
        if (len == 0) {
            throw new IllegalArgumentException("Asked to read 0 bytes");
        }
        if (this.spare.length <= len) {
            System.arraycopy(this.spare, 0, b2, offset, this.spare.length);
            int read = this.spare.length;
            this.spare = null;
            return read;
        }
        byte[] newspare = new byte[this.spare.length - len];
        System.arraycopy(this.spare, 0, b2, offset, len);
        System.arraycopy(this.spare, len, newspare, 0, newspare.length);
        this.spare = newspare;
        return len;
    }

    private void addToSpare(byte[] b2, int offset, int len, boolean atTheEnd) {
        if (this.spare == null) {
            this.spare = new byte[len];
            System.arraycopy(b2, offset, this.spare, 0, len);
        } else {
            byte[] newspare = new byte[this.spare.length + len];
            if (atTheEnd) {
                System.arraycopy(this.spare, 0, newspare, 0, this.spare.length);
                System.arraycopy(b2, offset, newspare, this.spare.length, len);
            } else {
                System.arraycopy(b2, offset, newspare, 0, len);
                System.arraycopy(this.spare, 0, newspare, len, this.spare.length);
            }
            this.spare = newspare;
        }
    }

    private int fixUp(byte[] b2, int offset, int read) {
        int j2;
        boolean going;
        for (int i2 = 0; i2 < detect.length - 1; ++i2) {
            int base = offset + read - 1 - i2;
            if (base < 0) continue;
            going = true;
            for (j2 = 0; j2 <= i2 && going; ++j2) {
                if (b2[base + j2] == detect[j2]) continue;
                going = false;
            }
            if (!going) continue;
            this.addToSpare(b2, base, i2 + 1, true);
            --read;
            read -= i2;
            break;
        }
        ArrayList<Integer> fixAt = new ArrayList<Integer>();
        for (int i3 = offset; i3 <= offset + read - detect.length; ++i3) {
            going = true;
            for (j2 = 0; j2 < detect.length && going; ++j2) {
                if (b2[i3 + j2] == detect[j2]) continue;
                going = false;
            }
            if (!going) continue;
            fixAt.add(i3);
        }
        if (fixAt.size() == 0) {
            return read;
        }
        int needed = offset + read + fixAt.size();
        int overshoot = needed - b2.length;
        if (overshoot > 0) {
            int fixes = 0;
            Iterator i$ = fixAt.iterator();
            while (i$.hasNext()) {
                int at2 = (Integer)i$.next();
                if (at2 > offset + read - detect.length - overshoot - fixes) {
                    overshoot = needed - at2 - 1 - fixes;
                    break;
                }
                ++fixes;
            }
            this.addToSpare(b2, offset + read - overshoot, overshoot, false);
            read -= overshoot;
        }
        for (j2 = fixAt.size() - 1; j2 >= 0; --j2) {
            int i4 = (Integer)fixAt.get(j2);
            if (i4 >= read + offset || i4 > read - 3) continue;
            byte[] tmp = new byte[read - i4 - 3];
            System.arraycopy(b2, i4 + 3, tmp, 0, tmp.length);
            b2[i4 + 3] = 47;
            System.arraycopy(tmp, 0, b2, i4 + 4, tmp.length);
            ++read;
        }
        return read;
    }
}

