/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.helpers;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ptg.AreaErrPtg;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.helpers.RowShifter;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;

public final class XSSFRowShifter
extends RowShifter {
    private static final POILogger logger = POILogFactory.getLogger(XSSFRowShifter.class);

    public XSSFRowShifter(XSSFSheet sh) {
        super(sh);
    }

    public List<CellRangeAddress> shiftMerged(int startRow, int endRow, int n2) {
        return this.shiftMergedRegions(startRow, endRow, n2);
    }

    @Override
    public void updateNamedRanges(FormulaShifter shifter) {
        Workbook wb = this.sheet.getWorkbook();
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create((XSSFWorkbook)wb);
        for (Name name : wb.getAllNames()) {
            String formula = name.getRefersToFormula();
            int sheetIndex = name.getSheetIndex();
            int rowIndex = -1;
            Ptg[] ptgs = FormulaParser.parse(formula, fpb, FormulaType.NAMEDRANGE, sheetIndex, -1);
            if (!shifter.adjustFormula(ptgs, sheetIndex)) continue;
            String shiftedFmla = FormulaRenderer.toFormulaString(fpb, ptgs);
            name.setRefersToFormula(shiftedFmla);
        }
    }

    @Override
    public void updateFormulas(FormulaShifter shifter) {
        this.updateSheetFormulas(this.sheet, shifter);
        Workbook wb = this.sheet.getWorkbook();
        for (Sheet sh : wb) {
            if (this.sheet == sh) continue;
            this.updateSheetFormulas(sh, shifter);
        }
    }

    private void updateSheetFormulas(Sheet sh, FormulaShifter shifter) {
        for (Row r2 : sh) {
            XSSFRow row = (XSSFRow)r2;
            this.updateRowFormulas(row, shifter);
        }
    }

    @Override
    @Internal
    public void updateRowFormulas(Row row, FormulaShifter shifter) {
        XSSFSheet sheet = (XSSFSheet)row.getSheet();
        for (Cell c2 : row) {
            String ref;
            String shiftedRef;
            String shiftedFormula;
            XSSFCell cell = (XSSFCell)c2;
            CTCell ctCell = cell.getCTCell();
            if (!ctCell.isSetF()) continue;
            CTCellFormula f2 = ctCell.getF();
            String formula = f2.getStringValue();
            if (formula.length() > 0 && (shiftedFormula = XSSFRowShifter.shiftFormula(row, formula, shifter)) != null) {
                f2.setStringValue(shiftedFormula);
                if (f2.getT() == STCellFormulaType.SHARED) {
                    int si = (int)f2.getSi();
                    CTCellFormula sf = sheet.getSharedFormula(si);
                    sf.setStringValue(shiftedFormula);
                }
            }
            if (!f2.isSetRef() || (shiftedRef = XSSFRowShifter.shiftFormula(row, ref = f2.getRef(), shifter)) == null) continue;
            f2.setRef(shiftedRef);
        }
    }

    private static String shiftFormula(Row row, String formula, FormulaShifter shifter) {
        Sheet sheet = row.getSheet();
        Workbook wb = sheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(sheet);
        int rowIndex = row.getRowNum();
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create((XSSFWorkbook)wb);
        try {
            Ptg[] ptgs = FormulaParser.parse(formula, fpb, FormulaType.CELL, sheetIndex, rowIndex);
            String shiftedFmla = null;
            if (shifter.adjustFormula(ptgs, sheetIndex)) {
                shiftedFmla = FormulaRenderer.toFormulaString(fpb, ptgs);
            }
            return shiftedFmla;
        }
        catch (FormulaParseException fpe) {
            logger.log(5, "Error shifting formula on row ", row.getRowNum(), fpe);
            return formula;
        }
    }

    @Override
    public void updateConditionalFormatting(FormulaShifter shifter) {
        XSSFSheet xsheet = (XSSFSheet)this.sheet;
        XSSFWorkbook wb = xsheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(this.sheet);
        int rowIndex = -1;
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        CTWorksheet ctWorksheet = xsheet.getCTWorksheet();
        CTConditionalFormatting[] conditionalFormattingArray = ctWorksheet.getConditionalFormattingArray();
        for (int j2 = conditionalFormattingArray.length - 1; j2 >= 0; --j2) {
            CTConditionalFormatting cf2 = conditionalFormattingArray[j2];
            ArrayList<CellRangeAddress> cellRanges = new ArrayList<CellRangeAddress>();
            for (Object stRef : cf2.getSqref()) {
                String[] regions;
                for (String region : regions = stRef.toString().split(" ")) {
                    cellRanges.add(CellRangeAddress.valueOf(region));
                }
            }
            boolean changed = false;
            ArrayList<CellRangeAddress> temp = new ArrayList<CellRangeAddress>();
            for (CellRangeAddress craOld : cellRanges) {
                CellRangeAddress craNew = XSSFRowShifter.shiftRange(shifter, craOld, sheetIndex);
                if (craNew == null) {
                    changed = true;
                    continue;
                }
                temp.add(craNew);
                if (craNew == craOld) continue;
                changed = true;
            }
            if (changed) {
                int nRanges = temp.size();
                if (nRanges == 0) {
                    ctWorksheet.removeConditionalFormatting(j2);
                    continue;
                }
                ArrayList<String> refs = new ArrayList<String>();
                for (CellRangeAddress a2 : temp) {
                    refs.add(a2.formatAsString());
                }
                cf2.setSqref(refs);
            }
            for (CTCfRule cfRule : cf2.getCfRuleArray()) {
                String[] formulaArray = cfRule.getFormulaArray();
                for (int i2 = 0; i2 < formulaArray.length; ++i2) {
                    String formula = formulaArray[i2];
                    Ptg[] ptgs = FormulaParser.parse(formula, fpb, FormulaType.CELL, sheetIndex, -1);
                    if (!shifter.adjustFormula(ptgs, sheetIndex)) continue;
                    String shiftedFmla = FormulaRenderer.toFormulaString(fpb, ptgs);
                    cfRule.setFormulaArray(i2, shiftedFmla);
                }
            }
        }
    }

    @Override
    public void updateHyperlinks(FormulaShifter shifter) {
        int sheetIndex = this.sheet.getWorkbook().getSheetIndex(this.sheet);
        List<? extends Hyperlink> hyperlinkList = this.sheet.getHyperlinkList();
        for (Hyperlink hyperlink : hyperlinkList) {
            XSSFHyperlink xhyperlink = (XSSFHyperlink)hyperlink;
            String cellRef = xhyperlink.getCellRef();
            CellRangeAddress cra = CellRangeAddress.valueOf(cellRef);
            CellRangeAddress shiftedRange = XSSFRowShifter.shiftRange(shifter, cra, sheetIndex);
            if (shiftedRange == null || shiftedRange == cra) continue;
            xhyperlink.setCellReference(shiftedRange.formatAsString());
        }
    }

    private static CellRangeAddress shiftRange(FormulaShifter shifter, CellRangeAddress cra, int currentExternSheetIx) {
        AreaPtg aptg = new AreaPtg(cra.getFirstRow(), cra.getLastRow(), cra.getFirstColumn(), cra.getLastColumn(), false, false, false, false);
        Ptg[] ptgs = new Ptg[]{aptg};
        if (!shifter.adjustFormula(ptgs, currentExternSheetIx)) {
            return cra;
        }
        Ptg ptg0 = ptgs[0];
        if (ptg0 instanceof AreaPtg) {
            AreaPtg bptg = (AreaPtg)ptg0;
            return new CellRangeAddress(bptg.getFirstRow(), bptg.getLastRow(), bptg.getFirstColumn(), bptg.getLastColumn());
        }
        if (ptg0 instanceof AreaErrPtg) {
            return null;
        }
        throw new IllegalStateException("Unexpected shifted ptg class (" + ptg0.getClass().getName() + ")");
    }
}

