/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.ColorScaleFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormattingThreshold;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfvo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColorScale;

public class XSSFColorScaleFormatting
implements ColorScaleFormatting {
    CTColorScale _scale;

    XSSFColorScaleFormatting(CTColorScale scale) {
        this._scale = scale;
    }

    @Override
    public int getNumControlPoints() {
        return this._scale.sizeOfCfvoArray();
    }

    @Override
    public void setNumControlPoints(int num) {
        while (num < this._scale.sizeOfCfvoArray()) {
            this._scale.removeCfvo(this._scale.sizeOfCfvoArray() - 1);
            this._scale.removeColor(this._scale.sizeOfColorArray() - 1);
        }
        while (num > this._scale.sizeOfCfvoArray()) {
            this._scale.addNewCfvo();
            this._scale.addNewColor();
        }
    }

    public XSSFColor[] getColors() {
        CTColor[] ctcols = this._scale.getColorArray();
        XSSFColor[] c2 = new XSSFColor[ctcols.length];
        for (int i2 = 0; i2 < ctcols.length; ++i2) {
            c2[i2] = new XSSFColor(ctcols[i2]);
        }
        return c2;
    }

    @Override
    public void setColors(Color[] colors) {
        CTColor[] ctcols = new CTColor[colors.length];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            ctcols[i2] = ((XSSFColor)colors[i2]).getCTColor();
        }
        this._scale.setColorArray(ctcols);
    }

    public XSSFConditionalFormattingThreshold[] getThresholds() {
        CTCfvo[] cfvos = this._scale.getCfvoArray();
        XSSFConditionalFormattingThreshold[] t2 = new XSSFConditionalFormattingThreshold[cfvos.length];
        for (int i2 = 0; i2 < cfvos.length; ++i2) {
            t2[i2] = new XSSFConditionalFormattingThreshold(cfvos[i2]);
        }
        return t2;
    }

    @Override
    public void setThresholds(ConditionalFormattingThreshold[] thresholds) {
        CTCfvo[] cfvos = new CTCfvo[thresholds.length];
        for (int i2 = 0; i2 < thresholds.length; ++i2) {
            cfvos[i2] = ((XSSFConditionalFormattingThreshold)thresholds[i2]).getCTCfvo();
        }
        this._scale.setCfvoArray(cfvos);
    }

    public XSSFColor createColor() {
        return new XSSFColor(this._scale.addNewColor());
    }

    @Override
    public XSSFConditionalFormattingThreshold createThreshold() {
        return new XSSFConditionalFormattingThreshold(this._scale.addNewCfvo());
    }
}

