/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.util.Internal;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComments;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CommentsDocument;

@Internal
public class CommentsTable
extends POIXMLDocumentPart {
    public static final String DEFAULT_AUTHOR = "";
    public static final int DEFAULT_AUTHOR_ID = 0;
    private CTComments comments;
    private Map<CellAddress, CTComment> commentRefs;

    public CommentsTable() {
        this.comments = CTComments.Factory.newInstance();
        this.comments.addNewCommentList();
        this.comments.addNewAuthors().addAuthor(DEFAULT_AUTHOR);
    }

    public CommentsTable(PackagePart part) throws IOException {
        super(part);
        this.readFrom(part.getInputStream());
    }

    @Deprecated
    public CommentsTable(PackagePart part, PackageRelationship rel) throws IOException {
        this(part);
    }

    public void readFrom(InputStream is2) throws IOException {
        try {
            CommentsDocument doc = CommentsDocument.Factory.parse(is2, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            this.comments = doc.getComments();
        }
        catch (XmlException e2) {
            throw new IOException(e2.getLocalizedMessage());
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        CommentsDocument doc = CommentsDocument.Factory.newInstance();
        doc.setComments(this.comments);
        doc.save(out, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    public void referenceUpdated(String oldReference, CTComment comment) {
        this.referenceUpdated(new CellAddress(oldReference), comment);
    }

    public void referenceUpdated(CellAddress oldReference, CTComment comment) {
        if (this.commentRefs != null) {
            this.commentRefs.remove(oldReference);
            this.commentRefs.put(new CellAddress(comment.getRef()), comment);
        }
    }

    public int getNumberOfComments() {
        return this.comments.getCommentList().sizeOfCommentArray();
    }

    public int getNumberOfAuthors() {
        return this.comments.getAuthors().sizeOfAuthorArray();
    }

    public String getAuthor(long authorId) {
        return this.comments.getAuthors().getAuthorArray((int)authorId);
    }

    public int findAuthor(String author) {
        String[] authorArray = this.comments.getAuthors().getAuthorArray();
        for (int i2 = 0; i2 < authorArray.length; ++i2) {
            if (!authorArray[i2].equals(author)) continue;
            return i2;
        }
        return this.addNewAuthor(author);
    }

    public XSSFComment findCellComment(String cellRef) {
        return this.findCellComment(new CellAddress(cellRef));
    }

    public XSSFComment findCellComment(CellAddress cellAddress) {
        CTComment ct2 = this.getCTComment(cellAddress);
        return ct2 == null ? null : new XSSFComment(this, ct2, null);
    }

    @Internal
    public CTComment getCTComment(String ref) {
        return this.getCTComment(new CellAddress(ref));
    }

    @Internal
    public CTComment getCTComment(CellAddress cellRef) {
        this.prepareCTCommentCache();
        return this.commentRefs.get(cellRef);
    }

    public Map<CellAddress, XSSFComment> getCellComments() {
        this.prepareCTCommentCache();
        TreeMap<CellAddress, XSSFComment> map = new TreeMap<CellAddress, XSSFComment>();
        for (Map.Entry<CellAddress, CTComment> e2 : this.commentRefs.entrySet()) {
            map.put(e2.getKey(), new XSSFComment(this, e2.getValue(), null));
        }
        return map;
    }

    private void prepareCTCommentCache() {
        if (this.commentRefs == null) {
            this.commentRefs = new HashMap<CellAddress, CTComment>();
            for (CTComment comment : this.comments.getCommentList().getCommentArray()) {
                this.commentRefs.put(new CellAddress(comment.getRef()), comment);
            }
        }
    }

    @Internal
    public CTComment newComment(String ref) {
        return this.newComment(new CellAddress(ref));
    }

    @Internal
    public CTComment newComment(CellAddress ref) {
        CTComment ct2 = this.comments.getCommentList().addNewComment();
        ct2.setRef(ref.formatAsString());
        ct2.setAuthorId(0L);
        if (this.commentRefs != null) {
            this.commentRefs.put(ref, ct2);
        }
        return ct2;
    }

    public boolean removeComment(String cellRef) {
        return this.removeComment(new CellAddress(cellRef));
    }

    public boolean removeComment(CellAddress cellRef) {
        String stringRef = cellRef.formatAsString();
        CTCommentList lst = this.comments.getCommentList();
        if (lst != null) {
            CTComment[] commentArray = lst.getCommentArray();
            for (int i2 = 0; i2 < commentArray.length; ++i2) {
                CTComment comment = commentArray[i2];
                if (!stringRef.equals(comment.getRef())) continue;
                lst.removeComment(i2);
                if (this.commentRefs != null) {
                    this.commentRefs.remove(cellRef);
                }
                return true;
            }
        }
        return false;
    }

    private int addNewAuthor(String author) {
        int index = this.comments.getAuthors().sizeOfAuthorArray();
        this.comments.getAuthors().insertAuthor(index, author);
        return index;
    }

    @Internal
    public CTComments getCTComments() {
        return this.comments;
    }
}

