/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.io.IOException;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawSlide;
import org.apache.poi.sl.usermodel.Notes;
import org.apache.poi.sl.usermodel.Placeholder;
import org.apache.poi.sl.usermodel.Slide;
import org.apache.poi.util.DocumentHelper;
import org.apache.poi.util.NotImplemented;
import org.apache.poi.xslf.usermodel.XSLFBackground;
import org.apache.poi.xslf.usermodel.XSLFComments;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShapeNonVisual;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.SldDocument;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XSLFSlide
extends XSLFSheet
implements Slide<XSLFShape, XSLFTextParagraph> {
    private final CTSlide _slide;
    private XSLFSlideLayout _layout;
    private XSLFComments _comments;
    private XSLFNotes _notes;

    XSLFSlide() {
        this._slide = XSLFSlide.prototype();
        this.setCommonSlideData(this._slide.getCSld());
    }

    XSLFSlide(PackagePart part) throws IOException, XmlException {
        super(part);
        Document _doc;
        try {
            _doc = DocumentHelper.readDocument(this.getPackagePart().getInputStream());
        }
        catch (SAXException e2) {
            throw new IOException(e2);
        }
        SldDocument doc = SldDocument.Factory.parse(_doc, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        this._slide = doc.getSld();
        this.setCommonSlideData(this._slide.getCSld());
    }

    @Deprecated
    XSLFSlide(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        this(part);
    }

    private static CTSlide prototype() {
        CTSlide ctSlide = CTSlide.Factory.newInstance();
        CTCommonSlideData cSld = ctSlide.addNewCSld();
        CTGroupShape spTree = cSld.addNewSpTree();
        CTGroupShapeNonVisual nvGrpSpPr = spTree.addNewNvGrpSpPr();
        CTNonVisualDrawingProps cnvPr = nvGrpSpPr.addNewCNvPr();
        cnvPr.setId(1L);
        cnvPr.setName("");
        nvGrpSpPr.addNewCNvGrpSpPr();
        nvGrpSpPr.addNewNvPr();
        CTGroupShapeProperties grpSpr = spTree.addNewGrpSpPr();
        CTGroupTransform2D xfrm = grpSpr.addNewXfrm();
        CTPoint2D off = xfrm.addNewOff();
        off.setX(0L);
        off.setY(0L);
        CTPositiveSize2D ext = xfrm.addNewExt();
        ext.setCx(0L);
        ext.setCy(0L);
        CTPoint2D choff = xfrm.addNewChOff();
        choff.setX(0L);
        choff.setY(0L);
        CTPositiveSize2D chExt = xfrm.addNewChExt();
        chExt.setCx(0L);
        chExt.setCy(0L);
        ctSlide.addNewClrMapOvr().addNewMasterClrMapping();
        return ctSlide;
    }

    @Override
    public CTSlide getXmlObject() {
        return this._slide;
    }

    @Override
    protected String getRootElementName() {
        return "sld";
    }

    public XSLFSlideLayout getMasterSheet() {
        return this.getSlideLayout();
    }

    public XSLFSlideLayout getSlideLayout() {
        if (this._layout == null) {
            for (POIXMLDocumentPart p2 : this.getRelations()) {
                if (!(p2 instanceof XSLFSlideLayout)) continue;
                this._layout = (XSLFSlideLayout)p2;
            }
        }
        if (this._layout == null) {
            throw new IllegalArgumentException("SlideLayout was not found for " + this.toString());
        }
        return this._layout;
    }

    public XSLFSlideMaster getSlideMaster() {
        return this.getSlideLayout().getSlideMaster();
    }

    public XSLFComments getComments() {
        if (this._comments == null) {
            for (POIXMLDocumentPart p2 : this.getRelations()) {
                if (!(p2 instanceof XSLFComments)) continue;
                this._comments = (XSLFComments)p2;
            }
        }
        if (this._comments == null) {
            return null;
        }
        return this._comments;
    }

    public XSLFNotes getNotes() {
        if (this._notes == null) {
            for (POIXMLDocumentPart p2 : this.getRelations()) {
                if (!(p2 instanceof XSLFNotes)) continue;
                this._notes = (XSLFNotes)p2;
            }
        }
        if (this._notes == null) {
            return null;
        }
        return this._notes;
    }

    @Override
    public String getTitle() {
        XSLFTextShape txt = this.getTextShapeByType(Placeholder.TITLE);
        return txt == null ? null : txt.getText();
    }

    @Override
    public XSLFTheme getTheme() {
        return this.getSlideLayout().getSlideMaster().getTheme();
    }

    @Override
    public XSLFBackground getBackground() {
        CTBackground bg2 = this._slide.getCSld().getBg();
        if (bg2 != null) {
            return new XSLFBackground(bg2, (XSLFSheet)this);
        }
        return this.getMasterSheet().getBackground();
    }

    @Override
    public boolean getFollowMasterGraphics() {
        return this._slide.isSetShowMasterSp() && this._slide.getShowMasterSp();
    }

    public void setFollowMasterGraphics(boolean value) {
        this._slide.setShowMasterSp(value);
    }

    @Override
    public boolean getFollowMasterObjects() {
        return this.getFollowMasterGraphics();
    }

    @Override
    public void setFollowMasterObjects(boolean follow) {
        this.setFollowMasterGraphics(follow);
    }

    @Override
    public XSLFSlide importContent(XSLFSheet src) {
        CTBackground bg2;
        super.importContent(src);
        XSLFBackground bgShape = this.getBackground();
        if (bgShape != null && (bg2 = (CTBackground)bgShape.getXmlObject()).isSetBgPr() && bg2.getBgPr().isSetBlipFill()) {
            CTBlip blip = bg2.getBgPr().getBlipFill().getBlip();
            String blipId = blip.getEmbed();
            String relId = this.importBlip(blipId, src.getPackagePart());
            blip.setEmbed(relId);
        }
        return this;
    }

    @Override
    public boolean getFollowMasterBackground() {
        return false;
    }

    @Override
    @NotImplemented
    public void setFollowMasterBackground(boolean follow) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getFollowMasterColourScheme() {
        return false;
    }

    @Override
    @NotImplemented
    public void setFollowMasterColourScheme(boolean follow) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotImplemented
    public void setNotes(Notes<XSLFShape, XSLFTextParagraph> notes) {
        assert (notes instanceof XSLFNotes);
    }

    @Override
    public int getSlideNumber() {
        int idx = this.getSlideShow().getSlides().indexOf(this);
        return idx == -1 ? idx : idx + 1;
    }

    @Override
    public void draw(Graphics2D graphics) {
        DrawFactory drawFact = DrawFactory.getInstance(graphics);
        DrawSlide draw = drawFact.getDrawable(this);
        draw.draw(graphics);
    }
}

