/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.xslf.usermodel.DrawingParagraph;
import org.apache.poi.xslf.usermodel.DrawingTable;
import org.apache.poi.xslf.usermodel.DrawingTableCell;
import org.apache.poi.xslf.usermodel.DrawingTableRow;
import org.apache.poi.xslf.usermodel.DrawingTextBody;
import org.apache.poi.xslf.usermodel.DrawingTextPlaceholder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

public class XSLFCommonSlideData {
    private final CTCommonSlideData data;

    public XSLFCommonSlideData(CTCommonSlideData data) {
        this.data = data;
    }

    public List<DrawingTextBody> getDrawingText() {
        CTGroupShape gs2 = this.data.getSpTree();
        ArrayList<DrawingTextBody> out = new ArrayList<DrawingTextBody>();
        this.processShape(gs2, out);
        for (CTGroupShape cTGroupShape : gs2.getGrpSpArray()) {
            this.processShape(cTGroupShape, out);
        }
        for (XmlObject xmlObject : gs2.getGraphicFrameArray()) {
            CTGraphicalObjectData data = xmlObject.getGraphic().getGraphicData();
            XmlCursor c2 = data.newCursor();
            c2.selectPath("declare namespace pic='" + CTTable.type.getName().getNamespaceURI() + "' .//pic:tbl");
            while (c2.toNextSelection()) {
                XmlObject o2 = c2.getObject();
                if (o2 instanceof XmlAnyTypeImpl) {
                    try {
                        o2 = CTTable.Factory.parse(o2.toString(), POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
                    }
                    catch (XmlException e2) {
                        throw new POIXMLException(e2);
                    }
                }
                if (!(o2 instanceof CTTable)) continue;
                DrawingTable table = new DrawingTable((CTTable)o2);
                for (DrawingTableRow row : table.getRows()) {
                    for (DrawingTableCell cell : row.getCells()) {
                        DrawingTextBody textBody = cell.getTextBody();
                        out.add(textBody);
                    }
                }
            }
            c2.dispose();
        }
        return out;
    }

    public List<DrawingParagraph> getText() {
        ArrayList<DrawingParagraph> paragraphs = new ArrayList<DrawingParagraph>();
        for (DrawingTextBody textBody : this.getDrawingText()) {
            paragraphs.addAll(Arrays.asList(textBody.getParagraphs()));
        }
        return paragraphs;
    }

    private void processShape(CTGroupShape gs2, List<DrawingTextBody> out) {
        for (CTShape shape : gs2.getSpArray()) {
            CTTextBody ctTextBody = shape.getTxBody();
            if (ctTextBody == null) continue;
            CTApplicationNonVisualDrawingProps nvpr = shape.getNvSpPr().getNvPr();
            DrawingTextBody textBody = nvpr.isSetPh() ? new DrawingTextPlaceholder(ctTextBody, nvpr.getPh()) : new DrawingTextBody(ctTextBody);
            out.add(textBody);
        }
    }
}

