/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import org.apache.poi.sl.usermodel.AutoShape;
import org.apache.poi.xslf.usermodel.XSLFFreeformShape;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTextBox;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAlignType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShapeNonVisual;

public class XSLFAutoShape
extends XSLFTextShape
implements AutoShape<XSLFShape, XSLFTextParagraph> {
    XSLFAutoShape(CTShape shape, XSLFSheet sheet) {
        super(shape, sheet);
    }

    static XSLFAutoShape create(CTShape shape, XSLFSheet sheet) {
        if (shape.getSpPr().isSetCustGeom()) {
            return new XSLFFreeformShape(shape, sheet);
        }
        if (shape.getNvSpPr().getCNvSpPr().isSetTxBox()) {
            return new XSLFTextBox(shape, sheet);
        }
        return new XSLFAutoShape(shape, sheet);
    }

    static CTShape prototype(int shapeId) {
        CTShape ct2 = CTShape.Factory.newInstance();
        CTShapeNonVisual nvSpPr = ct2.addNewNvSpPr();
        CTNonVisualDrawingProps cnv = nvSpPr.addNewCNvPr();
        cnv.setName("AutoShape " + shapeId);
        cnv.setId(shapeId + 1);
        nvSpPr.addNewCNvSpPr();
        nvSpPr.addNewNvPr();
        CTShapeProperties spPr = ct2.addNewSpPr();
        CTPresetGeometry2D prst = spPr.addNewPrstGeom();
        prst.setPrst(STShapeType.RECT);
        prst.addNewAvLst();
        return ct2;
    }

    protected static void initTextBody(CTTextBody txBody) {
        CTTextBodyProperties bodypr = txBody.addNewBodyPr();
        bodypr.setAnchor(STTextAnchoringType.T);
        bodypr.setRtlCol(false);
        CTTextParagraph p2 = txBody.addNewP();
        p2.addNewPPr().setAlgn(STTextAlignType.L);
        CTTextCharacterProperties endPr = p2.addNewEndParaRPr();
        endPr.setLang("en-US");
        endPr.setSz(1100);
        p2.addNewR().setT("");
        txBody.addNewLstStyle();
    }

    @Override
    protected CTTextBody getTextBody(boolean create) {
        CTShape shape = (CTShape)this.getXmlObject();
        CTTextBody txBody = shape.getTxBody();
        if (txBody == null && create) {
            txBody = shape.addNewTxBody();
            XSLFAutoShape.initTextBody(txBody);
        }
        return txBody;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] " + this.getShapeName();
    }
}

