/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xdgf.usermodel.section.geometry;

import com.microsoft.schemas.office.visio.x2012.main.CellType;
import com.microsoft.schemas.office.visio.x2012.main.RowType;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.apache.poi.POIXMLException;
import org.apache.poi.xdgf.usermodel.XDGFCell;
import org.apache.poi.xdgf.usermodel.XDGFShape;
import org.apache.poi.xdgf.usermodel.section.geometry.GeometryRow;

public class ArcTo
implements GeometryRow {
    ArcTo _master = null;
    Double x = null;
    Double y = null;
    Double a = null;
    Boolean deleted = null;

    public ArcTo(RowType row) {
        if (row.isSetDel()) {
            this.deleted = row.getDel();
        }
        for (CellType cell : row.getCellArray()) {
            String cellName = cell.getN();
            if (cellName.equals("X")) {
                this.x = XDGFCell.parseDoubleValue(cell);
                continue;
            }
            if (cellName.equals("Y")) {
                this.y = XDGFCell.parseDoubleValue(cell);
                continue;
            }
            if (cellName.equals("A")) {
                this.a = XDGFCell.parseDoubleValue(cell);
                continue;
            }
            throw new POIXMLException("Invalid cell '" + cellName + "' in ArcTo row");
        }
    }

    public boolean getDel() {
        if (this.deleted != null) {
            return this.deleted;
        }
        if (this._master != null) {
            return this._master.getDel();
        }
        return false;
    }

    public Double getX() {
        return this.x == null ? this._master.x : this.x;
    }

    public Double getY() {
        return this.y == null ? this._master.y : this.y;
    }

    public Double getA() {
        return this.a == null ? this._master.a : this.a;
    }

    @Override
    public void setupMaster(GeometryRow row) {
        this._master = (ArcTo)row;
    }

    @Override
    public void addToPath(Path2D.Double path, XDGFShape parent) {
        if (this.getDel()) {
            return;
        }
        Point2D last = path.getCurrentPoint();
        double x2 = this.getX();
        double y2 = this.getY();
        double a2 = this.getA();
        if (a2 == 0.0) {
            path.lineTo(x2, y2);
            return;
        }
        double x0 = last.getX();
        double y0 = last.getY();
        double chordLength = Math.hypot(y2 - y0, x2 - x0);
        double radius = (4.0 * a2 * a2 + chordLength * chordLength) / (8.0 * Math.abs(a2));
        double cx2 = x0 + (x2 - x0) / 2.0;
        double cy2 = y0 + (y2 - y0) / 2.0;
        double rotate = Math.atan2(y2 - cy2, x2 - cx2);
        Arc2D.Double arc = new Arc2D.Double(x0, y0 - radius, chordLength, 2.0 * radius, 180.0, x0 < x2 ? 180.0 : -180.0, 0);
        path.append(AffineTransform.getRotateInstance(rotate, x0, y0).createTransformedShape(arc), true);
    }
}

