/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import org.apache.poi.util.DelayableLittleEndianOutput;
import org.apache.poi.util.LittleEndianOutput;

public final class LittleEndianByteArrayOutputStream
implements LittleEndianOutput,
DelayableLittleEndianOutput {
    private final byte[] _buf;
    private final int _endIndex;
    private int _writeIndex;

    public LittleEndianByteArrayOutputStream(byte[] buf, int startOffset, int maxWriteLen) {
        if (startOffset < 0 || startOffset > buf.length) {
            throw new IllegalArgumentException("Specified startOffset (" + startOffset + ") is out of allowable range (0.." + buf.length + ")");
        }
        this._buf = buf;
        this._writeIndex = startOffset;
        this._endIndex = startOffset + maxWriteLen;
        if (this._endIndex < startOffset || this._endIndex > buf.length) {
            throw new IllegalArgumentException("calculated end index (" + this._endIndex + ") is out of allowable range (" + this._writeIndex + ".." + buf.length + ")");
        }
    }

    public LittleEndianByteArrayOutputStream(byte[] buf, int startOffset) {
        this(buf, startOffset, buf.length - startOffset);
    }

    private void checkPosition(int i2) {
        if (i2 > this._endIndex - this._writeIndex) {
            throw new RuntimeException("Buffer overrun");
        }
    }

    @Override
    public void writeByte(int v2) {
        this.checkPosition(1);
        this._buf[this._writeIndex++] = (byte)v2;
    }

    @Override
    public void writeDouble(double v2) {
        this.writeLong(Double.doubleToLongBits(v2));
    }

    @Override
    public void writeInt(int v2) {
        this.checkPosition(4);
        int i2 = this._writeIndex;
        this._buf[i2++] = (byte)(v2 >>> 0 & 0xFF);
        this._buf[i2++] = (byte)(v2 >>> 8 & 0xFF);
        this._buf[i2++] = (byte)(v2 >>> 16 & 0xFF);
        this._buf[i2++] = (byte)(v2 >>> 24 & 0xFF);
        this._writeIndex = i2;
    }

    @Override
    public void writeLong(long v2) {
        this.writeInt((int)(v2 >> 0));
        this.writeInt((int)(v2 >> 32));
    }

    @Override
    public void writeShort(int v2) {
        this.checkPosition(2);
        int i2 = this._writeIndex;
        this._buf[i2++] = (byte)(v2 >>> 0 & 0xFF);
        this._buf[i2++] = (byte)(v2 >>> 8 & 0xFF);
        this._writeIndex = i2;
    }

    @Override
    public void write(byte[] b2) {
        int len = b2.length;
        this.checkPosition(len);
        System.arraycopy(b2, 0, this._buf, this._writeIndex, len);
        this._writeIndex += len;
    }

    @Override
    public void write(byte[] b2, int offset, int len) {
        this.checkPosition(len);
        System.arraycopy(b2, offset, this._buf, this._writeIndex, len);
        this._writeIndex += len;
    }

    public int getWriteIndex() {
        return this._writeIndex;
    }

    @Override
    public LittleEndianOutput createDelayedOutput(int size) {
        this.checkPosition(size);
        LittleEndianByteArrayOutputStream result = new LittleEndianByteArrayOutputStream(this._buf, this._writeIndex, size);
        this._writeIndex += size;
        return result;
    }
}

