/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.CRC32;
import org.apache.poi.EmptyFileException;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class IOUtils {
    private static final POILogger logger = POILogFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static byte[] peekFirst8Bytes(InputStream stream) throws IOException, EmptyFileException {
        stream.mark(8);
        byte[] header = new byte[8];
        int read = IOUtils.readFully(stream, header);
        if (read < 1) {
            throw new EmptyFileException();
        }
        if (stream instanceof PushbackInputStream) {
            PushbackInputStream pin = (PushbackInputStream)stream;
            pin.unread(header, 0, read);
        } else {
            stream.reset();
        }
        return header;
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        return IOUtils.toByteArray(stream, Integer.MAX_VALUE);
    }

    public static byte[] toByteArray(InputStream stream, int length) throws IOException {
        int readBytes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length == Integer.MAX_VALUE ? 4096 : length);
        byte[] buffer = new byte[4096];
        int totalBytes = 0;
        do {
            readBytes = stream.read(buffer, 0, Math.min(buffer.length, length - totalBytes));
            totalBytes += Math.max(readBytes, 0);
            if (readBytes <= 0) continue;
            baos.write(buffer, 0, readBytes);
        } while (totalBytes < length && readBytes > -1);
        if (length != Integer.MAX_VALUE && totalBytes < length) {
            throw new IOException("unexpected EOF");
        }
        return baos.toByteArray();
    }

    public static byte[] toByteArray(ByteBuffer buffer, int length) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0) {
            return buffer.array();
        }
        byte[] data = new byte[length];
        buffer.get(data);
        return data;
    }

    public static int readFully(InputStream in2, byte[] b2) throws IOException {
        return IOUtils.readFully(in2, b2, 0, b2.length);
    }

    public static int readFully(InputStream in2, byte[] b2, int off, int len) throws IOException {
        int got;
        int total = 0;
        do {
            if ((got = in2.read(b2, off + total, len - total)) >= 0) continue;
            return total == 0 ? -1 : total;
        } while ((total += got) != len);
        return total;
    }

    public static int readFully(ReadableByteChannel channel, ByteBuffer b2) throws IOException {
        int got;
        int total = 0;
        do {
            if ((got = channel.read(b2)) >= 0) continue;
            return total == 0 ? -1 : total;
        } while ((total += got) != b2.capacity() && b2.position() != b2.capacity());
        return total;
    }

    public static void copy(InputStream inp, OutputStream out) throws IOException {
        int count;
        byte[] buff = new byte[4096];
        while ((count = inp.read(buff)) != -1) {
            if (count <= 0) continue;
            out.write(buff, 0, count);
        }
    }

    public static long calculateChecksum(byte[] data) {
        CRC32 sum = new CRC32();
        sum.update(data, 0, data.length);
        return sum.getValue();
    }

    public static long calculateChecksum(InputStream stream) throws IOException {
        int count;
        CRC32 sum = new CRC32();
        byte[] buf = new byte[4096];
        while ((count = stream.read(buf)) != -1) {
            if (count <= 0) continue;
            sum.update(buf, 0, count);
        }
        return sum.getValue();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exc) {
            logger.log(7, (Object)("Unable to close resource: " + exc), exc);
        }
    }
}

