/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.Internal;

public abstract class RowShifter {
    protected final Sheet sheet;

    public RowShifter(Sheet sh) {
        this.sheet = sh;
    }

    public List<CellRangeAddress> shiftMergedRegions(int startRow, int endRow, int n2) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        HashSet<Integer> removedIndices = new HashSet<Integer>();
        int size = this.sheet.getNumMergedRegions();
        for (int i2 = 0; i2 < size; ++i2) {
            boolean inEnd;
            CellRangeAddress merged = this.sheet.getMergedRegion(i2);
            if (startRow + n2 <= merged.getFirstRow() && endRow + n2 >= merged.getLastRow()) {
                removedIndices.add(i2);
                continue;
            }
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl2 = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (!inStart || !inEnd || merged.containsRow(startRow - 1) || merged.containsRow(endRow + 1)) continue;
            merged.setFirstRow(merged.getFirstRow() + n2);
            merged.setLastRow(merged.getLastRow() + n2);
            shiftedRegions.add(merged);
            removedIndices.add(i2);
        }
        if (!removedIndices.isEmpty()) {
            this.sheet.removeMergedRegions(removedIndices);
        }
        for (CellRangeAddress region : shiftedRegions) {
            this.sheet.addMergedRegion(region);
        }
        return shiftedRegions;
    }

    public abstract void updateNamedRanges(FormulaShifter var1);

    public abstract void updateFormulas(FormulaShifter var1);

    @Internal
    public abstract void updateRowFormulas(Row var1, FormulaShifter var2);

    public abstract void updateConditionalFormatting(FormulaShifter var1);

    public abstract void updateHyperlinks(FormulaShifter var1);
}

