/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.ptg;

import org.apache.poi.ss.formula.function.FunctionMetadata;
import org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class FuncPtg
extends AbstractFunctionPtg {
    public static final byte sid = 33;
    public static final int SIZE = 3;

    public static FuncPtg create(LittleEndianInput in2) {
        return FuncPtg.create(in2.readUShort());
    }

    private FuncPtg(int funcIndex, FunctionMetadata fm2) {
        super(funcIndex, fm2.getReturnClassCode(), fm2.getParameterClassCodes(), fm2.getMinParams());
    }

    public static FuncPtg create(int functionIndex) {
        FunctionMetadata fm2 = FunctionMetadataRegistry.getFunctionByIndex(functionIndex);
        if (fm2 == null) {
            throw new RuntimeException("Invalid built-in function index (" + functionIndex + ")");
        }
        return new FuncPtg(functionIndex, fm2);
    }

    @Override
    public void write(LittleEndianOutput out) {
        out.writeByte(33 + this.getPtgClass());
        out.writeShort(this.getFunctionIndex());
    }

    @Override
    public int getSize() {
        return 3;
    }
}

