/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.Calendar;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.formula.functions.Var2or3ArgFunction;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.LocaleUtil;

public class Days360
extends Var2or3ArgFunction {
    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        double result;
        try {
            double d0 = NumericFunction.singleOperandEvaluate(arg0, srcRowIndex, srcColumnIndex);
            double d1 = NumericFunction.singleOperandEvaluate(arg1, srcRowIndex, srcColumnIndex);
            result = Days360.evaluate(d0, d1, false);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
        return new NumberEval(result);
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
        double result;
        try {
            double d0 = NumericFunction.singleOperandEvaluate(arg0, srcRowIndex, srcColumnIndex);
            double d1 = NumericFunction.singleOperandEvaluate(arg1, srcRowIndex, srcColumnIndex);
            ValueEval ve = OperandResolver.getSingleValue(arg2, srcRowIndex, srcColumnIndex);
            Boolean method = OperandResolver.coerceValueToBoolean(ve, false);
            result = Days360.evaluate(d0, d1, method == null ? false : method);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
        return new NumberEval(result);
    }

    private static double evaluate(double d0, double d1, boolean method) {
        Calendar realStart = Days360.getDate(d0);
        Calendar realEnd = Days360.getDate(d1);
        int[] startingDate = Days360.getStartingDate(realStart, method);
        int[] endingDate = Days360.getEndingDate(realEnd, realStart, method);
        return endingDate[0] * 360 + endingDate[1] * 30 + endingDate[2] - (startingDate[0] * 360 + startingDate[1] * 30 + startingDate[2]);
    }

    private static Calendar getDate(double date) {
        Calendar processedDate = LocaleUtil.getLocaleCalendar();
        processedDate.setTime(DateUtil.getJavaDate(date, false));
        return processedDate;
    }

    private static int[] getStartingDate(Calendar realStart, boolean method) {
        Calendar d2 = realStart;
        int yyyy = d2.get(1);
        int mm = d2.get(2);
        int dd2 = Math.min(30, d2.get(5));
        if (!method && Days360.isLastDayOfMonth(d2)) {
            dd2 = 30;
        }
        return new int[]{yyyy, mm, dd2};
    }

    private static int[] getEndingDate(Calendar realEnd, Calendar realStart, boolean method) {
        Calendar d2 = realEnd;
        int yyyy = d2.get(1);
        int mm = d2.get(2);
        int dd2 = Math.min(30, d2.get(5));
        if (!method && realEnd.get(5) == 31) {
            if (realStart.get(5) < 30) {
                d2.set(5, 1);
                d2.add(2, 1);
                yyyy = d2.get(1);
                mm = d2.get(2);
                dd2 = 1;
            } else {
                dd2 = 30;
            }
        }
        return new int[]{yyyy, mm, dd2};
    }

    private static boolean isLastDayOfMonth(Calendar date) {
        int lastDayOfMonth;
        int dayOfMonth = date.get(5);
        return dayOfMonth == (lastDayOfMonth = date.getActualMaximum(5));
    }
}

