/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Map;
import org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.WorkbookEvaluatorProvider;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class BaseFormulaEvaluator
implements FormulaEvaluator,
WorkbookEvaluatorProvider {
    protected final WorkbookEvaluator _bookEvaluator;

    protected BaseFormulaEvaluator(WorkbookEvaluator bookEvaluator) {
        this._bookEvaluator = bookEvaluator;
    }

    public static void setupEnvironment(String[] workbookNames, BaseFormulaEvaluator[] evaluators) {
        WorkbookEvaluator[] wbEvals = new WorkbookEvaluator[evaluators.length];
        for (int i2 = 0; i2 < wbEvals.length; ++i2) {
            wbEvals[i2] = evaluators[i2]._bookEvaluator;
        }
        CollaboratingWorkbooksEnvironment.setup(workbookNames, wbEvals);
    }

    @Override
    public void setupReferencedWorkbooks(Map<String, FormulaEvaluator> evaluators) {
        CollaboratingWorkbooksEnvironment.setupFormulaEvaluator(evaluators);
    }

    @Override
    public WorkbookEvaluator _getWorkbookEvaluator() {
        return this._bookEvaluator;
    }

    @Override
    public void clearAllCachedResultValues() {
        this._bookEvaluator.clearAllCachedResultValues();
    }

    @Override
    public CellValue evaluate(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                return CellValue.valueOf(cell.getBooleanCellValue());
            }
            case ERROR: {
                return CellValue.getError(cell.getErrorCellValue());
            }
            case FORMULA: {
                return this.evaluateFormulaCellValue(cell);
            }
            case NUMERIC: {
                return new CellValue(cell.getNumericCellValue());
            }
            case STRING: {
                return new CellValue(cell.getRichStringCellValue().getString());
            }
            case BLANK: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + (Object)((Object)cell.getCellTypeEnum()) + ")");
    }

    @Override
    public Cell evaluateInCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        Cell result = cell;
        if (cell.getCellTypeEnum() == CellType.FORMULA) {
            CellValue cv2 = this.evaluateFormulaCellValue(cell);
            this.setCellValue(cell, cv2);
            BaseFormulaEvaluator.setCellType(cell, cv2);
        }
        return result;
    }

    protected abstract CellValue evaluateFormulaCellValue(Cell var1);

    @Override
    public int evaluateFormulaCell(Cell cell) {
        return this.evaluateFormulaCellEnum(cell).getCode();
    }

    @Override
    public CellType evaluateFormulaCellEnum(Cell cell) {
        if (cell == null || cell.getCellTypeEnum() != CellType.FORMULA) {
            return CellType._NONE;
        }
        CellValue cv2 = this.evaluateFormulaCellValue(cell);
        this.setCellValue(cell, cv2);
        return cv2.getCellTypeEnum();
    }

    protected static void setCellType(Cell cell, CellValue cv2) {
        CellType cellType = cv2.getCellTypeEnum();
        switch (cellType) {
            case BOOLEAN: 
            case ERROR: 
            case NUMERIC: 
            case STRING: {
                cell.setCellType(cellType);
                return;
            }
            case BLANK: {
                throw new IllegalArgumentException("This should never happen. Blanks eventually get translated to zero.");
            }
            case FORMULA: {
                throw new IllegalArgumentException("This should never happen. Formulas should have already been evaluated.");
            }
        }
        throw new IllegalStateException("Unexpected cell value type (" + (Object)((Object)cellType) + ")");
    }

    protected abstract RichTextString createRichTextString(String var1);

    protected void setCellValue(Cell cell, CellValue cv2) {
        CellType cellType = cv2.getCellTypeEnum();
        switch (cellType) {
            case BOOLEAN: {
                cell.setCellValue(cv2.getBooleanValue());
                break;
            }
            case ERROR: {
                cell.setCellErrorValue(cv2.getErrorValue());
                break;
            }
            case NUMERIC: {
                cell.setCellValue(cv2.getNumberValue());
                break;
            }
            case STRING: {
                cell.setCellValue(this.createRichTextString(cv2.getStringValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell value type (" + (Object)((Object)cellType) + ")");
            }
        }
    }

    public static void evaluateAllFormulaCells(Workbook wb) {
        FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        BaseFormulaEvaluator.evaluateAllFormulaCells(wb, evaluator);
    }

    protected static void evaluateAllFormulaCells(Workbook wb, FormulaEvaluator evaluator) {
        for (int i2 = 0; i2 < wb.getNumberOfSheets(); ++i2) {
            Sheet sheet = wb.getSheetAt(i2);
            for (Row r2 : sheet) {
                for (Cell c2 : r2) {
                    if (c2.getCellTypeEnum() != CellType.FORMULA) continue;
                    evaluator.evaluateFormulaCellEnum(c2);
                }
            }
        }
    }

    @Override
    public void setIgnoreMissingWorkbooks(boolean ignore) {
        this._bookEvaluator.setIgnoreMissingWorkbooks(ignore);
    }

    @Override
    public void setDebugEvaluationOutputForNextEval(boolean value) {
        this._bookEvaluator.setDebugEvaluationOutputForNextEval(value);
    }
}

