/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.usermodel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.OldFileFormatException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.util.IOUtils;

public class SlideShowFactory {
    public static SlideShow<?, ?> create(NPOIFSFileSystem fs2) throws IOException {
        return SlideShowFactory.create(fs2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SlideShow<?, ?> create(NPOIFSFileSystem fs2, String password) throws IOException {
        DirectoryNode root = fs2.getRoot();
        if (root.hasEntry("EncryptedPackage")) {
            InputStream stream = null;
            try {
                stream = DocumentFactoryHelper.getDecryptedStream(fs2, password);
                SlideShow<?, ?> slideShow = SlideShowFactory.createXSLFSlideShow(stream);
                return slideShow;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        if (password != null) {
            Biff8EncryptionKey.setCurrentUserPassword(password);
        }
        try {
            SlideShow<?, ?> slideShow = SlideShowFactory.createHSLFSlideShow(fs2);
            return slideShow;
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

    public static SlideShow<?, ?> create(InputStream inp) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(inp, null);
    }

    public static SlideShow<?, ?> create(InputStream inp, String password) throws IOException, EncryptedDocumentException {
        byte[] header8;
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        if (NPOIFSFileSystem.hasPOIFSHeader(header8 = IOUtils.peekFirst8Bytes(inp))) {
            NPOIFSFileSystem fs2 = new NPOIFSFileSystem(inp);
            return SlideShowFactory.create(fs2, password);
        }
        if (DocumentFactoryHelper.hasOOXMLHeader(inp)) {
            return SlideShowFactory.createXSLFSlideShow(inp);
        }
        throw new IllegalArgumentException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static SlideShow<?, ?> create(File file) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, null);
    }

    public static SlideShow<?, ?> create(File file, String password) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, password, false);
    }

    public static SlideShow<?, ?> create(File file, String password, boolean readOnly) throws IOException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        NPOIFSFileSystem fs2 = null;
        try {
            fs2 = new NPOIFSFileSystem(file, readOnly);
            return SlideShowFactory.create(fs2, password);
        }
        catch (OfficeXmlFileException e2) {
            if (fs2 != null) {
                fs2.close();
            }
            return SlideShowFactory.createXSLFSlideShow(file, readOnly);
        }
        catch (RuntimeException e3) {
            if (fs2 != null) {
                fs2.close();
            }
            throw e3;
        }
    }

    protected static SlideShow<?, ?> createHSLFSlideShow(Object ... args) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("org.apache.poi.hslf.usermodel.HSLFSlideShowFactory", args);
    }

    protected static SlideShow<?, ?> createXSLFSlideShow(Object ... args) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("org.apache.poi.xslf.usermodel.XSLFSlideShowFactory", args);
    }

    protected static SlideShow<?, ?> createSlideShow(String factoryClass, Object[] args) throws IOException, EncryptedDocumentException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
            Class[] argsClz = new Class[args.length];
            int i2 = 0;
            for (Object o2 : args) {
                Class<Object> c2 = o2.getClass();
                if (Boolean.class.isAssignableFrom(c2)) {
                    c2 = Boolean.TYPE;
                } else if (InputStream.class.isAssignableFrom(c2)) {
                    c2 = InputStream.class;
                }
                argsClz[i2++] = c2;
            }
            Method m2 = clazz.getMethod("createSlideShow", argsClz);
            return (SlideShow)m2.invoke(null, args);
        }
        catch (InvocationTargetException e2) {
            Throwable t2 = e2.getCause();
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            if (t2 instanceof EncryptedDocumentException) {
                throw (EncryptedDocumentException)t2;
            }
            if (t2 instanceof OldFileFormatException) {
                throw (OldFileFormatException)t2;
            }
            throw new IOException(t2);
        }
        catch (Exception e3) {
            throw new IOException(e3);
        }
    }
}

