/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.sl.draw.binding.CTCustomGeometry2D;
import org.apache.poi.sl.draw.binding.CTGeomGuide;
import org.apache.poi.sl.draw.binding.CTGeomGuideList;
import org.apache.poi.sl.draw.binding.CTGeomRect;
import org.apache.poi.sl.draw.binding.CTPath2D;
import org.apache.poi.sl.draw.binding.CTPath2DList;
import org.apache.poi.sl.draw.geom.AdjustValue;
import org.apache.poi.sl.draw.geom.ClosePathCommand;
import org.apache.poi.sl.draw.geom.Guide;
import org.apache.poi.sl.draw.geom.LineToCommand;
import org.apache.poi.sl.draw.geom.MoveToCommand;
import org.apache.poi.sl.draw.geom.Path;

public class CustomGeometry
implements Iterable<Path> {
    List<Guide> adjusts = new ArrayList<Guide>();
    List<Guide> guides = new ArrayList<Guide>();
    List<Path> paths = new ArrayList<Path>();
    Path textBounds;

    public CustomGeometry(CTCustomGeometry2D geom) {
        CTGeomRect rect;
        CTPath2DList pathLst;
        CTGeomGuideList gdLst;
        CTGeomGuideList avLst = geom.getAvLst();
        if (avLst != null) {
            for (CTGeomGuide gd2 : avLst.getGd()) {
                this.adjusts.add(new AdjustValue(gd2));
            }
        }
        if ((gdLst = geom.getGdLst()) != null) {
            for (CTGeomGuide gd3 : gdLst.getGd()) {
                this.guides.add(new Guide(gd3));
            }
        }
        if ((pathLst = geom.getPathLst()) != null) {
            for (CTPath2D spPath : pathLst.getPath()) {
                this.paths.add(new Path(spPath));
            }
        }
        if ((rect = geom.getRect()) != null) {
            this.textBounds = new Path();
            this.textBounds.addCommand(new MoveToCommand(rect.getL().toString(), rect.getT().toString()));
            this.textBounds.addCommand(new LineToCommand(rect.getR().toString(), rect.getT().toString()));
            this.textBounds.addCommand(new LineToCommand(rect.getR().toString(), rect.getB().toString()));
            this.textBounds.addCommand(new LineToCommand(rect.getL().toString(), rect.getB().toString()));
            this.textBounds.addCommand(new ClosePathCommand());
        }
    }

    @Override
    public Iterator<Path> iterator() {
        return this.paths.iterator();
    }

    public Path getTextBounds() {
        return this.textBounds;
    }
}

