/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.DrawSimpleShape;
import org.apache.poi.sl.draw.DrawTextParagraph;
import org.apache.poi.sl.usermodel.Insets2D;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.TextShape;

public class DrawTextShape
extends DrawSimpleShape {
    public DrawTextShape(TextShape<?, ?> shape) {
        super((SimpleShape<?, ?>)shape);
    }

    @Override
    public void drawContent(Graphics2D graphics) {
        Double textRot;
        DrawFactory.getInstance(graphics).fixFonts(graphics);
        SimpleShape s2 = this.getShape();
        Rectangle2D anchor = DrawShape.getAnchor(graphics, s2);
        Insets2D insets = s2.getInsets();
        double x2 = anchor.getX() + insets.left;
        double y2 = anchor.getY();
        AffineTransform tx = graphics.getTransform();
        boolean vertFlip = s2.getFlipVertical();
        boolean horzFlip = s2.getFlipHorizontal();
        ShapeContainer sc = s2.getParent();
        while (sc instanceof PlaceableShape) {
            PlaceableShape ps = (PlaceableShape)((Object)sc);
            vertFlip ^= ps.getFlipVertical();
            horzFlip ^= ps.getFlipHorizontal();
            sc = ps.getParent();
        }
        if (horzFlip ^ vertFlip) {
            double ax2 = anchor.getX();
            double ay2 = anchor.getY();
            graphics.translate(ax2 + anchor.getWidth(), ay2);
            graphics.scale(-1.0, 1.0);
            graphics.translate(-ax2, -ay2);
        }
        if ((textRot = s2.getTextRotation()) != null && textRot != 0.0) {
            double cx2 = anchor.getCenterX();
            double cy2 = anchor.getCenterY();
            graphics.translate(cx2, cy2);
            graphics.rotate(Math.toRadians(textRot));
            graphics.translate(-cx2, -cy2);
        }
        switch (s2.getVerticalAlignment()) {
            default: {
                y2 += insets.top;
                break;
            }
            case BOTTOM: {
                double textHeight = this.getTextHeight(graphics);
                y2 += anchor.getHeight() - textHeight - insets.bottom;
                break;
            }
            case MIDDLE: {
                double textHeight = this.getTextHeight(graphics);
                double delta = anchor.getHeight() - textHeight - insets.top - insets.bottom;
                y2 += insets.top + delta / 2.0;
            }
        }
        TextShape.TextDirection textDir = s2.getTextDirection();
        if (textDir == TextShape.TextDirection.VERTICAL || textDir == TextShape.TextDirection.VERTICAL_270) {
            double deg = textDir == TextShape.TextDirection.VERTICAL ? 90.0 : 270.0;
            double cx3 = anchor.getCenterX();
            double cy3 = anchor.getCenterY();
            graphics.translate(cx3, cy3);
            graphics.rotate(Math.toRadians(deg));
            graphics.translate(-cx3, -cy3);
            double w2 = anchor.getWidth();
            double h2 = anchor.getHeight();
            double dx2 = (w2 - h2) / 2.0;
            graphics.translate(dx2, -dx2);
        }
        this.drawParagraphs(graphics, x2, y2);
        graphics.setTransform(tx);
    }

    public double drawParagraphs(Graphics2D graphics, double x2, double y2) {
        DrawFactory fact = DrawFactory.getInstance(graphics);
        double y0 = y2;
        Iterator paragraphs = this.getShape().iterator();
        boolean isFirstLine = true;
        int autoNbrIdx = 0;
        while (paragraphs.hasNext()) {
            TextParagraph p2 = (TextParagraph)paragraphs.next();
            DrawTextParagraph dp2 = fact.getDrawable(p2);
            TextParagraph.BulletStyle bs2 = p2.getBulletStyle();
            if (bs2 == null || bs2.getAutoNumberingScheme() == null) {
                autoNbrIdx = -1;
            } else {
                Integer startAt = bs2.getAutoNumberingStartAt();
                if (startAt == null) {
                    startAt = 1;
                }
                if (startAt > autoNbrIdx) {
                    autoNbrIdx = startAt;
                }
            }
            dp2.setAutoNumberingIdx(autoNbrIdx);
            dp2.breakText(graphics);
            if (!isFirstLine) {
                Double spaceBefore = p2.getSpaceBefore();
                if (spaceBefore == null) {
                    spaceBefore = 0.0;
                }
                y2 = spaceBefore > 0.0 ? (y2 += spaceBefore * 0.01 * (double)dp2.getFirstLineHeight()) : (y2 += -spaceBefore.doubleValue());
            }
            isFirstLine = false;
            dp2.setPosition(x2, y2);
            dp2.draw(graphics);
            y2 += dp2.getY();
            if (paragraphs.hasNext()) {
                Double spaceAfter = p2.getSpaceAfter();
                if (spaceAfter == null) {
                    spaceAfter = 0.0;
                }
                y2 = spaceAfter > 0.0 ? (y2 += spaceAfter * 0.01 * (double)dp2.getLastLineHeight()) : (y2 += -spaceAfter.doubleValue());
            }
            ++autoNbrIdx;
        }
        return y2 - y0;
    }

    public double getTextHeight() {
        return this.getTextHeight(null);
    }

    protected double getTextHeight(Graphics2D oldGraphics) {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D graphics = img.createGraphics();
        if (oldGraphics != null) {
            graphics.addRenderingHints(oldGraphics.getRenderingHints());
            graphics.setTransform(oldGraphics.getTransform());
        }
        DrawFactory.getInstance(graphics).fixFonts(graphics);
        return this.drawParagraphs(graphics, 0.0, 0.0);
    }

    @Override
    protected TextShape<?, ?> getShape() {
        return (TextShape)this.shape;
    }
}

