/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.NPOIFSStream;
import org.apache.poi.poifs.property.NPropertyTable;
import org.apache.poi.poifs.storage.HeaderBlock;
import org.apache.poi.util.IOUtils;

public class POIFSDump {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Must specify at least one file to dump");
            System.exit(1);
        }
        boolean dumpProps = false;
        boolean dumpMini = false;
        for (String filename : args) {
            NPOIFSFileSystem fs2;
            if (filename.equalsIgnoreCase("-dumprops") || filename.equalsIgnoreCase("-dump-props") || filename.equalsIgnoreCase("-dump-properties")) {
                dumpProps = true;
                continue;
            }
            if (filename.equalsIgnoreCase("-dumpmini") || filename.equalsIgnoreCase("-dump-mini") || filename.equalsIgnoreCase("-dump-ministream") || filename.equalsIgnoreCase("-dump-mini-stream")) {
                dumpMini = true;
                continue;
            }
            System.out.println("Dumping " + filename);
            FileInputStream is2 = new FileInputStream(filename);
            try {
                fs2 = new NPOIFSFileSystem(is2);
            }
            finally {
                is2.close();
            }
            try {
                DirectoryNode root = fs2.getRoot();
                File file = new File(new File(filename).getName(), root.getName());
                if (!file.exists() && !file.mkdirs()) {
                    throw new IOException("Could not create directory " + file);
                }
                POIFSDump.dump(root, file);
                if (dumpProps) {
                    HeaderBlock header = fs2.getHeaderBlock();
                    POIFSDump.dump(fs2, header.getPropertyStart(), "properties", file);
                }
                if (!dumpMini) continue;
                NPropertyTable props = fs2.getPropertyTable();
                int startBlock = props.getRoot().getStartBlock();
                if (startBlock == -2) {
                    System.err.println("No Mini Stream in file");
                    continue;
                }
                POIFSDump.dump(fs2, startBlock, "mini-stream", file);
            }
            finally {
                fs2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(DirectoryEntry root, File parent) throws IOException {
        Iterator<Entry> it2 = root.getEntries();
        while (it2.hasNext()) {
            Entry entry = it2.next();
            if (entry instanceof DocumentNode) {
                DocumentNode node = (DocumentNode)entry;
                DocumentInputStream is2 = new DocumentInputStream(node);
                byte[] bytes = IOUtils.toByteArray(is2);
                is2.close();
                FileOutputStream out = new FileOutputStream(new File(parent, node.getName().trim()));
                try {
                    ((OutputStream)out).write(bytes);
                    continue;
                }
                finally {
                    ((OutputStream)out).close();
                    continue;
                }
            }
            if (entry instanceof DirectoryEntry) {
                DirectoryEntry dir = (DirectoryEntry)entry;
                File file = new File(parent, entry.getName());
                if (!file.exists() && !file.mkdirs()) {
                    throw new IOException("Could not create directory " + file);
                }
                POIFSDump.dump(dir, file);
                continue;
            }
            System.err.println("Skipping unsupported POIFS entry: " + entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(NPOIFSFileSystem fs2, int startBlock, String name, File parent) throws IOException {
        File file = new File(parent, name);
        FileOutputStream out = new FileOutputStream(file);
        try {
            NPOIFSStream stream = new NPOIFSStream(fs2, startBlock);
            byte[] b2 = new byte[fs2.getBigBlockSize()];
            for (ByteBuffer bb2 : stream) {
                int len = bb2.remaining();
                bb2.get(b2);
                out.write(b2, 0, len);
            }
        }
        finally {
            out.close();
        }
    }
}

