/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.dsig;

import org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SignatureMarshalListener
implements EventListener,
SignatureConfig.SignatureConfigurable {
    ThreadLocal<EventTarget> target = new ThreadLocal();
    SignatureConfig signatureConfig;

    public void setEventTarget(EventTarget target) {
        this.target.set(target);
    }

    @Override
    public void handleEvent(Event e2) {
        if (!(e2 instanceof MutationEvent)) {
            return;
        }
        MutationEvent mutEvt = (MutationEvent)e2;
        EventTarget et2 = mutEvt.getTarget();
        if (!(et2 instanceof Element)) {
            return;
        }
        this.handleElement((Element)((Object)et2));
    }

    public void handleElement(Element el2) {
        EventTarget target = this.target.get();
        String packageId = this.signatureConfig.getPackageSignatureId();
        if (el2.hasAttribute("Id")) {
            el2.setIdAttribute("Id", true);
        }
        SignatureMarshalListener.setListener(target, this, false);
        if (packageId.equals(el2.getAttribute("Id"))) {
            el2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        }
        this.setPrefix(el2);
        SignatureMarshalListener.setListener(target, this, true);
    }

    public static void setListener(EventTarget target, EventListener listener, boolean enabled) {
        String type = "DOMSubtreeModified";
        boolean useCapture = false;
        if (enabled) {
            target.addEventListener(type, listener, useCapture);
        } else {
            target.removeEventListener(type, listener, useCapture);
        }
    }

    protected void setPrefix(Node el2) {
        String prefix = this.signatureConfig.getNamespacePrefixes().get(el2.getNamespaceURI());
        if (prefix != null && el2.getPrefix() == null) {
            el2.setPrefix(prefix);
        }
        NodeList nl = el2.getChildNodes();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            this.setPrefix(nl.item(i2));
        }
    }

    @Override
    public void setSignatureConfig(SignatureConfig signatureConfig) {
        this.signatureConfig = signatureConfig;
    }
}

