/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageProperties;
import org.apache.poi.openxml4j.util.Nullable;
import org.apache.poi.util.LocaleUtil;

public final class PackagePropertiesPart
extends PackagePart
implements PackageProperties {
    public static final String NAMESPACE_DC_URI = "http://purl.org/dc/elements/1.1/";
    public static final String NAMESPACE_CP_URI = "http://schemas.openxmlformats.org/package/2006/metadata/core-properties";
    public static final String NAMESPACE_DCTERMS_URI = "http://purl.org/dc/terms/";
    private static final String DEFAULT_DATEFORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SS'Z'"};
    private final String[] TZ_DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss.Sz", "yyyy-MM-dd'T'HH:mm:ss.SSz", "yyyy-MM-dd'T'HH:mm:ss.SSSz"};
    private final Pattern TIME_ZONE_PAT = Pattern.compile("([-+]\\d\\d):?(\\d\\d)");
    protected Nullable<String> category = new Nullable();
    protected Nullable<String> contentStatus = new Nullable();
    protected Nullable<String> contentType = new Nullable();
    protected Nullable<Date> created = new Nullable();
    protected Nullable<String> creator = new Nullable();
    protected Nullable<String> description = new Nullable();
    protected Nullable<String> identifier = new Nullable();
    protected Nullable<String> keywords = new Nullable();
    protected Nullable<String> language = new Nullable();
    protected Nullable<String> lastModifiedBy = new Nullable();
    protected Nullable<Date> lastPrinted = new Nullable();
    protected Nullable<Date> modified = new Nullable();
    protected Nullable<String> revision = new Nullable();
    protected Nullable<String> subject = new Nullable();
    protected Nullable<String> title = new Nullable();
    protected Nullable<String> version = new Nullable();

    public PackagePropertiesPart(OPCPackage pack, PackagePartName partName) throws InvalidFormatException {
        super(pack, partName, "application/vnd.openxmlformats-package.core-properties+xml");
    }

    @Override
    public Nullable<String> getCategoryProperty() {
        return this.category;
    }

    @Override
    public Nullable<String> getContentStatusProperty() {
        return this.contentStatus;
    }

    @Override
    public Nullable<String> getContentTypeProperty() {
        return this.contentType;
    }

    @Override
    public Nullable<Date> getCreatedProperty() {
        return this.created;
    }

    public String getCreatedPropertyString() {
        return this.getDateValue(this.created);
    }

    @Override
    public Nullable<String> getCreatorProperty() {
        return this.creator;
    }

    @Override
    public Nullable<String> getDescriptionProperty() {
        return this.description;
    }

    @Override
    public Nullable<String> getIdentifierProperty() {
        return this.identifier;
    }

    @Override
    public Nullable<String> getKeywordsProperty() {
        return this.keywords;
    }

    @Override
    public Nullable<String> getLanguageProperty() {
        return this.language;
    }

    @Override
    public Nullable<String> getLastModifiedByProperty() {
        return this.lastModifiedBy;
    }

    @Override
    public Nullable<Date> getLastPrintedProperty() {
        return this.lastPrinted;
    }

    public String getLastPrintedPropertyString() {
        return this.getDateValue(this.lastPrinted);
    }

    @Override
    public Nullable<Date> getModifiedProperty() {
        return this.modified;
    }

    public String getModifiedPropertyString() {
        if (this.modified.hasValue()) {
            return this.getDateValue(this.modified);
        }
        return this.getDateValue(new Nullable<Date>(new Date()));
    }

    @Override
    public Nullable<String> getRevisionProperty() {
        return this.revision;
    }

    @Override
    public Nullable<String> getSubjectProperty() {
        return this.subject;
    }

    @Override
    public Nullable<String> getTitleProperty() {
        return this.title;
    }

    @Override
    public Nullable<String> getVersionProperty() {
        return this.version;
    }

    @Override
    public void setCategoryProperty(String category) {
        this.category = this.setStringValue(category);
    }

    @Override
    public void setContentStatusProperty(String contentStatus) {
        this.contentStatus = this.setStringValue(contentStatus);
    }

    @Override
    public void setContentTypeProperty(String contentType) {
        this.contentType = this.setStringValue(contentType);
    }

    @Override
    public void setCreatedProperty(String created) {
        try {
            this.created = this.setDateValue(created);
        }
        catch (InvalidFormatException e2) {
            throw new IllegalArgumentException("Date for created could not be parsed: " + created, e2);
        }
    }

    @Override
    public void setCreatedProperty(Nullable<Date> created) {
        if (created.hasValue()) {
            this.created = created;
        }
    }

    @Override
    public void setCreatorProperty(String creator) {
        this.creator = this.setStringValue(creator);
    }

    @Override
    public void setDescriptionProperty(String description) {
        this.description = this.setStringValue(description);
    }

    @Override
    public void setIdentifierProperty(String identifier) {
        this.identifier = this.setStringValue(identifier);
    }

    @Override
    public void setKeywordsProperty(String keywords) {
        this.keywords = this.setStringValue(keywords);
    }

    @Override
    public void setLanguageProperty(String language) {
        this.language = this.setStringValue(language);
    }

    @Override
    public void setLastModifiedByProperty(String lastModifiedBy) {
        this.lastModifiedBy = this.setStringValue(lastModifiedBy);
    }

    @Override
    public void setLastPrintedProperty(String lastPrinted) {
        try {
            this.lastPrinted = this.setDateValue(lastPrinted);
        }
        catch (InvalidFormatException e2) {
            throw new IllegalArgumentException("lastPrinted  : " + e2.getLocalizedMessage(), e2);
        }
    }

    @Override
    public void setLastPrintedProperty(Nullable<Date> lastPrinted) {
        if (lastPrinted.hasValue()) {
            this.lastPrinted = lastPrinted;
        }
    }

    @Override
    public void setModifiedProperty(String modified) {
        try {
            this.modified = this.setDateValue(modified);
        }
        catch (InvalidFormatException e2) {
            throw new IllegalArgumentException("modified  : " + e2.getLocalizedMessage(), e2);
        }
    }

    @Override
    public void setModifiedProperty(Nullable<Date> modified) {
        if (modified.hasValue()) {
            this.modified = modified;
        }
    }

    @Override
    public void setRevisionProperty(String revision) {
        this.revision = this.setStringValue(revision);
    }

    @Override
    public void setSubjectProperty(String subject) {
        this.subject = this.setStringValue(subject);
    }

    @Override
    public void setTitleProperty(String title) {
        this.title = this.setStringValue(title);
    }

    @Override
    public void setVersionProperty(String version) {
        this.version = this.setStringValue(version);
    }

    private Nullable<String> setStringValue(String s2) {
        if (s2 == null || s2.equals("")) {
            return new Nullable<String>();
        }
        return new Nullable<String>(s2);
    }

    private Nullable<Date> setDateValue(String dateStr) throws InvalidFormatException {
        Date d2;
        SimpleDateFormat df2;
        String dateTzStr;
        if (dateStr == null || dateStr.equals("")) {
            return new Nullable<Date>();
        }
        Matcher m2 = this.TIME_ZONE_PAT.matcher(dateStr);
        if (m2.find()) {
            dateTzStr = dateStr.substring(0, m2.start()) + m2.group(1) + m2.group(2);
            for (String fStr : this.TZ_DATE_FORMATS) {
                df2 = new SimpleDateFormat(fStr, Locale.ROOT);
                df2.setTimeZone(LocaleUtil.TIMEZONE_UTC);
                d2 = df2.parse(dateTzStr, new ParsePosition(0));
                if (d2 == null) continue;
                return new Nullable<Date>(d2);
            }
        }
        dateTzStr = dateStr.endsWith("Z") ? dateStr : dateStr + "Z";
        for (String fStr : DATE_FORMATS) {
            df2 = new SimpleDateFormat(fStr, Locale.ROOT);
            df2.setTimeZone(LocaleUtil.TIMEZONE_UTC);
            d2 = df2.parse(dateTzStr, new ParsePosition(0));
            if (d2 == null) continue;
            return new Nullable<Date>(d2);
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        for (String fStr : this.TZ_DATE_FORMATS) {
            if (i2++ > 0) {
                sb.append(", ");
            }
            sb.append(fStr);
        }
        for (String fStr : DATE_FORMATS) {
            sb.append(", ").append(fStr);
        }
        throw new InvalidFormatException("Date " + dateStr + " not well formatted, " + "expected format in: " + sb.toString());
    }

    private String getDateValue(Nullable<Date> d2) {
        if (d2 == null) {
            return "";
        }
        Date date = d2.getValue();
        if (date == null) {
            return "";
        }
        SimpleDateFormat df2 = new SimpleDateFormat(DEFAULT_DATEFORMAT, Locale.ROOT);
        df2.setTimeZone(LocaleUtil.TIMEZONE_UTC);
        return df2.format(date);
    }

    @Override
    protected InputStream getInputStreamImpl() {
        throw new InvalidOperationException("Operation not authorized. This part may only be manipulated using the getters and setters on PackagePropertiesPart");
    }

    @Override
    protected OutputStream getOutputStreamImpl() {
        throw new InvalidOperationException("Can't use output stream to set properties !");
    }

    @Override
    public boolean save(OutputStream zos) {
        throw new InvalidOperationException("Operation not authorized. This part may only be manipulated using the getters and setters on PackagePropertiesPart");
    }

    @Override
    public boolean load(InputStream ios) {
        throw new InvalidOperationException("Operation not authorized. This part may only be manipulated using the getters and setters on PackagePropertiesPart");
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

