/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.CFRule12Record;
import org.apache.poi.hssf.record.cf.ColorGradientFormatting;
import org.apache.poi.hssf.record.cf.ColorGradientThreshold;
import org.apache.poi.hssf.record.common.ExtendedColor;
import org.apache.poi.hssf.usermodel.HSSFConditionalFormattingThreshold;
import org.apache.poi.hssf.usermodel.HSSFExtendedColor;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.ColorScaleFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;

public final class HSSFColorScaleFormatting
implements ColorScaleFormatting {
    private final HSSFSheet sheet;
    private final CFRule12Record cfRule12Record;
    private final ColorGradientFormatting colorFormatting;

    protected HSSFColorScaleFormatting(CFRule12Record cfRule12Record, HSSFSheet sheet) {
        this.sheet = sheet;
        this.cfRule12Record = cfRule12Record;
        this.colorFormatting = this.cfRule12Record.getColorGradientFormatting();
    }

    @Override
    public int getNumControlPoints() {
        return this.colorFormatting.getNumControlPoints();
    }

    @Override
    public void setNumControlPoints(int num) {
        this.colorFormatting.setNumControlPoints(num);
    }

    public HSSFExtendedColor[] getColors() {
        ExtendedColor[] colors = this.colorFormatting.getColors();
        HSSFExtendedColor[] hcolors = new HSSFExtendedColor[colors.length];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            hcolors[i2] = new HSSFExtendedColor(colors[i2]);
        }
        return hcolors;
    }

    @Override
    public void setColors(Color[] colors) {
        ExtendedColor[] cr2 = new ExtendedColor[colors.length];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            cr2[i2] = ((HSSFExtendedColor)colors[i2]).getExtendedColor();
        }
        this.colorFormatting.setColors(cr2);
    }

    public HSSFConditionalFormattingThreshold[] getThresholds() {
        ColorGradientThreshold[] t2 = this.colorFormatting.getThresholds();
        HSSFConditionalFormattingThreshold[] ht2 = new HSSFConditionalFormattingThreshold[t2.length];
        for (int i2 = 0; i2 < t2.length; ++i2) {
            ht2[i2] = new HSSFConditionalFormattingThreshold(t2[i2], this.sheet);
        }
        return ht2;
    }

    @Override
    public void setThresholds(ConditionalFormattingThreshold[] thresholds) {
        ColorGradientThreshold[] t2 = new ColorGradientThreshold[thresholds.length];
        for (int i2 = 0; i2 < t2.length; ++i2) {
            HSSFConditionalFormattingThreshold hssfT = (HSSFConditionalFormattingThreshold)thresholds[i2];
            t2[i2] = (ColorGradientThreshold)hssfT.getThreshold();
        }
        this.colorFormatting.setThresholds(t2);
    }

    @Override
    public HSSFConditionalFormattingThreshold createThreshold() {
        return new HSSFConditionalFormattingThreshold(new ColorGradientThreshold(), this.sheet);
    }
}

